/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.SubtasksTimesHandler;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedJobGenerationUtils;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SubtasksTimesHandlerTest
extends TestLogger {
    @Test
    public void testArchiver() throws Exception {
        SubtasksTimesHandler.SubtasksTimesJsonArchivist archivist = new SubtasksTimesHandler.SubtasksTimesJsonArchivist();
        AccessExecutionGraph originalJob = ArchivedJobGenerationUtils.getTestJob();
        AccessExecutionJobVertex originalTask = ArchivedJobGenerationUtils.getTestTask();
        AccessExecution originalAttempt = ArchivedJobGenerationUtils.getTestAttempt();
        Collection archives = archivist.archiveJsonWithPath(originalJob);
        Assert.assertEquals((long)1L, (long)archives.size());
        ArchivedJson archive = (ArchivedJson)archives.iterator().next();
        Assert.assertEquals((Object)("/jobs/" + originalJob.getJobID() + "/vertices/" + originalTask.getJobVertexId() + "/subtasktimes"), (Object)archive.getPath());
        SubtasksTimesHandlerTest.compareSubtaskTimes(originalTask, originalAttempt, archive.getJson());
    }

    @Test
    public void testGetPaths() {
        SubtasksTimesHandler handler = new SubtasksTimesHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor());
        String[] paths = handler.getPaths();
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)"/jobs/:jobid/vertices/:vertexid/subtasktimes", (Object)paths[0]);
    }

    @Test
    public void testJsonGeneration() throws Exception {
        AccessExecutionJobVertex originalTask = ArchivedJobGenerationUtils.getTestTask();
        AccessExecution originalAttempt = ArchivedJobGenerationUtils.getTestAttempt();
        String json = SubtasksTimesHandler.createSubtaskTimesJson((AccessExecutionJobVertex)originalTask);
        SubtasksTimesHandlerTest.compareSubtaskTimes(originalTask, originalAttempt, json);
    }

    private static void compareSubtaskTimes(AccessExecutionJobVertex originalTask, AccessExecution originalAttempt, String json) throws IOException {
        JsonNode result = ArchivedJobGenerationUtils.MAPPER.readTree(json);
        Assert.assertEquals((Object)originalTask.getJobVertexId().toString(), (Object)result.get("id").asText());
        Assert.assertEquals((Object)originalTask.getName(), (Object)result.get("name").asText());
        Assert.assertTrue((result.get("now").asLong() > 0L ? 1 : 0) != 0);
        ArrayNode subtasks = (ArrayNode)result.get("subtasks");
        JsonNode subtask = subtasks.get(0);
        Assert.assertEquals((long)0L, (long)subtask.get("subtask").asInt());
        Assert.assertEquals((Object)originalAttempt.getAssignedResourceLocation().getHostname(), (Object)subtask.get("host").asText());
        Assert.assertEquals((long)(originalAttempt.getStateTimestamp(originalAttempt.getState()) - originalAttempt.getStateTimestamp(ExecutionState.SCHEDULED)), (long)subtask.get("duration").asLong());
        JsonNode timestamps = subtask.get("timestamps");
        Assert.assertEquals((long)originalAttempt.getStateTimestamp(ExecutionState.CREATED), (long)timestamps.get(ExecutionState.CREATED.name()).asLong());
        Assert.assertEquals((long)originalAttempt.getStateTimestamp(ExecutionState.SCHEDULED), (long)timestamps.get(ExecutionState.SCHEDULED.name()).asLong());
        Assert.assertEquals((long)originalAttempt.getStateTimestamp(ExecutionState.DEPLOYING), (long)timestamps.get(ExecutionState.DEPLOYING.name()).asLong());
        Assert.assertEquals((long)originalAttempt.getStateTimestamp(ExecutionState.RUNNING), (long)timestamps.get(ExecutionState.RUNNING.name()).asLong());
        Assert.assertEquals((long)originalAttempt.getStateTimestamp(ExecutionState.FINISHED), (long)timestamps.get(ExecutionState.FINISHED.name()).asLong());
        Assert.assertEquals((long)originalAttempt.getStateTimestamp(ExecutionState.CANCELING), (long)timestamps.get(ExecutionState.CANCELING.name()).asLong());
        Assert.assertEquals((long)originalAttempt.getStateTimestamp(ExecutionState.CANCELED), (long)timestamps.get(ExecutionState.CANCELED.name()).asLong());
        Assert.assertEquals((long)originalAttempt.getStateTimestamp(ExecutionState.FAILED), (long)timestamps.get(ExecutionState.FAILED.name()).asLong());
    }
}

