/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.checkpoints;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointStatsHistory;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.checkpoint.CheckpointStatsStatus;
import org.apache.flink.runtime.checkpoint.MinMaxAvgStats;
import org.apache.flink.runtime.checkpoint.PendingCheckpointStats;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.handler.job.checkpoints.CheckpointStatsCache;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.checkpoints.CheckpointStatsDetailsSubtasksHandler;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CheckpointStatsSubtaskDetailsHandlerTest {
    @Test
    public void testArchiver() throws Exception {
        CheckpointStatsDetailsSubtasksHandler.CheckpointStatsDetailsSubtasksJsonArchivist archivist = new CheckpointStatsDetailsSubtasksHandler.CheckpointStatsDetailsSubtasksJsonArchivist();
        ObjectMapper mapper = new ObjectMapper();
        PendingCheckpointStats checkpoint = (PendingCheckpointStats)Mockito.mock(PendingCheckpointStats.class);
        Mockito.when((Object)checkpoint.getCheckpointId()).thenReturn((Object)1992139L);
        Mockito.when((Object)checkpoint.getStatus()).thenReturn((Object)CheckpointStatsStatus.IN_PROGRESS);
        Mockito.when((Object)checkpoint.getTriggerTimestamp()).thenReturn((Object)0L);
        TaskStateStats task = CheckpointStatsSubtaskDetailsHandlerTest.createTaskStateStats(1237);
        Mockito.when((Object)checkpoint.getAllTaskStateStats()).thenReturn(Collections.singletonList(task));
        CheckpointStatsHistory history = (CheckpointStatsHistory)Mockito.mock(CheckpointStatsHistory.class);
        Mockito.when((Object)history.getCheckpoints()).thenReturn(Collections.singletonList(checkpoint));
        CheckpointStatsSnapshot snapshot = (CheckpointStatsSnapshot)Mockito.mock(CheckpointStatsSnapshot.class);
        Mockito.when((Object)snapshot.getHistory()).thenReturn((Object)history);
        AccessExecutionGraph graph = (AccessExecutionGraph)Mockito.mock(AccessExecutionGraph.class);
        Mockito.when((Object)graph.getCheckpointStatsSnapshot()).thenReturn((Object)snapshot);
        Mockito.when((Object)graph.getJobID()).thenReturn((Object)new JobID());
        Collection archives = archivist.archiveJsonWithPath(graph);
        Assert.assertEquals((long)1L, (long)archives.size());
        ArchivedJson archive = (ArchivedJson)archives.iterator().next();
        Assert.assertEquals((Object)("/jobs/" + graph.getJobID() + "/checkpoints/details/" + checkpoint.getCheckpointId() + "/subtasks/" + task.getJobVertexId()), (Object)archive.getPath());
        JsonNode rootNode = mapper.readTree(archive.getJson());
        Assert.assertEquals((long)checkpoint.getCheckpointId(), (long)rootNode.get("id").asLong());
        Assert.assertEquals((Object)checkpoint.getStatus().toString(), (Object)rootNode.get("status").asText());
        CheckpointStatsSubtaskDetailsHandlerTest.verifyTaskNode(rootNode, task, checkpoint.getTriggerTimestamp());
    }

    @Test
    public void testGetPaths() {
        CheckpointStatsDetailsSubtasksHandler handler = new CheckpointStatsDetailsSubtasksHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor(), new CheckpointStatsCache(0));
        String[] paths = handler.getPaths();
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)"/jobs/:jobid/checkpoints/details/:checkpointid/subtasks/:vertexid", (Object)paths[0]);
    }

    @Test
    public void testSubtaskRequest() throws Exception {
        PendingCheckpointStats checkpoint = (PendingCheckpointStats)Mockito.mock(PendingCheckpointStats.class);
        Mockito.when((Object)checkpoint.getCheckpointId()).thenReturn((Object)1992139L);
        Mockito.when((Object)checkpoint.getStatus()).thenReturn((Object)CheckpointStatsStatus.IN_PROGRESS);
        Mockito.when((Object)checkpoint.getTriggerTimestamp()).thenReturn((Object)0L);
        TaskStateStats task = CheckpointStatsSubtaskDetailsHandlerTest.createTaskStateStats(1237);
        Mockito.when((Object)checkpoint.getTaskStateStats((JobVertexID)Matchers.any(JobVertexID.class))).thenReturn((Object)task);
        JsonNode rootNode = CheckpointStatsSubtaskDetailsHandlerTest.triggerRequest((AbstractCheckpointStats)checkpoint);
        Assert.assertEquals((long)checkpoint.getCheckpointId(), (long)rootNode.get("id").asLong());
        Assert.assertEquals((Object)checkpoint.getStatus().toString(), (Object)rootNode.get("status").asText());
        CheckpointStatsSubtaskDetailsHandlerTest.verifyTaskNode(rootNode, task, checkpoint.getTriggerTimestamp());
    }

    @Test
    public void testSubtaskRequestNoSummary() throws Exception {
        PendingCheckpointStats checkpoint = (PendingCheckpointStats)Mockito.mock(PendingCheckpointStats.class);
        Mockito.when((Object)checkpoint.getCheckpointId()).thenReturn((Object)1992139L);
        Mockito.when((Object)checkpoint.getStatus()).thenReturn((Object)CheckpointStatsStatus.IN_PROGRESS);
        Mockito.when((Object)checkpoint.getTriggerTimestamp()).thenReturn((Object)0L);
        TaskStateStats task = CheckpointStatsSubtaskDetailsHandlerTest.createTaskStateStats(0);
        Mockito.when((Object)checkpoint.getTaskStateStats((JobVertexID)Matchers.any(JobVertexID.class))).thenReturn((Object)task);
        JsonNode rootNode = CheckpointStatsSubtaskDetailsHandlerTest.triggerRequest((AbstractCheckpointStats)checkpoint);
        Assert.assertNull((Object)rootNode.get("summary"));
    }

    @Test
    public void testIllegalCheckpointId() throws Exception {
        AccessExecutionGraph graph = (AccessExecutionGraph)Mockito.mock(AccessExecutionGraph.class);
        CheckpointStatsDetailsSubtasksHandler handler = new CheckpointStatsDetailsSubtasksHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor(), new CheckpointStatsCache(0));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("checkpointid", "illegal checkpoint");
        String json = (String)handler.handleRequest(graph, params).get();
        Assert.assertEquals((Object)"{}", (Object)json);
    }

    @Test
    public void testNoCheckpointIdParam() throws Exception {
        AccessExecutionGraph graph = (AccessExecutionGraph)Mockito.mock(AccessExecutionGraph.class);
        CheckpointStatsDetailsSubtasksHandler handler = new CheckpointStatsDetailsSubtasksHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor(), new CheckpointStatsCache(0));
        String json = (String)handler.handleRequest(graph, Collections.emptyMap()).get();
        Assert.assertEquals((Object)"{}", (Object)json);
    }

    @Test
    public void testCheckpointNotFound() throws Exception {
        CheckpointStatsHistory history = (CheckpointStatsHistory)Mockito.mock(CheckpointStatsHistory.class);
        Mockito.when((Object)history.getCheckpointById(Matchers.anyLong())).thenReturn(null);
        CheckpointStatsSnapshot snapshot = (CheckpointStatsSnapshot)Mockito.mock(CheckpointStatsSnapshot.class);
        Mockito.when((Object)snapshot.getHistory()).thenReturn((Object)history);
        AccessExecutionGraph graph = (AccessExecutionGraph)Mockito.mock(AccessExecutionGraph.class);
        Mockito.when((Object)graph.getCheckpointStatsSnapshot()).thenReturn((Object)snapshot);
        CheckpointStatsDetailsSubtasksHandler handler = new CheckpointStatsDetailsSubtasksHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor(), new CheckpointStatsCache(0));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("checkpointid", "123");
        params.put("vertexid", new JobVertexID().toString());
        String json = (String)handler.handleRequest(graph, params).get();
        Assert.assertEquals((Object)"{}", (Object)json);
        ((CheckpointStatsHistory)Mockito.verify((Object)history, (VerificationMode)Mockito.times((int)1))).getCheckpointById(Matchers.anyLong());
    }

    @Test
    public void testIllegalJobVertexIdParam() throws Exception {
        AccessExecutionGraph graph = (AccessExecutionGraph)Mockito.mock(AccessExecutionGraph.class);
        CheckpointStatsDetailsSubtasksHandler handler = new CheckpointStatsDetailsSubtasksHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor(), new CheckpointStatsCache(0));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("checkpointid", "1");
        params.put("vertexid", "illegal vertex id");
        String json = (String)handler.handleRequest(graph, params).get();
        Assert.assertEquals((Object)"{}", (Object)json);
    }

    @Test
    public void testNoJobVertexIdParam() throws Exception {
        AccessExecutionGraph graph = (AccessExecutionGraph)Mockito.mock(AccessExecutionGraph.class);
        CheckpointStatsDetailsSubtasksHandler handler = new CheckpointStatsDetailsSubtasksHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor(), new CheckpointStatsCache(0));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("checkpointid", "1");
        String json = (String)handler.handleRequest(graph, params).get();
        Assert.assertEquals((Object)"{}", (Object)json);
    }

    @Test
    public void testJobVertexNotFound() throws Exception {
        PendingCheckpointStats inProgress = (PendingCheckpointStats)Mockito.mock(PendingCheckpointStats.class);
        Mockito.when((Object)inProgress.getTaskStateStats((JobVertexID)Matchers.any(JobVertexID.class))).thenReturn(null);
        CheckpointStatsHistory history = (CheckpointStatsHistory)Mockito.mock(CheckpointStatsHistory.class);
        Mockito.when((Object)history.getCheckpointById(Matchers.anyLong())).thenReturn((Object)inProgress);
        CheckpointStatsSnapshot snapshot = (CheckpointStatsSnapshot)Mockito.mock(CheckpointStatsSnapshot.class);
        Mockito.when((Object)snapshot.getHistory()).thenReturn((Object)history);
        AccessExecutionGraph graph = (AccessExecutionGraph)Mockito.mock(AccessExecutionGraph.class);
        Mockito.when((Object)graph.getCheckpointStatsSnapshot()).thenReturn((Object)snapshot);
        CheckpointStatsDetailsSubtasksHandler handler = new CheckpointStatsDetailsSubtasksHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor(), new CheckpointStatsCache(0));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("checkpointid", "123");
        params.put("vertexid", new JobVertexID().toString());
        String json = (String)handler.handleRequest(graph, params).get();
        Assert.assertEquals((Object)"{}", (Object)json);
        ((PendingCheckpointStats)Mockito.verify((Object)inProgress, (VerificationMode)Mockito.times((int)1))).getTaskStateStats((JobVertexID)Matchers.any(JobVertexID.class));
    }

    private static JsonNode triggerRequest(AbstractCheckpointStats checkpoint) throws Exception {
        CheckpointStatsHistory history = (CheckpointStatsHistory)Mockito.mock(CheckpointStatsHistory.class);
        Mockito.when((Object)history.getCheckpointById(Matchers.anyLong())).thenReturn((Object)checkpoint);
        CheckpointStatsSnapshot snapshot = (CheckpointStatsSnapshot)Mockito.mock(CheckpointStatsSnapshot.class);
        Mockito.when((Object)snapshot.getHistory()).thenReturn((Object)history);
        AccessExecutionGraph graph = (AccessExecutionGraph)Mockito.mock(AccessExecutionGraph.class);
        Mockito.when((Object)graph.getCheckpointStatsSnapshot()).thenReturn((Object)snapshot);
        CheckpointStatsDetailsSubtasksHandler handler = new CheckpointStatsDetailsSubtasksHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor(), new CheckpointStatsCache(0));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("checkpointid", "123");
        params.put("vertexid", new JobVertexID().toString());
        String json = (String)handler.handleRequest(graph, params).get();
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readTree(json);
    }

    private static TaskStateStats createTaskStateStats(int numAcknowledged) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        TaskStateStats task = (TaskStateStats)Mockito.mock(TaskStateStats.class);
        Mockito.when((Object)task.getJobVertexId()).thenReturn((Object)new JobVertexID());
        Mockito.when((Object)task.getLatestAckTimestamp()).thenReturn((Object)(rand.nextLong(1024L) + 1L));
        Mockito.when((Object)task.getStateSize()).thenReturn((Object)(rand.nextLong(1024L) + 1L));
        Mockito.when((Object)task.getEndToEndDuration(Matchers.anyLong())).thenReturn((Object)(rand.nextLong(1024L) + 1L));
        Mockito.when((Object)task.getAlignmentBuffered()).thenReturn((Object)(rand.nextLong(1024L) + 1L));
        Mockito.when((Object)task.getNumberOfSubtasks()).thenReturn((Object)(rand.nextInt(1024) + 1));
        Mockito.when((Object)task.getNumberOfAcknowledgedSubtasks()).thenReturn((Object)numAcknowledged);
        TaskStateStats.TaskStateStatsSummary summary = (TaskStateStats.TaskStateStatsSummary)Mockito.mock(TaskStateStats.TaskStateStatsSummary.class);
        ((TaskStateStats.TaskStateStatsSummary)Mockito.doReturn((Object)CheckpointStatsSubtaskDetailsHandlerTest.createMinMaxAvgStats(rand)).when((Object)summary)).getStateSizeStats();
        ((TaskStateStats.TaskStateStatsSummary)Mockito.doReturn((Object)CheckpointStatsSubtaskDetailsHandlerTest.createMinMaxAvgStats(rand)).when((Object)summary)).getAckTimestampStats();
        ((TaskStateStats.TaskStateStatsSummary)Mockito.doReturn((Object)CheckpointStatsSubtaskDetailsHandlerTest.createMinMaxAvgStats(rand)).when((Object)summary)).getAlignmentBufferedStats();
        ((TaskStateStats.TaskStateStatsSummary)Mockito.doReturn((Object)CheckpointStatsSubtaskDetailsHandlerTest.createMinMaxAvgStats(rand)).when((Object)summary)).getAlignmentDurationStats();
        ((TaskStateStats.TaskStateStatsSummary)Mockito.doReturn((Object)CheckpointStatsSubtaskDetailsHandlerTest.createMinMaxAvgStats(rand)).when((Object)summary)).getSyncCheckpointDurationStats();
        ((TaskStateStats.TaskStateStatsSummary)Mockito.doReturn((Object)CheckpointStatsSubtaskDetailsHandlerTest.createMinMaxAvgStats(rand)).when((Object)summary)).getAsyncCheckpointDurationStats();
        Mockito.when((Object)task.getSummaryStats()).thenReturn((Object)summary);
        SubtaskStateStats[] subtasks = new SubtaskStateStats[]{CheckpointStatsSubtaskDetailsHandlerTest.createSubtaskStats(0, rand), CheckpointStatsSubtaskDetailsHandlerTest.createSubtaskStats(1, rand), null};
        Mockito.when((Object)task.getSubtaskStats()).thenReturn((Object)subtasks);
        return task;
    }

    private static void verifyTaskNode(JsonNode taskNode, TaskStateStats task, long triggerTimestamp) {
        long duration = ThreadLocalRandom.current().nextInt(128);
        Assert.assertEquals((long)task.getLatestAckTimestamp(), (long)taskNode.get("latest_ack_timestamp").asLong());
        Assert.assertEquals((long)task.getStateSize(), (long)taskNode.get("state_size").asLong());
        Assert.assertEquals((long)task.getEndToEndDuration(task.getLatestAckTimestamp() - duration), (long)taskNode.get("end_to_end_duration").asLong());
        Assert.assertEquals((long)task.getAlignmentBuffered(), (long)taskNode.get("alignment_buffered").asLong());
        Assert.assertEquals((long)task.getNumberOfSubtasks(), (long)taskNode.get("num_subtasks").asInt());
        Assert.assertEquals((long)task.getNumberOfAcknowledgedSubtasks(), (long)taskNode.get("num_acknowledged_subtasks").asInt());
        TaskStateStats.TaskStateStatsSummary summary = task.getSummaryStats();
        CheckpointStatsSubtaskDetailsHandlerTest.verifyMinMaxAvgStats(summary.getStateSizeStats(), taskNode.get("summary").get("state_size"));
        CheckpointStatsSubtaskDetailsHandlerTest.verifyMinMaxAvgStats(summary.getSyncCheckpointDurationStats(), taskNode.get("summary").get("checkpoint_duration").get("sync"));
        CheckpointStatsSubtaskDetailsHandlerTest.verifyMinMaxAvgStats(summary.getAsyncCheckpointDurationStats(), taskNode.get("summary").get("checkpoint_duration").get("async"));
        CheckpointStatsSubtaskDetailsHandlerTest.verifyMinMaxAvgStats(summary.getAlignmentBufferedStats(), taskNode.get("summary").get("alignment").get("buffered"));
        CheckpointStatsSubtaskDetailsHandlerTest.verifyMinMaxAvgStats(summary.getAlignmentDurationStats(), taskNode.get("summary").get("alignment").get("duration"));
        JsonNode endToEndDurationNode = taskNode.get("summary").get("end_to_end_duration");
        Assert.assertEquals((long)(summary.getAckTimestampStats().getMinimum() - triggerTimestamp), (long)endToEndDurationNode.get("min").asLong());
        Assert.assertEquals((long)(summary.getAckTimestampStats().getMaximum() - triggerTimestamp), (long)endToEndDurationNode.get("max").asLong());
        Assert.assertEquals((long)(summary.getAckTimestampStats().getAverage() - triggerTimestamp), (long)endToEndDurationNode.get("avg").asLong());
        SubtaskStateStats[] subtasks = task.getSubtaskStats();
        Iterator it = taskNode.get("subtasks").iterator();
        Assert.assertTrue((boolean)it.hasNext());
        CheckpointStatsSubtaskDetailsHandlerTest.verifySubtaskStats((JsonNode)it.next(), 0, subtasks[0]);
        Assert.assertTrue((boolean)it.hasNext());
        CheckpointStatsSubtaskDetailsHandlerTest.verifySubtaskStats((JsonNode)it.next(), 1, subtasks[1]);
        Assert.assertTrue((boolean)it.hasNext());
        CheckpointStatsSubtaskDetailsHandlerTest.verifySubtaskStats((JsonNode)it.next(), 2, subtasks[2]);
        Assert.assertFalse((boolean)it.hasNext());
    }

    private static SubtaskStateStats createSubtaskStats(int index, ThreadLocalRandom rand) {
        SubtaskStateStats subtask = (SubtaskStateStats)Mockito.mock(SubtaskStateStats.class);
        Mockito.when((Object)subtask.getSubtaskIndex()).thenReturn((Object)index);
        Mockito.when((Object)subtask.getAckTimestamp()).thenReturn((Object)rand.nextLong(1024L));
        Mockito.when((Object)subtask.getAlignmentBuffered()).thenReturn((Object)rand.nextLong(1024L));
        Mockito.when((Object)subtask.getAlignmentDuration()).thenReturn((Object)rand.nextLong(1024L));
        Mockito.when((Object)subtask.getSyncCheckpointDuration()).thenReturn((Object)rand.nextLong(1024L));
        Mockito.when((Object)subtask.getAsyncCheckpointDuration()).thenReturn((Object)rand.nextLong(1024L));
        Mockito.when((Object)subtask.getAckTimestamp()).thenReturn((Object)rand.nextLong(1024L));
        Mockito.when((Object)subtask.getStateSize()).thenReturn((Object)rand.nextLong(1024L));
        Mockito.when((Object)subtask.getEndToEndDuration(Matchers.anyLong())).thenReturn((Object)rand.nextLong(1024L));
        return subtask;
    }

    private static void verifySubtaskStats(JsonNode subtaskNode, int index, SubtaskStateStats subtask) {
        if (subtask == null) {
            Assert.assertEquals((long)index, (long)subtaskNode.get("index").asInt());
            Assert.assertEquals((Object)"pending_or_failed", (Object)subtaskNode.get("status").asText());
        } else {
            Assert.assertEquals((long)subtask.getSubtaskIndex(), (long)subtaskNode.get("index").asInt());
            Assert.assertEquals((Object)"completed", (Object)subtaskNode.get("status").asText());
            Assert.assertEquals((long)subtask.getAckTimestamp(), (long)subtaskNode.get("ack_timestamp").asLong());
            Assert.assertEquals((long)subtask.getEndToEndDuration(0L), (long)subtaskNode.get("end_to_end_duration").asLong());
            Assert.assertEquals((long)subtask.getStateSize(), (long)subtaskNode.get("state_size").asLong());
            Assert.assertEquals((long)subtask.getSyncCheckpointDuration(), (long)subtaskNode.get("checkpoint").get("sync").asLong());
            Assert.assertEquals((long)subtask.getAsyncCheckpointDuration(), (long)subtaskNode.get("checkpoint").get("async").asLong());
            Assert.assertEquals((long)subtask.getAlignmentBuffered(), (long)subtaskNode.get("alignment").get("buffered").asLong());
            Assert.assertEquals((long)subtask.getAlignmentDuration(), (long)subtaskNode.get("alignment").get("duration").asLong());
        }
    }

    private static MinMaxAvgStats createMinMaxAvgStats(ThreadLocalRandom rand) {
        MinMaxAvgStats mma = (MinMaxAvgStats)Mockito.mock(MinMaxAvgStats.class);
        Mockito.when((Object)mma.getMinimum()).thenReturn((Object)rand.nextLong(1024L));
        Mockito.when((Object)mma.getMaximum()).thenReturn((Object)rand.nextLong(1024L));
        Mockito.when((Object)mma.getAverage()).thenReturn((Object)rand.nextLong(1024L));
        return mma;
    }

    private static void verifyMinMaxAvgStats(MinMaxAvgStats expected, JsonNode node) {
        Assert.assertEquals((long)expected.getMinimum(), (long)node.get("min").asLong());
        Assert.assertEquals((long)expected.getMaximum(), (long)node.get("max").asLong());
        Assert.assertEquals((long)expected.getAverage(), (long)node.get("avg").asLong());
    }
}

