/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.metrics;

import java.util.Collections;
import java.util.HashMap;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.rest.handler.legacy.metrics.AggregatingTaskManagersMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStoreTest;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceRetriever;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.powermock.api.mockito.PowerMockito;

public class AbstractAggregatingMetricsHandlerTest {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static AggregatingTaskManagersMetricsHandler handler;

    @BeforeClass
    public static void setupHandler() {
        MetricFetcher fetcher = new MetricFetcher((GatewayRetriever)PowerMockito.mock(GatewayRetriever.class), (MetricQueryServiceRetriever)PowerMockito.mock(MetricQueryServiceRetriever.class), Executors.directExecutor(), TestingUtils.TIMEOUT());
        MetricStoreTest.setupStore(fetcher.getMetricStore());
        handler = new AggregatingTaskManagersMetricsHandler(Executors.directExecutor(), fetcher);
    }

    @Test
    public void testListMetrics() throws Exception {
        String response = (String)handler.handleJsonRequest(Collections.emptyMap(), Collections.emptyMap(), null).get();
        Assert.assertEquals((Object)"[{\"id\":\"abc.metric22\"},{\"id\":\"abc.metric2b\"},{\"id\":\"abc.metric2\"}]", (Object)response);
    }

    @Test
    public void testMinAggregation() throws Exception {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("get", "abc.metric2");
        queryParams.put("agg", "min");
        String response = (String)handler.handleJsonRequest(Collections.emptyMap(), queryParams, null).get();
        JsonNode responseObject = mapper.readTree(response);
        Assert.assertEquals((long)1L, (long)responseObject.size());
        JsonNode metricInfo = responseObject.get(0);
        Assert.assertEquals((Object)"abc.metric2", (Object)metricInfo.get("id").asText());
        Assert.assertEquals((double)1.0, (double)metricInfo.get("min").asDouble(), (double)0.01);
    }

    @Test
    public void testMaxAggregation() throws Exception {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("get", "abc.metric2");
        queryParams.put("agg", "max");
        String response = (String)handler.handleJsonRequest(Collections.emptyMap(), queryParams, null).get();
        JsonNode responseObject = mapper.readTree(response);
        Assert.assertEquals((long)1L, (long)responseObject.size());
        JsonNode metricInfo = responseObject.get(0);
        Assert.assertEquals((Object)"abc.metric2", (Object)metricInfo.get("id").asText());
        Assert.assertEquals((double)10.0, (double)metricInfo.get("max").asDouble(), (double)0.01);
    }

    @Test
    public void testAvgAggregation() throws Exception {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("get", "abc.metric2");
        queryParams.put("agg", "avg");
        String response = (String)handler.handleJsonRequest(Collections.emptyMap(), queryParams, null).get();
        JsonNode responseObject = mapper.readTree(response);
        Assert.assertEquals((long)1L, (long)responseObject.size());
        JsonNode metricInfo = responseObject.get(0);
        Assert.assertEquals((Object)"abc.metric2", (Object)metricInfo.get("id").asText());
        Assert.assertEquals((double)5.5, (double)metricInfo.get("avg").asDouble(), (double)0.01);
    }

    @Test
    public void testSumAggregation() throws Exception {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("get", "abc.metric2");
        queryParams.put("agg", "sum");
        String response = (String)handler.handleJsonRequest(Collections.emptyMap(), queryParams, null).get();
        JsonNode responseObject = mapper.readTree(response);
        Assert.assertEquals((long)1L, (long)responseObject.size());
        JsonNode metricInfo = responseObject.get(0);
        Assert.assertEquals((Object)"abc.metric2", (Object)metricInfo.get("id").asText());
        Assert.assertEquals((double)11.0, (double)metricInfo.get("sum").asDouble(), (double)0.01);
    }

    @Test
    public void testMultipleAggregations() throws Exception {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("get", "abc.metric2");
        queryParams.put("agg", "sum,max,min,avg");
        String response = (String)handler.handleJsonRequest(Collections.emptyMap(), queryParams, null).get();
        JsonNode array = mapper.readTree(response);
        Assert.assertEquals((long)1L, (long)array.size());
        FullMetricInfo mappedResponse = (FullMetricInfo)mapper.treeToValue((TreeNode)array.get(0), FullMetricInfo.class);
        Assert.assertEquals((Object)"abc.metric2", (Object)mappedResponse.id);
        Assert.assertEquals((double)11.0, (double)mappedResponse.sum, (double)0.01);
        Assert.assertEquals((double)1.0, (double)mappedResponse.min, (double)0.01);
        Assert.assertEquals((double)10.0, (double)mappedResponse.max, (double)0.01);
        Assert.assertEquals((double)5.5, (double)mappedResponse.avg, (double)0.01);
    }

    @Test
    public void testDefaultAggregations() throws Exception {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("get", "abc.metric2");
        String response = (String)handler.handleJsonRequest(Collections.emptyMap(), queryParams, null).get();
        JsonNode array = mapper.readTree(response);
        Assert.assertEquals((long)1L, (long)array.size());
        FullMetricInfo mappedResponse = (FullMetricInfo)mapper.treeToValue((TreeNode)array.get(0), FullMetricInfo.class);
        Assert.assertEquals((Object)"abc.metric2", (Object)mappedResponse.id);
        Assert.assertEquals((double)11.0, (double)mappedResponse.sum, (double)0.01);
        Assert.assertEquals((double)1.0, (double)mappedResponse.min, (double)0.01);
        Assert.assertEquals((double)10.0, (double)mappedResponse.max, (double)0.01);
        Assert.assertEquals((double)5.5, (double)mappedResponse.avg, (double)0.01);
    }

    private static class FullMetricInfo {
        private final String id;
        private final double min;
        private final double max;
        private final double avg;
        private final double sum;

        @JsonCreator
        private FullMetricInfo(@JsonProperty(value="id") String id, @JsonProperty(value="min") double min, @JsonProperty(value="max") double max, @JsonProperty(value="avg") double avg, @JsonProperty(value="sum") double sum) {
            this.id = id;
            this.min = min;
            this.max = max;
            this.avg = avg;
            this.sum = sum;
        }
    }
}

