/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.metrics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.jobmaster.JobManagerGateway;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.messages.webmonitor.MultipleJobsDetails;
import org.apache.flink.runtime.metrics.dump.MetricDumpSerialization;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.util.TestingHistogram;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceGateway;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceRetriever;
import org.apache.flink.runtime.webmonitor.retriever.impl.AkkaJobManagerRetriever;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={MetricFetcher.class})
public class MetricFetcherTest
extends TestLogger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdate() throws Exception {
        MetricStore store;
        Time timeout = Time.seconds((long)10L);
        JobID jobID = new JobID();
        ResourceID tmRID = ResourceID.generate();
        JobDetails details = (JobDetails)PowerMockito.mock(JobDetails.class);
        PowerMockito.when((Object)details.getJobId()).thenReturn((Object)jobID);
        String jmMetricQueryServicePath = "/jm/MetricQueryService";
        String tmMetricQueryServicePath = "/tm/MetricQueryService_" + tmRID.getResourceIdString();
        JobManagerGateway jobManagerGateway = (JobManagerGateway)PowerMockito.mock(JobManagerGateway.class);
        PowerMockito.when((Object)jobManagerGateway.requestJobDetails(Matchers.anyBoolean(), Matchers.anyBoolean(), (Time)Matchers.any(Time.class))).thenReturn(CompletableFuture.completedFuture(new MultipleJobsDetails(Collections.emptyList(), Collections.emptyList())));
        PowerMockito.when((Object)jobManagerGateway.requestMetricQueryServicePaths((Time)Matchers.any(Time.class))).thenReturn(CompletableFuture.completedFuture(Collections.singleton("/jm/MetricQueryService")));
        PowerMockito.when((Object)jobManagerGateway.requestTaskManagerMetricQueryServicePaths((Time)Matchers.any(Time.class))).thenReturn(CompletableFuture.completedFuture(Collections.singleton(Tuple2.of((Object)tmRID, (Object)tmMetricQueryServicePath))));
        GatewayRetriever retriever = (GatewayRetriever)PowerMockito.mock(AkkaJobManagerRetriever.class);
        PowerMockito.when((Object)retriever.getNow()).thenReturn(Optional.of(jobManagerGateway));
        MetricQueryServiceGateway jmQueryService = (MetricQueryServiceGateway)PowerMockito.mock(MetricQueryServiceGateway.class);
        MetricQueryServiceGateway tmQueryService = (MetricQueryServiceGateway)PowerMockito.mock(MetricQueryServiceGateway.class);
        MetricDumpSerialization.MetricSerializationResult requestMetricsAnswer = MetricFetcherTest.createRequestDumpAnswer(tmRID, jobID);
        PowerMockito.when((Object)jmQueryService.queryMetrics((Time)Matchers.any(Time.class))).thenReturn(CompletableFuture.completedFuture(new MetricDumpSerialization.MetricSerializationResult(new byte[0], 0, 0, 0, 0)));
        PowerMockito.when((Object)tmQueryService.queryMetrics((Time)Matchers.any(Time.class))).thenReturn(CompletableFuture.completedFuture(requestMetricsAnswer));
        MetricQueryServiceRetriever queryServiceRetriever = (MetricQueryServiceRetriever)PowerMockito.mock(MetricQueryServiceRetriever.class);
        PowerMockito.when((Object)queryServiceRetriever.retrieveService((String)Matchers.eq((Object)"/jm/MetricQueryService"))).thenReturn(CompletableFuture.completedFuture(jmQueryService));
        PowerMockito.when((Object)queryServiceRetriever.retrieveService((String)Matchers.eq((Object)tmMetricQueryServicePath))).thenReturn(CompletableFuture.completedFuture(tmQueryService));
        MetricFetcher fetcher = new MetricFetcher(retriever, queryServiceRetriever, Executors.directExecutor(), timeout);
        fetcher.update();
        MetricStore metricStore = store = fetcher.getMetricStore();
        synchronized (metricStore) {
            Assert.assertEquals((Object)"7", (Object)store.getJobManagerMetricStore().getMetric("abc.hist_min"));
            Assert.assertEquals((Object)"6", (Object)store.getJobManagerMetricStore().getMetric("abc.hist_max"));
            Assert.assertEquals((Object)"4.0", (Object)store.getJobManagerMetricStore().getMetric("abc.hist_mean"));
            Assert.assertEquals((Object)"0.5", (Object)store.getJobManagerMetricStore().getMetric("abc.hist_median"));
            Assert.assertEquals((Object)"5.0", (Object)store.getJobManagerMetricStore().getMetric("abc.hist_stddev"));
            Assert.assertEquals((Object)"0.75", (Object)store.getJobManagerMetricStore().getMetric("abc.hist_p75"));
            Assert.assertEquals((Object)"0.9", (Object)store.getJobManagerMetricStore().getMetric("abc.hist_p90"));
            Assert.assertEquals((Object)"0.95", (Object)store.getJobManagerMetricStore().getMetric("abc.hist_p95"));
            Assert.assertEquals((Object)"0.98", (Object)store.getJobManagerMetricStore().getMetric("abc.hist_p98"));
            Assert.assertEquals((Object)"0.99", (Object)store.getJobManagerMetricStore().getMetric("abc.hist_p99"));
            Assert.assertEquals((Object)"0.999", (Object)store.getJobManagerMetricStore().getMetric("abc.hist_p999"));
            Assert.assertEquals((Object)"x", store.getTaskManagerMetricStore((String)tmRID.toString()).metrics.get("abc.gauge"));
            Assert.assertEquals((Object)"5.0", store.getJobMetricStore((String)jobID.toString()).metrics.get("abc.jc"));
            Assert.assertEquals((Object)"2", store.getTaskMetricStore((String)jobID.toString(), (String)"taskid").metrics.get("2.abc.tc"));
            Assert.assertEquals((Object)"1", store.getTaskMetricStore((String)jobID.toString(), (String)"taskid").metrics.get("2.opname.abc.oc"));
        }
    }

    private static MetricDumpSerialization.MetricSerializationResult createRequestDumpAnswer(ResourceID tmRID, JobID jobID) {
        HashMap<SimpleCounter, Tuple2> counters = new HashMap<SimpleCounter, Tuple2>();
        HashMap<2, Tuple2> gauges = new HashMap<2, Tuple2>();
        HashMap<TestingHistogram, Tuple2> histograms = new HashMap<TestingHistogram, Tuple2>();
        HashMap<1, Tuple2> meters = new HashMap<1, Tuple2>();
        SimpleCounter c1 = new SimpleCounter();
        SimpleCounter c2 = new SimpleCounter();
        c1.inc(1L);
        c2.inc(2L);
        counters.put(c1, new Tuple2((Object)new QueryScopeInfo.OperatorQueryScopeInfo(jobID.toString(), "taskid", 2, "opname", "abc"), (Object)"oc"));
        counters.put(c2, new Tuple2((Object)new QueryScopeInfo.TaskQueryScopeInfo(jobID.toString(), "taskid", 2, "abc"), (Object)"tc"));
        meters.put(new Meter(){

            public void markEvent() {
            }

            public void markEvent(long n) {
            }

            public double getRate() {
                return 5.0;
            }

            public long getCount() {
                return 10L;
            }
        }, new Tuple2((Object)new QueryScopeInfo.JobQueryScopeInfo(jobID.toString(), "abc"), (Object)"jc"));
        gauges.put(new Gauge<String>(){

            public String getValue() {
                return "x";
            }
        }, new Tuple2((Object)new QueryScopeInfo.TaskManagerQueryScopeInfo(tmRID.toString(), "abc"), (Object)"gauge"));
        histograms.put(new TestingHistogram(), new Tuple2((Object)new QueryScopeInfo.JobManagerQueryScopeInfo("abc"), (Object)"hist"));
        MetricDumpSerialization.MetricDumpSerializer serializer = new MetricDumpSerialization.MetricDumpSerializer();
        MetricDumpSerialization.MetricSerializationResult dump = serializer.serialize(counters, gauges, histograms, meters);
        serializer.close();
        return dump;
    }
}

