/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.utils;

import java.util.List;
import java.util.Random;
import org.apache.flink.runtime.executiongraph.ArchivedExecution;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionVertex;
import org.apache.flink.runtime.util.EvictingBoundedList;
import org.apache.flink.util.Preconditions;

public class ArchivedExecutionVertexBuilder {
    private static final Random RANDOM = new Random();
    private int subtaskIndex;
    private EvictingBoundedList<ArchivedExecution> priorExecutions;
    private String taskNameWithSubtask;
    private ArchivedExecution currentExecution;

    public ArchivedExecutionVertexBuilder setSubtaskIndex(int subtaskIndex) {
        this.subtaskIndex = subtaskIndex;
        return this;
    }

    public ArchivedExecutionVertexBuilder setPriorExecutions(List<ArchivedExecution> priorExecutions) {
        this.priorExecutions = new EvictingBoundedList(priorExecutions.size());
        for (ArchivedExecution execution : priorExecutions) {
            this.priorExecutions.add((Object)execution);
        }
        return this;
    }

    public ArchivedExecutionVertexBuilder setTaskNameWithSubtask(String taskNameWithSubtask) {
        this.taskNameWithSubtask = taskNameWithSubtask;
        return this;
    }

    public ArchivedExecutionVertexBuilder setCurrentExecution(ArchivedExecution currentExecution) {
        this.currentExecution = currentExecution;
        return this;
    }

    public ArchivedExecutionVertex build() {
        Preconditions.checkNotNull((Object)this.currentExecution);
        return new ArchivedExecutionVertex(this.subtaskIndex, this.taskNameWithSubtask != null ? this.taskNameWithSubtask : "task_" + RANDOM.nextInt() + "_" + this.subtaskIndex, this.currentExecution, this.priorExecutions != null ? this.priorExecutions : new EvictingBoundedList(0));
    }
}

