/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.File;
import java.io.IOException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.operators.testutils.DummyEnvironment;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.filesystem.FsStateBackend;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.util.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class HeapKeyedStateBackendAsyncByDefaultTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFsStateBackendDefaultsToAsync() throws Exception {
        TemporaryFolder temporaryFolder = new TemporaryFolder();
        temporaryFolder.create();
        File folder = temporaryFolder.newFolder();
        try {
            FsStateBackend fsStateBackend = new FsStateBackend(folder.toURI());
            this.validateSupportForAsyncSnapshots((AbstractStateBackend)fsStateBackend);
            fsStateBackend = new FsStateBackend(folder.toURI(), 1024);
            this.validateSupportForAsyncSnapshots((AbstractStateBackend)fsStateBackend);
        }
        finally {
            folder.delete();
            temporaryFolder.delete();
        }
    }

    @Test
    public void testMemoryStateBackendDefaultsToAsync() throws Exception {
        MemoryStateBackend memoryStateBackend = new MemoryStateBackend();
        this.validateSupportForAsyncSnapshots((AbstractStateBackend)memoryStateBackend);
    }

    private void validateSupportForAsyncSnapshots(AbstractStateBackend backend) throws IOException {
        AbstractKeyedStateBackend keyedStateBackend = backend.createKeyedStateBackend((Environment)new DummyEnvironment("Test", 1, 0), new JobID(), "testOperator", (TypeSerializer)IntSerializer.INSTANCE, 1, new KeyGroupRange(0, 0), null);
        try {
            Assert.assertTrue((boolean)keyedStateBackend.supportsAsynchronousSnapshots());
        }
        finally {
            IOUtils.closeQuietly((AutoCloseable)keyedStateBackend);
            keyedStateBackend.dispose();
        }
    }
}

