/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSerializationUtil;
import org.apache.flink.api.common.typeutils.base.DoubleSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.core.memory.ByteArrayInputStreamWithPos;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.KeyedBackendSerializationProxy;
import org.apache.flink.runtime.state.KeyedBackendStateMetaInfoSnapshotReaderWriters;
import org.apache.flink.runtime.state.OperatorBackendSerializationProxy;
import org.apache.flink.runtime.state.OperatorBackendStateMetaInfoSnapshotReaderWriters;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.RegisteredKeyedBackendStateMetaInfo;
import org.apache.flink.runtime.state.RegisteredOperatorBackendStateMetaInfo;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={TypeSerializerSerializationUtil.class})
public class SerializationProxiesTest {
    @Test
    public void testKeyedBackendSerializationProxyRoundtrip() throws Exception {
        byte[] serialized;
        IntSerializer keySerializer = IntSerializer.INSTANCE;
        LongSerializer namespaceSerializer = LongSerializer.INSTANCE;
        DoubleSerializer stateSerializer = DoubleSerializer.INSTANCE;
        ArrayList<RegisteredKeyedBackendStateMetaInfo.Snapshot> stateMetaInfoList = new ArrayList<RegisteredKeyedBackendStateMetaInfo.Snapshot>();
        stateMetaInfoList.add(new RegisteredKeyedBackendStateMetaInfo(StateDescriptor.Type.VALUE, "a", (TypeSerializer)namespaceSerializer, (TypeSerializer)stateSerializer).snapshot());
        stateMetaInfoList.add(new RegisteredKeyedBackendStateMetaInfo(StateDescriptor.Type.VALUE, "b", (TypeSerializer)namespaceSerializer, (TypeSerializer)stateSerializer).snapshot());
        stateMetaInfoList.add(new RegisteredKeyedBackendStateMetaInfo(StateDescriptor.Type.VALUE, "c", (TypeSerializer)namespaceSerializer, (TypeSerializer)stateSerializer).snapshot());
        KeyedBackendSerializationProxy serializationProxy = new KeyedBackendSerializationProxy((TypeSerializer)keySerializer, stateMetaInfoList, true);
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            serializationProxy.write((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        serializationProxy = new KeyedBackendSerializationProxy(Thread.currentThread().getContextClassLoader());
        var7_7 = null;
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            serializationProxy.read((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        Assert.assertEquals((Object)true, (Object)serializationProxy.isUsingKeyGroupCompression());
        Assert.assertEquals((Object)keySerializer, (Object)serializationProxy.getKeySerializer());
        Assert.assertEquals((Object)keySerializer.snapshotConfiguration(), (Object)serializationProxy.getKeySerializerConfigSnapshot());
        Assert.assertEquals(stateMetaInfoList, (Object)serializationProxy.getStateMetaInfoSnapshots());
    }

    @Test
    public void testKeyedBackendSerializationProxyRoundtripWithSerializerSerializationFailures() throws Exception {
        byte[] serialized;
        IntSerializer keySerializer = IntSerializer.INSTANCE;
        LongSerializer namespaceSerializer = LongSerializer.INSTANCE;
        DoubleSerializer stateSerializer = DoubleSerializer.INSTANCE;
        ArrayList<RegisteredKeyedBackendStateMetaInfo.Snapshot> stateMetaInfoList = new ArrayList<RegisteredKeyedBackendStateMetaInfo.Snapshot>();
        stateMetaInfoList.add(new RegisteredKeyedBackendStateMetaInfo(StateDescriptor.Type.VALUE, "a", (TypeSerializer)namespaceSerializer, (TypeSerializer)stateSerializer).snapshot());
        stateMetaInfoList.add(new RegisteredKeyedBackendStateMetaInfo(StateDescriptor.Type.VALUE, "b", (TypeSerializer)namespaceSerializer, (TypeSerializer)stateSerializer).snapshot());
        stateMetaInfoList.add(new RegisteredKeyedBackendStateMetaInfo(StateDescriptor.Type.VALUE, "c", (TypeSerializer)namespaceSerializer, (TypeSerializer)stateSerializer).snapshot());
        KeyedBackendSerializationProxy serializationProxy = new KeyedBackendSerializationProxy((TypeSerializer)keySerializer, stateMetaInfoList, true);
        ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();
        Object object = null;
        try {
            serializationProxy.write((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (out != null) {
                if (object != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    out.close();
                }
            }
        }
        serializationProxy = new KeyedBackendSerializationProxy(Thread.currentThread().getContextClassLoader());
        TypeSerializerSerializationUtil.TypeSerializerSerializationProxy mockProxy = (TypeSerializerSerializationUtil.TypeSerializerSerializationProxy)Mockito.mock(TypeSerializerSerializationUtil.TypeSerializerSerializationProxy.class);
        ((TypeSerializerSerializationUtil.TypeSerializerSerializationProxy)Mockito.doThrow((Throwable)new IOException()).when((Object)mockProxy)).read((DataInputView)Matchers.any(DataInputViewStreamWrapper.class));
        PowerMockito.whenNew(TypeSerializerSerializationUtil.TypeSerializerSerializationProxy.class).withAnyArguments().thenReturn((Object)mockProxy);
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            serializationProxy.read((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
        }
        Assert.assertEquals((Object)true, (Object)serializationProxy.isUsingKeyGroupCompression());
        Assert.assertEquals(null, (Object)serializationProxy.getKeySerializer());
        Assert.assertEquals((Object)keySerializer.snapshotConfiguration(), (Object)serializationProxy.getKeySerializerConfigSnapshot());
        for (RegisteredKeyedBackendStateMetaInfo.Snapshot meta : serializationProxy.getStateMetaInfoSnapshots()) {
            Assert.assertEquals(null, (Object)meta.getNamespaceSerializer());
            Assert.assertEquals(null, (Object)meta.getStateSerializer());
            Assert.assertEquals((Object)namespaceSerializer.snapshotConfiguration(), (Object)meta.getNamespaceSerializerConfigSnapshot());
            Assert.assertEquals((Object)stateSerializer.snapshotConfiguration(), (Object)meta.getStateSerializerConfigSnapshot());
        }
    }

    @Test
    public void testKeyedStateMetaInfoSerialization() throws Exception {
        byte[] serialized;
        String name = "test";
        LongSerializer namespaceSerializer = LongSerializer.INSTANCE;
        DoubleSerializer stateSerializer = DoubleSerializer.INSTANCE;
        RegisteredKeyedBackendStateMetaInfo.Snapshot metaInfo = new RegisteredKeyedBackendStateMetaInfo(StateDescriptor.Type.VALUE, name, (TypeSerializer)namespaceSerializer, (TypeSerializer)stateSerializer).snapshot();
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            KeyedBackendStateMetaInfoSnapshotReaderWriters.getWriterForVersion((int)4, (RegisteredKeyedBackendStateMetaInfo.Snapshot)metaInfo).writeStateMetaInfo((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        var6_6 = null;
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            metaInfo = KeyedBackendStateMetaInfoSnapshotReaderWriters.getReaderForVersion((int)4, (ClassLoader)Thread.currentThread().getContextClassLoader()).readStateMetaInfo((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        Assert.assertEquals((Object)name, (Object)metaInfo.getName());
    }

    @Test
    public void testKeyedStateMetaInfoReadSerializerFailureResilience() throws Exception {
        byte[] serialized;
        String name = "test";
        LongSerializer namespaceSerializer = LongSerializer.INSTANCE;
        DoubleSerializer stateSerializer = DoubleSerializer.INSTANCE;
        RegisteredKeyedBackendStateMetaInfo.Snapshot metaInfo = new RegisteredKeyedBackendStateMetaInfo(StateDescriptor.Type.VALUE, name, (TypeSerializer)namespaceSerializer, (TypeSerializer)stateSerializer).snapshot();
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            KeyedBackendStateMetaInfoSnapshotReaderWriters.getWriterForVersion((int)4, (RegisteredKeyedBackendStateMetaInfo.Snapshot)metaInfo).writeStateMetaInfo((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        TypeSerializerSerializationUtil.TypeSerializerSerializationProxy mockProxy = (TypeSerializerSerializationUtil.TypeSerializerSerializationProxy)Mockito.mock(TypeSerializerSerializationUtil.TypeSerializerSerializationProxy.class);
        ((TypeSerializerSerializationUtil.TypeSerializerSerializationProxy)Mockito.doThrow((Throwable)new IOException()).when((Object)mockProxy)).read((DataInputView)Matchers.any(DataInputViewStreamWrapper.class));
        PowerMockito.whenNew(TypeSerializerSerializationUtil.TypeSerializerSerializationProxy.class).withAnyArguments().thenReturn((Object)mockProxy);
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            metaInfo = KeyedBackendStateMetaInfoSnapshotReaderWriters.getReaderForVersion((int)4, (ClassLoader)Thread.currentThread().getContextClassLoader()).readStateMetaInfo((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
        }
        Assert.assertEquals((Object)name, (Object)metaInfo.getName());
        Assert.assertEquals(null, (Object)metaInfo.getNamespaceSerializer());
        Assert.assertEquals(null, (Object)metaInfo.getStateSerializer());
        Assert.assertEquals((Object)namespaceSerializer.snapshotConfiguration(), (Object)metaInfo.getNamespaceSerializerConfigSnapshot());
        Assert.assertEquals((Object)stateSerializer.snapshotConfiguration(), (Object)metaInfo.getStateSerializerConfigSnapshot());
    }

    @Test
    public void testOperatorBackendSerializationProxyRoundtrip() throws Exception {
        byte[] serialized;
        DoubleSerializer stateSerializer = DoubleSerializer.INSTANCE;
        ArrayList<RegisteredOperatorBackendStateMetaInfo.Snapshot> stateMetaInfoSnapshots = new ArrayList<RegisteredOperatorBackendStateMetaInfo.Snapshot>();
        stateMetaInfoSnapshots.add(new RegisteredOperatorBackendStateMetaInfo("a", (TypeSerializer)stateSerializer, OperatorStateHandle.Mode.SPLIT_DISTRIBUTE).snapshot());
        stateMetaInfoSnapshots.add(new RegisteredOperatorBackendStateMetaInfo("b", (TypeSerializer)stateSerializer, OperatorStateHandle.Mode.SPLIT_DISTRIBUTE).snapshot());
        stateMetaInfoSnapshots.add(new RegisteredOperatorBackendStateMetaInfo("c", (TypeSerializer)stateSerializer, OperatorStateHandle.Mode.BROADCAST).snapshot());
        OperatorBackendSerializationProxy serializationProxy = new OperatorBackendSerializationProxy(stateMetaInfoSnapshots);
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            serializationProxy.write((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        serializationProxy = new OperatorBackendSerializationProxy(Thread.currentThread().getContextClassLoader());
        var5_5 = null;
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            serializationProxy.read((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        Assert.assertEquals(stateMetaInfoSnapshots, (Object)serializationProxy.getStateMetaInfoSnapshots());
    }

    @Test
    public void testOperatorStateMetaInfoSerialization() throws Exception {
        byte[] serialized;
        String name = "test";
        DoubleSerializer stateSerializer = DoubleSerializer.INSTANCE;
        RegisteredOperatorBackendStateMetaInfo.Snapshot metaInfo = new RegisteredOperatorBackendStateMetaInfo(name, (TypeSerializer)stateSerializer, OperatorStateHandle.Mode.BROADCAST).snapshot();
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            OperatorBackendStateMetaInfoSnapshotReaderWriters.getWriterForVersion((int)2, (RegisteredOperatorBackendStateMetaInfo.Snapshot)metaInfo).writeStateMetaInfo((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        var5_5 = null;
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            metaInfo = OperatorBackendStateMetaInfoSnapshotReaderWriters.getReaderForVersion((int)2, (ClassLoader)Thread.currentThread().getContextClassLoader()).readStateMetaInfo((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        Assert.assertEquals((Object)name, (Object)metaInfo.getName());
    }

    @Test
    public void testOperatorStateMetaInfoReadSerializerFailureResilience() throws Exception {
        byte[] serialized;
        String name = "test";
        DoubleSerializer stateSerializer = DoubleSerializer.INSTANCE;
        RegisteredOperatorBackendStateMetaInfo.Snapshot metaInfo = new RegisteredOperatorBackendStateMetaInfo(name, (TypeSerializer)stateSerializer, OperatorStateHandle.Mode.BROADCAST).snapshot();
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            OperatorBackendStateMetaInfoSnapshotReaderWriters.getWriterForVersion((int)2, (RegisteredOperatorBackendStateMetaInfo.Snapshot)metaInfo).writeStateMetaInfo((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        TypeSerializerSerializationUtil.TypeSerializerSerializationProxy mockProxy = (TypeSerializerSerializationUtil.TypeSerializerSerializationProxy)Mockito.mock(TypeSerializerSerializationUtil.TypeSerializerSerializationProxy.class);
        ((TypeSerializerSerializationUtil.TypeSerializerSerializationProxy)Mockito.doThrow((Throwable)new IOException()).when((Object)mockProxy)).read((DataInputView)Matchers.any(DataInputViewStreamWrapper.class));
        PowerMockito.whenNew(TypeSerializerSerializationUtil.TypeSerializerSerializationProxy.class).withAnyArguments().thenReturn((Object)mockProxy);
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            metaInfo = OperatorBackendStateMetaInfoSnapshotReaderWriters.getReaderForVersion((int)2, (ClassLoader)Thread.currentThread().getContextClassLoader()).readStateMetaInfo((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
        }
        Assert.assertEquals((Object)name, (Object)metaInfo.getName());
        Assert.assertEquals(null, (Object)metaInfo.getPartitionStateSerializer());
        Assert.assertEquals((Object)stateSerializer.snapshotConfiguration(), (Object)metaInfo.getPartitionStateSerializerConfigSnapshot());
    }

    @Test
    public void testFixTypeOrder() {
        Assert.assertEquals((long)7L, (long)StateDescriptor.Type.values().length);
        Assert.assertEquals((long)0L, (long)StateDescriptor.Type.UNKNOWN.ordinal());
        Assert.assertEquals((long)1L, (long)StateDescriptor.Type.VALUE.ordinal());
        Assert.assertEquals((long)2L, (long)StateDescriptor.Type.LIST.ordinal());
        Assert.assertEquals((long)3L, (long)StateDescriptor.Type.REDUCING.ordinal());
        Assert.assertEquals((long)4L, (long)StateDescriptor.Type.FOLDING.ordinal());
        Assert.assertEquals((long)5L, (long)StateDescriptor.Type.AGGREGATING.ordinal());
        Assert.assertEquals((long)6L, (long)StateDescriptor.Type.MAP.ordinal());
    }
}

