/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.UUID;
import org.apache.flink.util.FileUtils;

public class CommonTestUtils {
    public static void sleepUninterruptibly(long msecs) {
        long remaining;
        long now = System.currentTimeMillis();
        long sleepUntil = now + msecs;
        while ((remaining = sleepUntil - now) > 0L) {
            try {
                Thread.sleep(remaining);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            now = System.currentTimeMillis();
        }
    }

    public static String getCurrentClasspath() {
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        return bean.getClassPath();
    }

    public static File createTemporaryLog4JProperties() throws IOException {
        File log4jProps = File.createTempFile(FileUtils.getRandomFilename((String)""), "-log4j.properties");
        log4jProps.deleteOnExit();
        CommonTestUtils.printLog4jDebugConfig(log4jProps);
        return log4jProps;
    }

    public static String getJavaCommandPath() {
        Process process;
        ProcessBuilder bld2;
        File javaHome = new File(System.getProperty("java.home"));
        String path1 = new File(javaHome, "java").getAbsolutePath();
        String path2 = new File(new File(javaHome, "bin"), "java").getAbsolutePath();
        try {
            bld2 = new ProcessBuilder(path1, "-version");
            process = bld2.start();
            if (process.waitFor() == 0) {
                return path1;
            }
        }
        catch (Throwable bld2) {
            // empty catch block
        }
        try {
            bld2 = new ProcessBuilder(path2, "-version");
            process = bld2.start();
            if (process.waitFor() == 0) {
                return path2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static boolean isProcessAlive(Process process) {
        if (process == null) {
            return false;
        }
        try {
            process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    public static void printLog4jDebugConfig(File file) throws IOException {
        try (PrintWriter writer = new PrintWriter(new FileWriter(file));){
            writer.println("log4j.rootLogger=DEBUG, console");
            writer.println("log4j.appender.console=org.apache.log4j.ConsoleAppender");
            writer.println("log4j.appender.console.target = System.err");
            writer.println("log4j.appender.console.layout=org.apache.log4j.PatternLayout");
            writer.println("log4j.appender.console.layout.ConversionPattern=%-4r [%t] %-5p %c %x - %m%n");
            writer.println("log4j.logger.org.eclipse.jetty.util.log=OFF");
            writer.println("log4j.logger.org.apache.zookeeper=OFF");
            writer.flush();
        }
    }

    public static File createTempDirectory() throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        for (int i = 0; i < 10; ++i) {
            File dir = new File(tempDir, UUID.randomUUID().toString());
            if (dir.exists() || !dir.mkdirs()) continue;
            return dir;
        }
        throw new IOException("Could not create temporary file directory");
    }

    public static boolean isSteamContentEqual(InputStream input1, InputStream input2) throws IOException {
        int ch2;
        if (!(input1 instanceof BufferedInputStream)) {
            input1 = new BufferedInputStream(input1);
        }
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static class PipeForwarder
    extends Thread {
        private final StringWriter target;
        private final InputStream source;

        public PipeForwarder(InputStream source, StringWriter target) {
            super("Pipe Forwarder");
            this.setDaemon(true);
            this.source = source;
            this.target = target;
            this.start();
        }

        @Override
        public void run() {
            try {
                int next;
                while ((next = this.source.read()) != -1) {
                    this.target.write(next);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

