/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoverableCompletedCheckpointStore
implements CompletedCheckpointStore {
    private static final Logger LOG = LoggerFactory.getLogger(RecoverableCompletedCheckpointStore.class);
    private final ArrayDeque<CompletedCheckpoint> checkpoints = new ArrayDeque(2);
    private final ArrayDeque<CompletedCheckpoint> suspended = new ArrayDeque(2);
    private final int maxRetainedCheckpoints;

    public RecoverableCompletedCheckpointStore() {
        this(1);
    }

    public RecoverableCompletedCheckpointStore(int maxRetainedCheckpoints) {
        Preconditions.checkArgument((maxRetainedCheckpoints > 0 ? 1 : 0) != 0);
        this.maxRetainedCheckpoints = maxRetainedCheckpoints;
    }

    public void recover() throws Exception {
        this.checkpoints.addAll(this.suspended);
        this.suspended.clear();
    }

    public void addCheckpoint(CompletedCheckpoint checkpoint) throws Exception {
        this.checkpoints.addLast(checkpoint);
        if (this.checkpoints.size() > this.maxRetainedCheckpoints) {
            this.removeOldestCheckpoint();
        }
    }

    public void removeOldestCheckpoint() throws Exception {
        CompletedCheckpoint checkpointToSubsume = this.checkpoints.removeFirst();
        checkpointToSubsume.discardOnSubsume();
    }

    public CompletedCheckpoint getLatestCheckpoint() throws Exception {
        return this.checkpoints.isEmpty() ? null : this.checkpoints.getLast();
    }

    public void shutdown(JobStatus jobStatus) throws Exception {
        if (jobStatus.isGloballyTerminalState()) {
            this.checkpoints.clear();
            this.suspended.clear();
        } else {
            this.suspended.clear();
            for (CompletedCheckpoint checkpoint : this.checkpoints) {
                this.suspended.add(checkpoint);
            }
            this.checkpoints.clear();
        }
    }

    public List<CompletedCheckpoint> getAllCheckpoints() throws Exception {
        return new ArrayList<CompletedCheckpoint>(this.checkpoints);
    }

    public int getNumberOfRetainedCheckpoints() {
        return this.checkpoints.size();
    }

    public int getMaxNumberOfRetainedCheckpoints() {
        return this.maxRetainedCheckpoints;
    }

    public boolean requiresExternalizedCheckpoints() {
        return false;
    }
}

