/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.util.Preconditions;

public class ZooKeeperTestUtils {
    public static Configuration createZooKeeperHAConfig(String zooKeeperQuorum, String fsStateHandlePath) {
        return ZooKeeperTestUtils.configureZooKeeperHA(new Configuration(), zooKeeperQuorum, fsStateHandlePath);
    }

    public static Configuration configureZooKeeperHA(Configuration config, String zooKeeperQuorum, String fsStateHandlePath) {
        Preconditions.checkNotNull((Object)config, (String)"Configuration");
        Preconditions.checkNotNull((Object)zooKeeperQuorum, (String)"ZooKeeper quorum");
        Preconditions.checkNotNull((Object)fsStateHandlePath, (String)"File state handle backend path");
        config.setInteger(WebOptions.PORT, -1);
        config.setString(HighAvailabilityOptions.HA_MODE, "ZOOKEEPER");
        config.setString(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, zooKeeperQuorum);
        int connTimeout = 5000;
        if (System.getenv().containsKey("CI")) {
            connTimeout = 30000;
        }
        config.setInteger(HighAvailabilityOptions.ZOOKEEPER_CONNECTION_TIMEOUT, connTimeout);
        config.setInteger(HighAvailabilityOptions.ZOOKEEPER_SESSION_TIMEOUT, connTimeout);
        config.setString(CoreOptions.STATE_BACKEND, "FILESYSTEM");
        config.setString("state.backend.fs.checkpointdir", fsStateHandlePath + "/checkpoints");
        config.setString(HighAvailabilityOptions.HA_STORAGE_PATH, fsStateHandlePath + "/recovery");
        config.setString(AkkaOptions.WATCH_HEARTBEAT_INTERVAL, "1000 ms");
        config.setString(AkkaOptions.WATCH_HEARTBEAT_PAUSE, "6 s");
        config.setInteger(AkkaOptions.WATCH_THRESHOLD, 9);
        config.setString(AkkaOptions.ASK_TIMEOUT, "100 s");
        config.setString(HighAvailabilityOptions.HA_JOB_DELAY, "10 s");
        return config;
    }
}

