/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestingFatalErrorHandler
implements FatalErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TestingFatalErrorHandler.class);
    private final AtomicReference<Throwable> atomicThrowable = new AtomicReference<Object>(null);

    public void rethrowError() throws TestingException {
        Throwable throwable = this.atomicThrowable.get();
        if (throwable != null) {
            throw new TestingException(throwable);
        }
    }

    public boolean hasExceptionOccurred() {
        return this.atomicThrowable.get() != null;
    }

    public Throwable getException() {
        return this.atomicThrowable.get();
    }

    public void onFatalError(Throwable exception) {
        LOG.error("OnFatalError:", exception);
        if (!this.atomicThrowable.compareAndSet(null, exception)) {
            this.atomicThrowable.get().addSuppressed(exception);
        }
    }

    private static final class TestingException
    extends Exception {
        private static final long serialVersionUID = -4648195335470914498L;

        public TestingException(String message) {
            super(message);
        }

        public TestingException(String message, Throwable cause) {
            super(message, cause);
        }

        public TestingException(Throwable cause) {
            super(cause);
        }
    }
}

