/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.retriever;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.leaderelection.TestingLeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.webmonitor.retriever.LeaderGatewayRetriever;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class LeaderGatewayRetrieverTest
extends TestLogger {
    @Test
    public void testGatewayRetrievalFailures() throws Exception {
        String address = "localhost";
        UUID leaderId = UUID.randomUUID();
        RpcGateway rpcGateway = (RpcGateway)Mockito.mock(RpcGateway.class);
        TestingLeaderGatewayRetriever leaderGatewayRetriever = new TestingLeaderGatewayRetriever(rpcGateway);
        TestingLeaderRetrievalService testingLeaderRetrievalService = new TestingLeaderRetrievalService();
        testingLeaderRetrievalService.start((LeaderRetrievalListener)leaderGatewayRetriever);
        CompletableFuture gatewayFuture = leaderGatewayRetriever.getFuture();
        testingLeaderRetrievalService.notifyListener("localhost", leaderId);
        try {
            gatewayFuture.get();
            Assert.fail((String)"The first future should have been failed.");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)leaderGatewayRetriever.getNow().isPresent());
        Assert.assertEquals((Object)rpcGateway, leaderGatewayRetriever.getNow().get());
    }

    private static class TestingLeaderGatewayRetriever
    extends LeaderGatewayRetriever<RpcGateway> {
        private final RpcGateway rpcGateway;
        private int retrievalAttempt = 0;

        private TestingLeaderGatewayRetriever(RpcGateway rpcGateway) {
            this.rpcGateway = rpcGateway;
        }

        protected CompletableFuture<RpcGateway> createGateway(CompletableFuture<Tuple2<String, UUID>> leaderFuture) {
            CompletableFuture result = this.retrievalAttempt < 2 ? FutureUtils.completedExceptionally((Throwable)new FlinkException("Could not resolve the leader gateway.")) : CompletableFuture.completedFuture(this.rpcGateway);
            ++this.retrievalAttempt;
            return result;
        }
    }
}

