/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import akka.actor.ActorSystem;
import com.typesafe.config.Config;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.ContaineredTaskManagerParameters;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.jobmaster.JobManagerGateway;
import org.apache.flink.runtime.webmonitor.WebMonitor;
import org.apache.flink.runtime.webmonitor.WebMonitorUtils;
import org.apache.flink.runtime.webmonitor.retriever.LeaderGatewayRetriever;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceRetriever;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.ChannelException;
import org.apache.flink.util.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.duration.FiniteDuration;

public class BootstrapTools {
    private static final Logger LOG = LoggerFactory.getLogger(BootstrapTools.class);
    private static final String DYNAMIC_PROPERTIES_OPT = "D";

    public static ActorSystem startActorSystem(Configuration configuration, String listeningAddress, String portRangeDefinition, Logger logger) throws Exception {
        Iterator portsIterator;
        try {
            portsIterator = NetUtils.getPortRangeFromString((String)portRangeDefinition);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid port range definition: " + portRangeDefinition);
        }
        while (portsIterator.hasNext()) {
            ServerSocket availableSocket = NetUtils.createSocketFromPorts((Iterator)portsIterator, (NetUtils.SocketFactory)new NetUtils.SocketFactory(){

                public ServerSocket createSocket(int port) throws IOException {
                    return new ServerSocket(port);
                }
            });
            if (availableSocket == null) {
                throw new BindException("Unable to allocate further port in port range: " + portRangeDefinition);
            }
            int port = availableSocket.getLocalPort();
            try {
                availableSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                return BootstrapTools.startActorSystem(configuration, listeningAddress, port, logger);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof ChannelException || cause instanceof BindException) continue;
                throw e;
            }
        }
        throw new BindException("Could not start actor system on any port in port range " + portRangeDefinition);
    }

    public static ActorSystem startActorSystem(Configuration configuration, String listeningAddress, int listeningPort, Logger logger) throws Exception {
        String hostPortUrl = NetUtils.unresolvedHostAndPortToNormalizedString((String)listeningAddress, (int)listeningPort);
        logger.info("Trying to start actor system at {}", (Object)hostPortUrl);
        try {
            Config akkaConfig = AkkaUtils.getAkkaConfig(configuration, (Option<Tuple2<String, Object>>)new Some((Object)new Tuple2((Object)listeningAddress, (Object)listeningPort)));
            logger.debug("Using akka configuration\n {}", (Object)akkaConfig);
            ActorSystem actorSystem = AkkaUtils.createActorSystem(akkaConfig);
            logger.info("Actor system started at {}", (Object)AkkaUtils.getAddress(actorSystem));
            return actorSystem;
        }
        catch (Throwable t) {
            Throwable cause;
            if (t instanceof org.apache.flink.shaded.netty4.io.netty.channel.ChannelException && (cause = t.getCause()) != null && t.getCause() instanceof BindException) {
                throw new IOException("Unable to create ActorSystem at address " + hostPortUrl + " : " + cause.getMessage(), t);
            }
            throw new Exception("Could not create actor system", t);
        }
    }

    public static WebMonitor startWebMonitorIfConfigured(Configuration config, HighAvailabilityServices highAvailabilityServices, LeaderGatewayRetriever<JobManagerGateway> jobManagerRetriever, MetricQueryServiceRetriever queryServiceRetriever, Time timeout, ScheduledExecutor scheduledExecutor, Logger logger) throws Exception {
        if (config.getInteger(WebOptions.PORT, 0) >= 0) {
            logger.info("Starting JobManager Web Frontend");
            WebMonitor monitor = WebMonitorUtils.startWebRuntimeMonitor(config, highAvailabilityServices, jobManagerRetriever, queryServiceRetriever, timeout, scheduledExecutor);
            if (monitor != null) {
                monitor.start();
            }
            return monitor;
        }
        return null;
    }

    public static Configuration generateTaskManagerConfiguration(Configuration baseConfig, String jobManagerHostname, int jobManagerPort, int numSlots, FiniteDuration registrationTimeout) {
        Configuration cfg = baseConfig.clone();
        if (jobManagerHostname != null && !jobManagerHostname.isEmpty()) {
            cfg.setString(JobManagerOptions.ADDRESS, jobManagerHostname);
        }
        if (jobManagerPort > 0) {
            cfg.setInteger(JobManagerOptions.PORT, jobManagerPort);
        }
        cfg.setString("taskmanager.maxRegistrationDuration", registrationTimeout.toString());
        if (numSlots != -1) {
            cfg.setInteger("taskmanager.numberOfTaskSlots", numSlots);
        }
        return cfg;
    }

    public static void writeConfiguration(Configuration cfg, File file) throws IOException {
        try (FileWriter fwrt = new FileWriter(file);
             PrintWriter out = new PrintWriter(fwrt);){
            for (String key : cfg.keySet()) {
                String value = cfg.getString(key, null);
                out.print(key);
                out.print(": ");
                out.println(value);
            }
        }
    }

    public static void substituteDeprecatedConfigKey(Configuration config, String deprecated, String designated) {
        String valueForDeprecated;
        if (!config.containsKey(designated) && (valueForDeprecated = config.getString(deprecated, null)) != null) {
            config.setString(designated, valueForDeprecated);
        }
    }

    public static void substituteDeprecatedConfigPrefix(Configuration config, String deprecatedPrefix, String designatedPrefix) {
        int prefixLen = deprecatedPrefix.length();
        Configuration replacement = new Configuration();
        for (String key : config.keySet()) {
            String newKey;
            if (!key.startsWith(deprecatedPrefix) || config.containsKey(newKey = designatedPrefix + key.substring(prefixLen))) continue;
            replacement.setString(newKey, config.getString(key, null));
        }
        config.addAll(replacement);
    }

    public static org.apache.commons.cli.Option newDynamicPropertiesOption() {
        return new org.apache.commons.cli.Option(DYNAMIC_PROPERTIES_OPT, true, "Dynamic properties");
    }

    public static Configuration parseDynamicProperties(CommandLine cmd) {
        Configuration config = new Configuration();
        String[] values = cmd.getOptionValues(DYNAMIC_PROPERTIES_OPT);
        if (values != null) {
            for (String value : values) {
                String[] pair = value.split("=", 2);
                if (pair.length == 1) {
                    config.setString(pair[0], Boolean.TRUE.toString());
                    continue;
                }
                if (pair.length != 2) continue;
                config.setString(pair[0], pair[1]);
            }
        }
        return config;
    }

    public static String getTaskManagerShellCommand(Configuration flinkConfig, ContaineredTaskManagerParameters tmParams, String configDirectory, String logDirectory, boolean hasLogback, boolean hasLog4j, boolean hasKrb5, Class<?> mainClass) {
        HashMap<String, String> startCommandValues = new HashMap<String, String>();
        startCommandValues.put("java", "$JAVA_HOME/bin/java");
        ArrayList<String> params = new ArrayList<String>();
        params.add(String.format("-Xms%dm", tmParams.taskManagerHeapSizeMB()));
        params.add(String.format("-Xmx%dm", tmParams.taskManagerHeapSizeMB()));
        if (tmParams.taskManagerDirectMemoryLimitMB() >= 0L) {
            params.add(String.format("-XX:MaxDirectMemorySize=%dm", tmParams.taskManagerDirectMemoryLimitMB()));
        }
        startCommandValues.put("jvmmem", StringUtils.join(params, (char)' '));
        String javaOpts = flinkConfig.getString(CoreOptions.FLINK_JVM_OPTIONS);
        if (flinkConfig.getString(CoreOptions.FLINK_TM_JVM_OPTIONS).length() > 0) {
            javaOpts = javaOpts + " " + flinkConfig.getString(CoreOptions.FLINK_TM_JVM_OPTIONS);
        }
        if (hasKrb5) {
            javaOpts = javaOpts + " -Djava.security.krb5.conf=krb5.conf";
        }
        startCommandValues.put("jvmopts", javaOpts);
        String logging = "";
        if (hasLogback || hasLog4j) {
            logging = "-Dlog.file=" + logDirectory + "/taskmanager.log";
            if (hasLogback) {
                logging = logging + " -Dlogback.configurationFile=file:" + configDirectory + "/logback.xml";
            }
            if (hasLog4j) {
                logging = logging + " -Dlog4j.configuration=file:" + configDirectory + "/log4j.properties";
            }
        }
        startCommandValues.put("logging", logging);
        startCommandValues.put("class", mainClass.getName());
        startCommandValues.put("redirects", "1> " + logDirectory + "/taskmanager.out 2> " + logDirectory + "/taskmanager.err");
        startCommandValues.put("args", "--configDir " + configDirectory);
        String commandTemplate = flinkConfig.getString("yarn.container-start-command-template", "%java% %jvmmem% %jvmopts% %logging% %class% %args% %redirects%");
        String startCommand = BootstrapTools.getStartCommand(commandTemplate, startCommandValues);
        LOG.debug("TaskManager start command: " + startCommand);
        return startCommand;
    }

    private BootstrapTools() {
    }

    public static String getStartCommand(String template, Map<String, String> startCommandValues) {
        for (Map.Entry<String, String> variable : startCommandValues.entrySet()) {
            template = template.replace("%" + variable.getKey() + "%", variable.getValue());
        }
        return template;
    }
}

