/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint;

import java.util.Optional;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.dispatcher.Dispatcher;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.dispatcher.DispatcherId;
import org.apache.flink.runtime.dispatcher.DispatcherRestEndpoint;
import org.apache.flink.runtime.dispatcher.StandaloneDispatcher;
import org.apache.flink.runtime.entrypoint.ClusterEntrypoint;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rest.RestServerEndpointConfiguration;
import org.apache.flink.runtime.rest.handler.RestHandlerConfiguration;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.webmonitor.retriever.LeaderGatewayRetriever;
import org.apache.flink.runtime.webmonitor.retriever.impl.RpcGatewayRetriever;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;

public abstract class SessionClusterEntrypoint
extends ClusterEntrypoint {
    private ResourceManager<?> resourceManager;
    private Dispatcher dispatcher;
    private LeaderRetrievalService dispatcherLeaderRetrievalService;
    private DispatcherRestEndpoint dispatcherRestEndpoint;

    public SessionClusterEntrypoint(Configuration configuration) {
        super(configuration);
    }

    @Override
    protected void startClusterComponents(Configuration configuration, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, BlobServer blobServer, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry) throws Exception {
        this.dispatcherLeaderRetrievalService = highAvailabilityServices.getDispatcherLeaderRetriever();
        RpcGatewayRetriever<DispatcherId, DispatcherGateway> dispatcherGatewayRetriever = new RpcGatewayRetriever<DispatcherId, DispatcherGateway>(rpcService, DispatcherGateway.class, DispatcherId::new, 10, Time.milliseconds((long)50L));
        this.dispatcherRestEndpoint = this.createDispatcherRestEndpoint(configuration, dispatcherGatewayRetriever, rpcService.getExecutor());
        LOG.debug("Starting Dispatcher REST endpoint.");
        this.dispatcherRestEndpoint.start();
        this.resourceManager = this.createResourceManager(configuration, ResourceID.generate(), rpcService, highAvailabilityServices, heartbeatServices, metricRegistry, this);
        this.dispatcher = this.createDispatcher(configuration, rpcService, highAvailabilityServices, this.resourceManager.getSelfGateway(ResourceManagerGateway.class), blobServer, heartbeatServices, metricRegistry, this, Optional.of(this.dispatcherRestEndpoint.getRestAddress()));
        LOG.debug("Starting ResourceManager.");
        this.resourceManager.start();
        LOG.debug("Starting Dispatcher.");
        this.dispatcher.start();
        this.dispatcherLeaderRetrievalService.start(dispatcherGatewayRetriever);
    }

    @Override
    protected void stopClusterComponents(boolean cleanupHaData) throws Exception {
        Throwable exception = null;
        if (this.dispatcherRestEndpoint != null) {
            this.dispatcherRestEndpoint.shutdown(Time.seconds((long)10L));
        }
        if (this.dispatcherLeaderRetrievalService != null) {
            try {
                this.dispatcherLeaderRetrievalService.stop();
            }
            catch (Throwable t) {
                exception = ExceptionUtils.firstOrSuppressed((Throwable)t, exception);
            }
        }
        if (this.dispatcher != null) {
            try {
                this.dispatcher.shutDown();
            }
            catch (Throwable t) {
                exception = ExceptionUtils.firstOrSuppressed((Throwable)t, (Throwable)exception);
            }
        }
        if (this.resourceManager != null) {
            try {
                this.resourceManager.shutDown();
            }
            catch (Throwable t) {
                exception = ExceptionUtils.firstOrSuppressed((Throwable)t, (Throwable)exception);
            }
        }
        if (exception != null) {
            throw new FlinkException("Could not properly shut down the session cluster entry point.", exception);
        }
    }

    protected DispatcherRestEndpoint createDispatcherRestEndpoint(Configuration configuration, LeaderGatewayRetriever<DispatcherGateway> dispatcherGatewayRetriever, Executor executor) throws Exception {
        return new DispatcherRestEndpoint(RestServerEndpointConfiguration.fromConfiguration(configuration), dispatcherGatewayRetriever, configuration, RestHandlerConfiguration.fromConfiguration(configuration), executor);
    }

    protected Dispatcher createDispatcher(Configuration configuration, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, ResourceManagerGateway resourceManagerGateway, BlobServer blobServer, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry, FatalErrorHandler fatalErrorHandler, Optional<String> restAddress) throws Exception {
        return new StandaloneDispatcher(rpcService, "dispatcher", configuration, highAvailabilityServices, resourceManagerGateway, blobServer, heartbeatServices, metricRegistry, fatalErrorHandler, restAddress);
    }

    protected abstract ResourceManager<?> createResourceManager(Configuration var1, ResourceID var2, RpcService var3, HighAvailabilityServices var4, HeartbeatServices var5, MetricRegistry var6, FatalErrorHandler var7) throws Exception;
}

