/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.nio.ByteBuffer;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufInputStream;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufOutputStream;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelOutboundHandlerAdapter;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelPromise;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.MessageToMessageDecoder;
import org.apache.flink.util.Preconditions;

public abstract class NettyMessage {
    static final int HEADER_LENGTH = 9;
    static final int MAGIC_NUMBER = -1159983106;

    abstract ByteBuf write(ByteBufAllocator var1) throws Exception;

    private static ByteBuf allocateBuffer(ByteBufAllocator allocator, byte id) {
        return NettyMessage.allocateBuffer(allocator, id, -1);
    }

    private static ByteBuf allocateBuffer(ByteBufAllocator allocator, byte id, int length) {
        Preconditions.checkArgument((length <= 0x7FFFFFF6 ? 1 : 0) != 0);
        ByteBuf buffer = length != -1 ? allocator.directBuffer(9 + length) : allocator.directBuffer();
        buffer.writeInt(9 + length);
        buffer.writeInt(-1159983106);
        buffer.writeByte((int)id);
        return buffer;
    }

    static class CloseRequest
    extends NettyMessage {
        private static final byte ID = 5;

        CloseRequest() {
        }

        @Override
        ByteBuf write(ByteBufAllocator allocator) throws Exception {
            return NettyMessage.allocateBuffer(allocator, (byte)5, 0);
        }

        static CloseRequest readFrom(ByteBuf buffer) throws Exception {
            return new CloseRequest();
        }
    }

    static class CancelPartitionRequest
    extends NettyMessage {
        private static final byte ID = 4;
        final InputChannelID receiverId;

        CancelPartitionRequest(InputChannelID receiverId) {
            this.receiverId = (InputChannelID)((Object)Preconditions.checkNotNull((Object)((Object)receiverId)));
        }

        @Override
        ByteBuf write(ByteBufAllocator allocator) throws Exception {
            ByteBuf result = null;
            try {
                result = NettyMessage.allocateBuffer(allocator, (byte)4, 16);
                this.receiverId.writeTo(result);
            }
            catch (Throwable t) {
                if (result != null) {
                    result.release();
                }
                throw new IOException(t);
            }
            return result;
        }

        static CancelPartitionRequest readFrom(ByteBuf buffer) throws Exception {
            return new CancelPartitionRequest(InputChannelID.fromByteBuf(buffer));
        }
    }

    static class TaskEventRequest
    extends NettyMessage {
        private static final byte ID = 3;
        final TaskEvent event;
        final InputChannelID receiverId;
        final ResultPartitionID partitionId;

        TaskEventRequest(TaskEvent event, ResultPartitionID partitionId, InputChannelID receiverId) {
            this.event = (TaskEvent)Preconditions.checkNotNull((Object)event);
            this.receiverId = (InputChannelID)((Object)Preconditions.checkNotNull((Object)((Object)receiverId)));
            this.partitionId = (ResultPartitionID)Preconditions.checkNotNull((Object)partitionId);
        }

        @Override
        ByteBuf write(ByteBufAllocator allocator) throws IOException {
            ByteBuf result = null;
            try {
                ByteBuffer serializedEvent = EventSerializer.toSerializedEvent(this.event);
                result = NettyMessage.allocateBuffer(allocator, (byte)3, 4 + serializedEvent.remaining() + 16 + 16 + 16);
                result.writeInt(serializedEvent.remaining());
                result.writeBytes(serializedEvent);
                this.partitionId.getPartitionId().writeTo(result);
                this.partitionId.getProducerId().writeTo(result);
                this.receiverId.writeTo(result);
                return result;
            }
            catch (Throwable t) {
                if (result != null) {
                    result.release();
                }
                throw new IOException(t);
            }
        }

        static TaskEventRequest readFrom(ByteBuf buffer, ClassLoader classLoader) throws IOException {
            int length = buffer.readInt();
            ByteBuffer serializedEvent = buffer.nioBuffer(buffer.readerIndex(), length);
            buffer.readerIndex(buffer.readerIndex() + length);
            TaskEvent event = (TaskEvent)EventSerializer.fromSerializedEvent(serializedEvent, classLoader);
            ResultPartitionID partitionId = new ResultPartitionID(IntermediateResultPartitionID.fromByteBuf(buffer), ExecutionAttemptID.fromByteBuf(buffer));
            InputChannelID receiverId = InputChannelID.fromByteBuf(buffer);
            return new TaskEventRequest(event, partitionId, receiverId);
        }
    }

    static class PartitionRequest
    extends NettyMessage {
        private static final byte ID = 2;
        final ResultPartitionID partitionId;
        final int queueIndex;
        final InputChannelID receiverId;
        final int credit;

        PartitionRequest(ResultPartitionID partitionId, int queueIndex, InputChannelID receiverId, int credit) {
            this.partitionId = (ResultPartitionID)Preconditions.checkNotNull((Object)partitionId);
            this.queueIndex = queueIndex;
            this.receiverId = (InputChannelID)((Object)Preconditions.checkNotNull((Object)((Object)receiverId)));
            this.credit = credit;
        }

        @Override
        ByteBuf write(ByteBufAllocator allocator) throws IOException {
            ByteBuf result = null;
            try {
                result = NettyMessage.allocateBuffer(allocator, (byte)2, 56);
                this.partitionId.getPartitionId().writeTo(result);
                this.partitionId.getProducerId().writeTo(result);
                result.writeInt(this.queueIndex);
                this.receiverId.writeTo(result);
                result.writeInt(this.credit);
                return result;
            }
            catch (Throwable t) {
                if (result != null) {
                    result.release();
                }
                throw new IOException(t);
            }
        }

        static PartitionRequest readFrom(ByteBuf buffer) {
            ResultPartitionID partitionId = new ResultPartitionID(IntermediateResultPartitionID.fromByteBuf(buffer), ExecutionAttemptID.fromByteBuf(buffer));
            int queueIndex = buffer.readInt();
            InputChannelID receiverId = InputChannelID.fromByteBuf(buffer);
            int credit = buffer.readInt();
            return new PartitionRequest(partitionId, queueIndex, receiverId, credit);
        }

        public String toString() {
            return String.format("PartitionRequest(%s:%d)", this.partitionId, this.queueIndex);
        }
    }

    static class ErrorResponse
    extends NettyMessage {
        private static final byte ID = 1;
        final Throwable cause;
        @Nullable
        final InputChannelID receiverId;

        ErrorResponse(Throwable cause) {
            this.cause = (Throwable)Preconditions.checkNotNull((Object)cause);
            this.receiverId = null;
        }

        ErrorResponse(Throwable cause, InputChannelID receiverId) {
            this.cause = (Throwable)Preconditions.checkNotNull((Object)cause);
            this.receiverId = receiverId;
        }

        boolean isFatalError() {
            return this.receiverId == null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        ByteBuf write(ByteBufAllocator allocator) throws IOException {
            ByteBuf result = NettyMessage.allocateBuffer(allocator, (byte)1);
            try (ObjectOutputStream oos = new ObjectOutputStream((OutputStream)new ByteBufOutputStream(result));){
                oos.writeObject(this.cause);
                if (this.receiverId != null) {
                    result.writeBoolean(true);
                    this.receiverId.writeTo(result);
                } else {
                    result.writeBoolean(false);
                }
                result.setInt(0, result.readableBytes());
                ByteBuf byteBuf = result;
                return byteBuf;
            }
            catch (Throwable t) {
                result.release();
                if (!(t instanceof IOException)) throw new IOException(t);
                throw (IOException)t;
            }
        }

        static ErrorResponse readFrom(ByteBuf buffer) throws Exception {
            try (ObjectInputStream ois = new ObjectInputStream((InputStream)new ByteBufInputStream(buffer));){
                Object obj = ois.readObject();
                if (!(obj instanceof Throwable)) {
                    throw new ClassCastException("Read object expected to be of type Throwable, actual type is " + obj.getClass() + ".");
                }
                if (buffer.readBoolean()) {
                    InputChannelID receiverId = InputChannelID.fromByteBuf(buffer);
                    ErrorResponse errorResponse = new ErrorResponse((Throwable)obj, receiverId);
                    return errorResponse;
                }
                ErrorResponse errorResponse = new ErrorResponse((Throwable)obj);
                return errorResponse;
            }
        }
    }

    static class BufferResponse
    extends NettyMessage {
        private static final byte ID = 0;
        @Nullable
        final Buffer buffer;
        final InputChannelID receiverId;
        final int sequenceNumber;
        final boolean isBuffer;
        final int size;
        @Nullable
        ByteBuf retainedSlice;

        private BufferResponse(ByteBuf retainedSlice, boolean isBuffer, int sequenceNumber, InputChannelID receiverId) {
            this.buffer = null;
            this.retainedSlice = (ByteBuf)Preconditions.checkNotNull((Object)retainedSlice);
            this.size = retainedSlice.writerIndex();
            this.isBuffer = isBuffer;
            this.sequenceNumber = sequenceNumber;
            this.receiverId = (InputChannelID)((Object)Preconditions.checkNotNull((Object)((Object)receiverId)));
        }

        BufferResponse(Buffer buffer, int sequenceNumber, InputChannelID receiverId) {
            this.buffer = (Buffer)Preconditions.checkNotNull((Object)buffer);
            this.retainedSlice = null;
            this.isBuffer = buffer.isBuffer();
            this.size = buffer.getSize();
            this.sequenceNumber = sequenceNumber;
            this.receiverId = (InputChannelID)((Object)Preconditions.checkNotNull((Object)((Object)receiverId)));
        }

        boolean isBuffer() {
            return this.isBuffer;
        }

        int getSize() {
            return this.size;
        }

        ByteBuf getNettyBuffer() {
            return this.retainedSlice;
        }

        void releaseBuffer() {
            if (this.retainedSlice != null) {
                this.retainedSlice.release();
                this.retainedSlice = null;
            }
        }

        @Override
        ByteBuf write(ByteBufAllocator allocator) throws IOException {
            Preconditions.checkNotNull((Object)this.buffer, (String)"No buffer instance to serialize.");
            int length = 25 + this.buffer.getSize();
            ByteBuf result = null;
            try {
                result = NettyMessage.allocateBuffer(allocator, (byte)0, length);
                this.receiverId.writeTo(result);
                result.writeInt(this.sequenceNumber);
                result.writeBoolean(this.buffer.isBuffer());
                result.writeInt(this.buffer.getSize());
                result.writeBytes(this.buffer.getNioBuffer());
                ByteBuf byteBuf = result;
                return byteBuf;
            }
            catch (Throwable t) {
                if (result != null) {
                    result.release();
                }
                throw new IOException(t);
            }
            finally {
                this.buffer.recycle();
            }
        }

        static BufferResponse readFrom(ByteBuf buffer) {
            InputChannelID receiverId = InputChannelID.fromByteBuf(buffer);
            int sequenceNumber = buffer.readInt();
            boolean isBuffer = buffer.readBoolean();
            int size = buffer.readInt();
            ByteBuf retainedSlice = buffer.readSlice(size).retain();
            return new BufferResponse(retainedSlice, isBuffer, sequenceNumber, receiverId);
        }
    }

    @ChannelHandler.Sharable
    static class NettyMessageDecoder
    extends MessageToMessageDecoder<ByteBuf> {
        NettyMessageDecoder() {
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
            NettyMessage decodedMsg;
            int magicNumber = msg.readInt();
            if (magicNumber != -1159983106) {
                throw new IllegalStateException("Network stream corrupted: received incorrect magic number.");
            }
            byte msgId = msg.readByte();
            switch (msgId) {
                case 0: {
                    decodedMsg = BufferResponse.readFrom(msg);
                    break;
                }
                case 2: {
                    decodedMsg = PartitionRequest.readFrom(msg);
                    break;
                }
                case 3: {
                    decodedMsg = TaskEventRequest.readFrom(msg, ((Object)((Object)this)).getClass().getClassLoader());
                    break;
                }
                case 1: {
                    decodedMsg = ErrorResponse.readFrom(msg);
                    break;
                }
                case 4: {
                    decodedMsg = CancelPartitionRequest.readFrom(msg);
                    break;
                }
                case 5: {
                    decodedMsg = CloseRequest.readFrom(msg);
                    break;
                }
                default: {
                    throw new ProtocolException("Received unknown message from producer: " + msg);
                }
            }
            out.add(decodedMsg);
        }
    }

    @ChannelHandler.Sharable
    static class NettyMessageEncoder
    extends ChannelOutboundHandlerAdapter {
        NettyMessageEncoder() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (msg instanceof NettyMessage) {
                ByteBuf serialized = null;
                try {
                    serialized = ((NettyMessage)msg).write(ctx.alloc());
                }
                catch (Throwable t) {
                    throw new IOException("Error while serializing message: " + msg, t);
                }
                finally {
                    if (serialized != null) {
                        ctx.write((Object)serialized, promise);
                    }
                }
            } else {
                ctx.write(msg, promise);
            }
        }

        static LengthFieldBasedFrameDecoder createFrameLengthDecoder() {
            return new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, -4, 4);
        }
    }
}

