/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.jobmaster.JobManagerGateway;
import org.apache.flink.runtime.rest.NotFoundException;
import org.apache.flink.runtime.rest.handler.legacy.AbstractJsonRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;

public abstract class AbstractExecutionGraphRequestHandler
extends AbstractJsonRequestHandler {
    private final ExecutionGraphCache executionGraphCache;

    public AbstractExecutionGraphRequestHandler(ExecutionGraphCache executionGraphCache, Executor executor) {
        super(executor);
        this.executionGraphCache = (ExecutionGraphCache)Preconditions.checkNotNull((Object)executionGraphCache);
    }

    @Override
    public CompletableFuture<String> handleJsonRequest(Map<String, String> pathParams, Map<String, String> queryParams, JobManagerGateway jobManagerGateway) {
        JobID jid;
        String jidString = pathParams.get("jobid");
        if (jidString == null) {
            throw new RuntimeException("JobId parameter missing");
        }
        try {
            jid = JobID.fromHexString((String)jidString);
        }
        catch (Exception e) {
            return FutureUtils.completedExceptionally(new FlinkException("Invalid JobID string '" + jidString + "'", (Throwable)e));
        }
        CompletableFuture<AccessExecutionGraph> graphFuture = this.executionGraphCache.getExecutionGraph(jid, jobManagerGateway);
        return ((CompletableFuture)graphFuture.exceptionally(throwable -> {
            throw new CompletionException(new NotFoundException("Could not find job " + jid + '.'));
        })).thenComposeAsync(executionGraph -> this.handleRequest((AccessExecutionGraph)executionGraph, pathParams), this.executor);
    }

    public abstract CompletableFuture<String> handleRequest(AccessExecutionGraph var1, Map<String, String> var2);
}

