/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.runtime.rest.messages.ErrorResponseBody;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.util.RestMapperUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFuture;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFutureListener;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpHeaders;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMessage;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.LastHttpContent;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HandlerUtils.class);
    private static final ObjectMapper mapper = RestMapperUtils.getStrictObjectMapper();

    public static <P extends ResponseBody> void sendResponse(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest, P response, HttpResponseStatus statusCode) {
        StringWriter sw = new StringWriter();
        try {
            mapper.writeValue((Writer)sw, response);
        }
        catch (IOException ioe) {
            LOG.error("Internal server error. Could not map response to JSON.", (Throwable)ioe);
            HandlerUtils.sendErrorResponse(channelHandlerContext, httpRequest, new ErrorResponseBody("Internal server error. Could not map response to JSON."), HttpResponseStatus.INTERNAL_SERVER_ERROR);
            return;
        }
        HandlerUtils.sendResponse(channelHandlerContext, httpRequest, sw.toString(), statusCode);
    }

    public static void sendErrorResponse(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest, ErrorResponseBody errorMessage, HttpResponseStatus statusCode) {
        StringWriter sw = new StringWriter();
        try {
            mapper.writeValue((Writer)sw, (Object)errorMessage);
        }
        catch (IOException e) {
            LOG.error("Internal server error. Could not map error response to JSON.", (Throwable)e);
            HandlerUtils.sendResponse(channelHandlerContext, httpRequest, "Internal server error. Could not map error response to JSON.", HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        HandlerUtils.sendResponse(channelHandlerContext, httpRequest, sw.toString(), statusCode);
    }

    public static void sendResponse(@Nonnull ChannelHandlerContext channelHandlerContext, @Nonnull HttpRequest httpRequest, @Nonnull String message, @Nonnull HttpResponseStatus statusCode) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, statusCode);
        response.headers().set("Content-Type", (Object)"application/json");
        if (HttpHeaders.isKeepAlive((HttpMessage)httpRequest)) {
            response.headers().set("Connection", (Object)"keep-alive");
        }
        byte[] buf = message.getBytes(ConfigConstants.DEFAULT_CHARSET);
        ByteBuf b = Unpooled.copiedBuffer((byte[])buf);
        HttpHeaders.setContentLength((HttpMessage)response, (long)buf.length);
        channelHandlerContext.write((Object)response);
        channelHandlerContext.write((Object)b);
        ChannelFuture lastContentFuture = channelHandlerContext.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!HttpHeaders.isKeepAlive((HttpMessage)httpRequest)) {
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

