/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcGateway;

public class RpcUtils {
    public static final Time INF_TIMEOUT = Time.milliseconds((long)Long.MAX_VALUE);

    public static Set<Class<? extends RpcGateway>> extractImplementedRpcGateways(Class<?> clazz) {
        HashSet<Class<? extends RpcGateway>> interfaces = new HashSet<Class<? extends RpcGateway>>();
        while (clazz != null) {
            for (Class<?> interfaze : clazz.getInterfaces()) {
                if (!RpcGateway.class.isAssignableFrom(interfaze)) continue;
                interfaces.add(interfaze);
            }
            clazz = clazz.getSuperclass();
        }
        return interfaces;
    }

    public static void terminateRpcEndpoint(RpcEndpoint rpcEndpoint, Time timeout) throws ExecutionException, InterruptedException, TimeoutException {
        rpcEndpoint.shutDown();
        rpcEndpoint.getTerminationFuture().get(timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
    }

    private RpcUtils() {
    }
}

