/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSerializationUtil;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.io.VersionedIOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.KeyedBackendStateMetaInfoSnapshotReaderWriters;
import org.apache.flink.runtime.state.RegisteredKeyedBackendStateMetaInfo;
import org.apache.flink.util.Preconditions;

public class KeyedBackendSerializationProxy<K>
extends VersionedIOReadableWritable {
    public static final int VERSION = 4;
    private boolean usingKeyGroupCompression;
    private TypeSerializer<K> keySerializer;
    private TypeSerializerConfigSnapshot keySerializerConfigSnapshot;
    private List<RegisteredKeyedBackendStateMetaInfo.Snapshot<?, ?>> stateMetaInfoSnapshots;
    private ClassLoader userCodeClassLoader;

    public KeyedBackendSerializationProxy(ClassLoader userCodeClassLoader) {
        this.userCodeClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)userCodeClassLoader);
    }

    public KeyedBackendSerializationProxy(TypeSerializer<K> keySerializer, List<RegisteredKeyedBackendStateMetaInfo.Snapshot<?, ?>> stateMetaInfoSnapshots, boolean compression) {
        this.usingKeyGroupCompression = compression;
        this.keySerializer = (TypeSerializer)Preconditions.checkNotNull(keySerializer);
        this.keySerializerConfigSnapshot = (TypeSerializerConfigSnapshot)Preconditions.checkNotNull((Object)keySerializer.snapshotConfiguration());
        Preconditions.checkNotNull(stateMetaInfoSnapshots);
        Preconditions.checkArgument((stateMetaInfoSnapshots.size() <= Short.MAX_VALUE ? 1 : 0) != 0);
        this.stateMetaInfoSnapshots = stateMetaInfoSnapshots;
    }

    public List<RegisteredKeyedBackendStateMetaInfo.Snapshot<?, ?>> getStateMetaInfoSnapshots() {
        return this.stateMetaInfoSnapshots;
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public TypeSerializerConfigSnapshot getKeySerializerConfigSnapshot() {
        return this.keySerializerConfigSnapshot;
    }

    public boolean isUsingKeyGroupCompression() {
        return this.usingKeyGroupCompression;
    }

    public int getVersion() {
        return 4;
    }

    public int[] getCompatibleVersions() {
        return new int[]{4, 3, 2, 1};
    }

    public void write(DataOutputView out) throws IOException {
        super.write(out);
        out.writeBoolean(this.usingKeyGroupCompression);
        TypeSerializerSerializationUtil.writeSerializersAndConfigsWithResilience((DataOutputView)out, Collections.singletonList(new Tuple2(this.keySerializer, (Object)this.keySerializerConfigSnapshot)));
        out.writeShort(this.stateMetaInfoSnapshots.size());
        for (RegisteredKeyedBackendStateMetaInfo.Snapshot<?, ?> metaInfo : this.stateMetaInfoSnapshots) {
            KeyedBackendStateMetaInfoSnapshotReaderWriters.getWriterForVersion(4, metaInfo).writeStateMetaInfo(out);
        }
    }

    public void read(DataInputView in) throws IOException {
        super.read(in);
        int readVersion = this.getReadVersion();
        this.usingKeyGroupCompression = readVersion >= 4 ? in.readBoolean() : false;
        if (readVersion >= 3) {
            Tuple2 keySerializerAndConfig = (Tuple2)TypeSerializerSerializationUtil.readSerializersAndConfigsWithResilience((DataInputView)in, (ClassLoader)this.userCodeClassLoader).get(0);
            this.keySerializer = (TypeSerializer)keySerializerAndConfig.f0;
            this.keySerializerConfigSnapshot = (TypeSerializerConfigSnapshot)keySerializerAndConfig.f1;
        } else {
            this.keySerializer = TypeSerializerSerializationUtil.tryReadSerializer((DataInputView)in, (ClassLoader)this.userCodeClassLoader);
            this.keySerializerConfigSnapshot = null;
        }
        int numKvStates = in.readShort();
        this.stateMetaInfoSnapshots = new ArrayList(numKvStates);
        for (int i = 0; i < numKvStates; ++i) {
            this.stateMetaInfoSnapshots.add(KeyedBackendStateMetaInfoSnapshotReaderWriters.getReaderForVersion(this.getReadVersion(), this.userCodeClassLoader).readStateMetaInfo(in));
        }
    }
}

