/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSerializationUtil;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.RegisteredKeyedBackendStateMetaInfo;
import org.apache.flink.util.Preconditions;

public class KeyedBackendStateMetaInfoSnapshotReaderWriters {
    public static <N, S> KeyedBackendStateMetaInfoWriter getWriterForVersion(int version, RegisteredKeyedBackendStateMetaInfo.Snapshot<N, S> stateMetaInfo) {
        switch (version) {
            case 1: 
            case 2: {
                return new KeyedBackendStateMetaInfoWriterV1V2<N, S>(stateMetaInfo);
            }
            case 3: 
            case 4: {
                return new KeyedBackendStateMetaInfoWriterV3<N, S>(stateMetaInfo);
            }
        }
        throw new IllegalStateException("Unrecognized keyed backend state meta info writer version: " + version);
    }

    public static KeyedBackendStateMetaInfoReader getReaderForVersion(int version, ClassLoader userCodeClassLoader) {
        switch (version) {
            case 1: 
            case 2: {
                return new KeyedBackendStateMetaInfoReaderV1V2(userCodeClassLoader);
            }
            case 3: 
            case 4: {
                return new KeyedBackendStateMetaInfoReaderV3(userCodeClassLoader);
            }
        }
        throw new IllegalStateException("Unrecognized keyed backend state meta info reader version: " + version);
    }

    static class KeyedBackendStateMetaInfoReaderV3<N, S>
    extends AbstractKeyedBackendStateMetaInfoReader {
        public KeyedBackendStateMetaInfoReaderV3(ClassLoader userCodeClassLoader) {
            super(userCodeClassLoader);
        }

        @Override
        public RegisteredKeyedBackendStateMetaInfo.Snapshot<N, S> readStateMetaInfo(DataInputView in) throws IOException {
            RegisteredKeyedBackendStateMetaInfo.Snapshot metaInfo = new RegisteredKeyedBackendStateMetaInfo.Snapshot();
            metaInfo.setStateType(StateDescriptor.Type.values()[in.readInt()]);
            metaInfo.setName(in.readUTF());
            List serializersAndConfigs = TypeSerializerSerializationUtil.readSerializersAndConfigsWithResilience((DataInputView)in, (ClassLoader)this.userCodeClassLoader);
            metaInfo.setNamespaceSerializer((TypeSerializer)((Tuple2)serializersAndConfigs.get((int)0)).f0);
            metaInfo.setNamespaceSerializerConfigSnapshot((TypeSerializerConfigSnapshot)((Tuple2)serializersAndConfigs.get((int)0)).f1);
            metaInfo.setStateSerializer((TypeSerializer)((Tuple2)serializersAndConfigs.get((int)1)).f0);
            metaInfo.setStateSerializerConfigSnapshot((TypeSerializerConfigSnapshot)((Tuple2)serializersAndConfigs.get((int)1)).f1);
            return metaInfo;
        }
    }

    static class KeyedBackendStateMetaInfoReaderV1V2<N, S>
    extends AbstractKeyedBackendStateMetaInfoReader {
        public KeyedBackendStateMetaInfoReaderV1V2(ClassLoader userCodeClassLoader) {
            super(userCodeClassLoader);
        }

        @Override
        public RegisteredKeyedBackendStateMetaInfo.Snapshot<N, S> readStateMetaInfo(DataInputView in) throws IOException {
            RegisteredKeyedBackendStateMetaInfo.Snapshot metaInfo = new RegisteredKeyedBackendStateMetaInfo.Snapshot();
            metaInfo.setStateType(StateDescriptor.Type.values()[in.readInt()]);
            metaInfo.setName(in.readUTF());
            metaInfo.setNamespaceSerializer(TypeSerializerSerializationUtil.tryReadSerializer((DataInputView)in, (ClassLoader)this.userCodeClassLoader));
            metaInfo.setStateSerializer(TypeSerializerSerializationUtil.tryReadSerializer((DataInputView)in, (ClassLoader)this.userCodeClassLoader));
            metaInfo.setNamespaceSerializerConfigSnapshot(null);
            metaInfo.setStateSerializerConfigSnapshot(null);
            return metaInfo;
        }
    }

    static abstract class AbstractKeyedBackendStateMetaInfoReader
    implements KeyedBackendStateMetaInfoReader {
        protected final ClassLoader userCodeClassLoader;

        public AbstractKeyedBackendStateMetaInfoReader(ClassLoader userCodeClassLoader) {
            this.userCodeClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)userCodeClassLoader);
        }
    }

    public static interface KeyedBackendStateMetaInfoReader<N, S> {
        public RegisteredKeyedBackendStateMetaInfo.Snapshot<N, S> readStateMetaInfo(DataInputView var1) throws IOException;
    }

    static class KeyedBackendStateMetaInfoWriterV3<N, S>
    extends AbstractKeyedBackendStateMetaInfoWriter<N, S> {
        public KeyedBackendStateMetaInfoWriterV3(RegisteredKeyedBackendStateMetaInfo.Snapshot<N, S> stateMetaInfo) {
            super(stateMetaInfo);
        }

        @Override
        public void writeStateMetaInfo(DataOutputView out) throws IOException {
            out.writeInt(this.stateMetaInfo.getStateType().ordinal());
            out.writeUTF(this.stateMetaInfo.getName());
            TypeSerializerSerializationUtil.writeSerializersAndConfigsWithResilience((DataOutputView)out, Arrays.asList(new Tuple2(this.stateMetaInfo.getNamespaceSerializer(), (Object)this.stateMetaInfo.getNamespaceSerializerConfigSnapshot()), new Tuple2(this.stateMetaInfo.getStateSerializer(), (Object)this.stateMetaInfo.getStateSerializerConfigSnapshot())));
        }
    }

    static class KeyedBackendStateMetaInfoWriterV1V2<N, S>
    extends AbstractKeyedBackendStateMetaInfoWriter<N, S> {
        public KeyedBackendStateMetaInfoWriterV1V2(RegisteredKeyedBackendStateMetaInfo.Snapshot<N, S> stateMetaInfo) {
            super(stateMetaInfo);
        }

        @Override
        public void writeStateMetaInfo(DataOutputView out) throws IOException {
            out.writeInt(this.stateMetaInfo.getStateType().ordinal());
            out.writeUTF(this.stateMetaInfo.getName());
            TypeSerializerSerializationUtil.writeSerializer((DataOutputView)out, this.stateMetaInfo.getNamespaceSerializer());
            TypeSerializerSerializationUtil.writeSerializer((DataOutputView)out, this.stateMetaInfo.getStateSerializer());
        }
    }

    static abstract class AbstractKeyedBackendStateMetaInfoWriter<N, S>
    implements KeyedBackendStateMetaInfoWriter {
        protected final RegisteredKeyedBackendStateMetaInfo.Snapshot<N, S> stateMetaInfo;

        public AbstractKeyedBackendStateMetaInfoWriter(RegisteredKeyedBackendStateMetaInfo.Snapshot<N, S> stateMetaInfo) {
            this.stateMetaInfo = (RegisteredKeyedBackendStateMetaInfo.Snapshot)Preconditions.checkNotNull(stateMetaInfo);
        }
    }

    public static interface KeyedBackendStateMetaInfoWriter {
        public void writeStateMetaInfo(DataOutputView var1) throws IOException;
    }
}

