/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSerializationUtil;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.RegisteredOperatorBackendStateMetaInfo;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorBackendStateMetaInfoSnapshotReaderWriters {
    private static final Logger LOG = LoggerFactory.getLogger(OperatorBackendStateMetaInfoSnapshotReaderWriters.class);

    public static <S> OperatorBackendStateMetaInfoWriter getWriterForVersion(int version, RegisteredOperatorBackendStateMetaInfo.Snapshot<S> stateMetaInfo) {
        switch (version) {
            case 1: {
                return new OperatorBackendStateMetaInfoWriterV1<S>(stateMetaInfo);
            }
            case 2: {
                return new OperatorBackendStateMetaInfoWriterV2<S>(stateMetaInfo);
            }
        }
        throw new IllegalStateException("Unrecognized operator backend state meta info writer version: " + version);
    }

    public static <S> OperatorBackendStateMetaInfoReader<S> getReaderForVersion(int version, ClassLoader userCodeClassLoader) {
        switch (version) {
            case 1: {
                return new OperatorBackendStateMetaInfoReaderV1(userCodeClassLoader);
            }
            case 2: {
                return new OperatorBackendStateMetaInfoReaderV2(userCodeClassLoader);
            }
        }
        throw new IllegalStateException("Unrecognized operator backend state meta info reader version: " + version);
    }

    public static class OperatorBackendStateMetaInfoReaderV2<S>
    extends AbstractOperatorBackendStateMetaInfoReader<S> {
        public OperatorBackendStateMetaInfoReaderV2(ClassLoader userCodeClassLoader) {
            super(userCodeClassLoader);
        }

        @Override
        public RegisteredOperatorBackendStateMetaInfo.Snapshot<S> readStateMetaInfo(DataInputView in) throws IOException {
            RegisteredOperatorBackendStateMetaInfo.Snapshot stateMetaInfo = new RegisteredOperatorBackendStateMetaInfo.Snapshot();
            stateMetaInfo.setName(in.readUTF());
            stateMetaInfo.setAssignmentMode(OperatorStateHandle.Mode.values()[in.readByte()]);
            Tuple2 stateSerializerAndConfig = (Tuple2)TypeSerializerSerializationUtil.readSerializersAndConfigsWithResilience((DataInputView)in, (ClassLoader)this.userCodeClassLoader).get(0);
            stateMetaInfo.setPartitionStateSerializer((TypeSerializer)stateSerializerAndConfig.f0);
            stateMetaInfo.setPartitionStateSerializerConfigSnapshot((TypeSerializerConfigSnapshot)stateSerializerAndConfig.f1);
            return stateMetaInfo;
        }
    }

    public static class OperatorBackendStateMetaInfoReaderV1<S>
    extends AbstractOperatorBackendStateMetaInfoReader<S> {
        public OperatorBackendStateMetaInfoReaderV1(ClassLoader userCodeClassLoader) {
            super(userCodeClassLoader);
        }

        @Override
        public RegisteredOperatorBackendStateMetaInfo.Snapshot<S> readStateMetaInfo(DataInputView in) throws IOException {
            RegisteredOperatorBackendStateMetaInfo.Snapshot stateMetaInfo = new RegisteredOperatorBackendStateMetaInfo.Snapshot();
            stateMetaInfo.setName(in.readUTF());
            stateMetaInfo.setAssignmentMode(OperatorStateHandle.Mode.values()[in.readByte()]);
            DataInputViewStream dis = new DataInputViewStream(in);
            ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
            try (InstantiationUtil.FailureTolerantObjectInputStream ois = new InstantiationUtil.FailureTolerantObjectInputStream((InputStream)dis, this.userCodeClassLoader);){
                Thread.currentThread().setContextClassLoader(this.userCodeClassLoader);
                TypeSerializer stateSerializer = (TypeSerializer)ois.readObject();
                stateMetaInfo.setPartitionStateSerializer(stateSerializer);
            }
            catch (ClassNotFoundException exception) {
                throw new IOException(exception);
            }
            finally {
                Thread.currentThread().setContextClassLoader(previousClassLoader);
            }
            stateMetaInfo.setPartitionStateSerializerConfigSnapshot(null);
            return stateMetaInfo;
        }
    }

    public static abstract class AbstractOperatorBackendStateMetaInfoReader<S>
    implements OperatorBackendStateMetaInfoReader<S> {
        protected final ClassLoader userCodeClassLoader;

        public AbstractOperatorBackendStateMetaInfoReader(ClassLoader userCodeClassLoader) {
            this.userCodeClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)userCodeClassLoader);
        }
    }

    public static interface OperatorBackendStateMetaInfoReader<S> {
        public RegisteredOperatorBackendStateMetaInfo.Snapshot<S> readStateMetaInfo(DataInputView var1) throws IOException;
    }

    public static class OperatorBackendStateMetaInfoWriterV2<S>
    extends AbstractOperatorBackendStateMetaInfoWriter<S> {
        public OperatorBackendStateMetaInfoWriterV2(RegisteredOperatorBackendStateMetaInfo.Snapshot<S> stateMetaInfo) {
            super(stateMetaInfo);
        }

        @Override
        public void writeStateMetaInfo(DataOutputView out) throws IOException {
            out.writeUTF(this.stateMetaInfo.getName());
            out.writeByte(this.stateMetaInfo.getAssignmentMode().ordinal());
            TypeSerializerSerializationUtil.writeSerializersAndConfigsWithResilience((DataOutputView)out, Collections.singletonList(new Tuple2(this.stateMetaInfo.getPartitionStateSerializer(), (Object)this.stateMetaInfo.getPartitionStateSerializerConfigSnapshot())));
        }
    }

    public static class OperatorBackendStateMetaInfoWriterV1<S>
    extends AbstractOperatorBackendStateMetaInfoWriter<S> {
        public OperatorBackendStateMetaInfoWriterV1(RegisteredOperatorBackendStateMetaInfo.Snapshot<S> stateMetaInfo) {
            super(stateMetaInfo);
        }

        @Override
        public void writeStateMetaInfo(DataOutputView out) throws IOException {
            out.writeUTF(this.stateMetaInfo.getName());
            out.writeByte(this.stateMetaInfo.getAssignmentMode().ordinal());
            TypeSerializerSerializationUtil.writeSerializer((DataOutputView)out, this.stateMetaInfo.getPartitionStateSerializer());
        }
    }

    public static abstract class AbstractOperatorBackendStateMetaInfoWriter<S>
    implements OperatorBackendStateMetaInfoWriter {
        protected final RegisteredOperatorBackendStateMetaInfo.Snapshot<S> stateMetaInfo;

        public AbstractOperatorBackendStateMetaInfoWriter(RegisteredOperatorBackendStateMetaInfo.Snapshot<S> stateMetaInfo) {
            this.stateMetaInfo = (RegisteredOperatorBackendStateMetaInfo.Snapshot)Preconditions.checkNotNull(stateMetaInfo);
        }
    }

    public static interface OperatorBackendStateMetaInfoWriter {
        public void writeStateMetaInfo(DataOutputView var1) throws IOException;
    }
}

