/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import akka.actor.ActorSystem;
import java.net.InetAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.util.MetricUtils;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.akka.AkkaRpcService;
import org.apache.flink.runtime.rpc.akka.AkkaRpcServiceUtils;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.taskexecutor.TaskExecutor;
import org.apache.flink.runtime.taskexecutor.TaskManagerConfiguration;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.runtime.taskexecutor.TaskManagerServicesConfiguration;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.runtime.util.Hardware;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.LeaderRetrievalUtils;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManagerRunner
implements FatalErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TaskManagerRunner.class);
    private static final int STARTUP_FAILURE_RETURN_CODE = 1;
    private static final int RUNTIME_FAILURE_RETURN_CODE = 2;
    private final Object lock = new Object();
    private final Configuration configuration;
    private final ResourceID resourceId;
    private final Time timeout;
    private final RpcService rpcService;
    private final HighAvailabilityServices highAvailabilityServices;
    private final MetricRegistryImpl metricRegistry;
    private final ExecutorService executor;
    private final TaskExecutor taskManager;

    public TaskManagerRunner(Configuration configuration, ResourceID resourceId) throws Exception {
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
        this.resourceId = (ResourceID)Preconditions.checkNotNull((Object)resourceId);
        this.timeout = AkkaUtils.getTimeoutAsTime(configuration);
        this.executor = Executors.newScheduledThreadPool(Hardware.getNumberCPUCores(), new ExecutorThreadFactory("taskmanager-future"));
        this.highAvailabilityServices = HighAvailabilityServicesUtils.createHighAvailabilityServices(configuration, this.executor, HighAvailabilityServicesUtils.AddressResolution.TRY_ADDRESS_RESOLUTION);
        this.rpcService = TaskManagerRunner.createRpcService(configuration, this.highAvailabilityServices);
        HeartbeatServices heartbeatServices = HeartbeatServices.fromConfiguration(configuration);
        this.metricRegistry = new MetricRegistryImpl(MetricRegistryConfiguration.fromConfiguration(configuration));
        ActorSystem actorSystem = ((AkkaRpcService)this.rpcService).getActorSystem();
        this.metricRegistry.startQueryService(actorSystem, resourceId);
        this.taskManager = TaskManagerRunner.startTaskManager(this.configuration, this.resourceId, this.rpcService, this.highAvailabilityServices, heartbeatServices, this.metricRegistry, false, this);
    }

    public void start() throws Exception {
        this.taskManager.start();
    }

    public void shutDown() throws Exception {
        this.shutDownInternally();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutDownInternally() throws Exception {
        Exception exception = null;
        Object object = this.lock;
        synchronized (object) {
            try {
                this.taskManager.shutDown();
            }
            catch (Exception e) {
                exception = e;
            }
            try {
                this.metricRegistry.shutdown();
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
            }
            this.rpcService.stopService();
            try {
                this.highAvailabilityServices.close();
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
            }
            ExecutorUtils.gracefulShutdown((long)this.timeout.toMilliseconds(), (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{this.executor});
            if (exception != null) {
                throw exception;
            }
        }
    }

    public CompletableFuture<Boolean> getTerminationFuture() {
        return this.taskManager.getTerminationFuture();
    }

    @Override
    public void onFatalError(Throwable exception) {
        LOG.error("Fatal error occurred while executing the TaskManager. Shutting it down...", exception);
        try {
            this.shutDown();
        }
        catch (Throwable t) {
            LOG.error("Could not properly shut down TaskManager.", t);
        }
        System.exit(2);
    }

    public static void main(String[] args) throws Exception {
        EnvironmentInformation.logEnvironmentInfo(LOG, "TaskManager", args);
        SignalHandler.register(LOG);
        JvmShutdownSafeguard.installAsShutdownHook(LOG);
        long maxOpenFileHandles = EnvironmentInformation.getOpenFileHandlesLimit();
        if (maxOpenFileHandles != -1L) {
            LOG.info("Maximum number of open file descriptors is {}.", (Object)maxOpenFileHandles);
        } else {
            LOG.info("Cannot determine the maximum number of open file descriptors");
        }
        ParameterTool parameterTool = ParameterTool.fromArgs((String[])args);
        String configDir = parameterTool.get("configDir");
        final Configuration configuration = GlobalConfiguration.loadConfiguration((String)configDir);
        SecurityUtils.install(new SecurityConfiguration(configuration));
        try {
            SecurityUtils.getInstalledContext().runSecured(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    TaskManagerRunner.runTaskManager(configuration, ResourceID.generate());
                    return null;
                }
            });
        }
        catch (Throwable t) {
            LOG.error("TaskManager initialization failed.", t);
            System.exit(1);
        }
    }

    public static void runTaskManager(Configuration configuration, ResourceID resourceId) throws Exception {
        TaskManagerRunner taskManagerRunner = new TaskManagerRunner(configuration, resourceId);
        taskManagerRunner.start();
    }

    public static TaskExecutor startTaskManager(Configuration configuration, ResourceID resourceID, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry, boolean localCommunicationOnly, FatalErrorHandler fatalErrorHandler) throws Exception {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)resourceID);
        Preconditions.checkNotNull((Object)rpcService);
        Preconditions.checkNotNull((Object)highAvailabilityServices);
        InetAddress remoteAddress = InetAddress.getByName(rpcService.getAddress());
        TaskManagerServicesConfiguration taskManagerServicesConfiguration = TaskManagerServicesConfiguration.fromConfiguration(configuration, remoteAddress, localCommunicationOnly);
        TaskManagerServices taskManagerServices = TaskManagerServices.fromConfiguration(taskManagerServicesConfiguration, resourceID);
        TaskManagerMetricGroup taskManagerMetricGroup = MetricUtils.instantiateTaskManagerMetricGroup(metricRegistry, taskManagerServices.getTaskManagerLocation(), taskManagerServices.getNetworkEnvironment());
        TaskManagerConfiguration taskManagerConfiguration = TaskManagerConfiguration.fromConfiguration(configuration);
        return new TaskExecutor(rpcService, taskManagerConfiguration, taskManagerServices.getTaskManagerLocation(), taskManagerServices.getMemoryManager(), taskManagerServices.getIOManager(), taskManagerServices.getNetworkEnvironment(), highAvailabilityServices, heartbeatServices, taskManagerMetricGroup, taskManagerServices.getBroadcastVariableManager(), taskManagerServices.getFileCache(), taskManagerServices.getTaskSlotTable(), taskManagerServices.getJobManagerTable(), taskManagerServices.getJobLeaderService(), fatalErrorHandler);
    }

    public static RpcService createRpcService(Configuration configuration, HighAvailabilityServices haServices) throws Exception {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)haServices);
        String taskManagerHostname = configuration.getString("taskmanager.hostname", null);
        if (taskManagerHostname != null) {
            LOG.info("Using configured hostname/address for TaskManager: {}.", (Object)taskManagerHostname);
        } else {
            Time lookupTimeout = Time.milliseconds((long)AkkaUtils.getLookupTimeout(configuration).toMillis());
            InetAddress taskManagerAddress = LeaderRetrievalUtils.findConnectingAddress(haServices.getResourceManagerLeaderRetriever(), lookupTimeout);
            taskManagerHostname = taskManagerAddress.getHostName();
            LOG.info("TaskManager will use hostname/address '{}' ({}) for communication.", (Object)taskManagerHostname, (Object)taskManagerAddress.getHostAddress());
        }
        int rpcPort = configuration.getInteger("taskmanager.rpc.port", 0);
        Preconditions.checkState((rpcPort >= 0 && rpcPort <= 65535 ? 1 : 0) != 0, (String)"Invalid value for '%s' (port for the TaskManager actor system) : %d - Leave config parameter empty or use 0 to let the system choose port automatically.", (Object[])new Object[]{"taskmanager.rpc.port", rpcPort});
        return AkkaRpcServiceUtils.createRpcService(taskManagerHostname, rpcPort, configuration);
    }
}

