/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.zookeeper;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.ZooKeeperCheckpointRecoveryFactory;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.RunningJobsRegistry;
import org.apache.flink.runtime.highavailability.zookeeper.ZooKeeperRunningJobsRegistry;
import org.apache.flink.runtime.jobmanager.SubmittedJobGraphStore;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.curator.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperHaServices
implements HighAvailabilityServices {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperHaServices.class);
    private static final String RESOURCE_MANAGER_LEADER_PATH = "/resource_manager_lock";
    private static final String DISPATCHER_LEADER_PATH = "/dispatcher_lock";
    private static final String JOB_MANAGER_LEADER_PATH = "/job_manager_lock";
    private static final String REST_SERVER_LEADER_PATH = "/rest_server_lock";
    private final CuratorFramework client;
    private final Executor executor;
    private final Configuration configuration;
    private final RunningJobsRegistry runningJobsRegistry;
    private final BlobStoreService blobStoreService;

    public ZooKeeperHaServices(CuratorFramework client, Executor executor, Configuration configuration, BlobStoreService blobStoreService) {
        this.client = (CuratorFramework)Preconditions.checkNotNull((Object)client);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
        this.runningJobsRegistry = new ZooKeeperRunningJobsRegistry(client, configuration);
        this.blobStoreService = (BlobStoreService)Preconditions.checkNotNull((Object)blobStoreService);
    }

    @Override
    public LeaderRetrievalService getResourceManagerLeaderRetriever() {
        return ZooKeeperUtils.createLeaderRetrievalService(this.client, this.configuration, RESOURCE_MANAGER_LEADER_PATH);
    }

    @Override
    public LeaderRetrievalService getDispatcherLeaderRetriever() {
        return ZooKeeperUtils.createLeaderRetrievalService(this.client, this.configuration, DISPATCHER_LEADER_PATH);
    }

    @Override
    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID) {
        return ZooKeeperUtils.createLeaderRetrievalService(this.client, this.configuration, ZooKeeperHaServices.getPathForJobManager(jobID));
    }

    @Override
    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID, String defaultJobManagerAddress) {
        return this.getJobManagerLeaderRetriever(jobID);
    }

    @Override
    public LeaderRetrievalService getWebMonitorLeaderRetriever() {
        return ZooKeeperUtils.createLeaderRetrievalService(this.client, this.configuration, REST_SERVER_LEADER_PATH);
    }

    @Override
    public LeaderElectionService getResourceManagerLeaderElectionService() {
        return ZooKeeperUtils.createLeaderElectionService(this.client, this.configuration, RESOURCE_MANAGER_LEADER_PATH);
    }

    @Override
    public LeaderElectionService getDispatcherLeaderElectionService() {
        return ZooKeeperUtils.createLeaderElectionService(this.client, this.configuration, DISPATCHER_LEADER_PATH);
    }

    @Override
    public LeaderElectionService getJobManagerLeaderElectionService(JobID jobID) {
        return ZooKeeperUtils.createLeaderElectionService(this.client, this.configuration, ZooKeeperHaServices.getPathForJobManager(jobID));
    }

    @Override
    public LeaderElectionService getWebMonitorLeaderElectionService() {
        return ZooKeeperUtils.createLeaderElectionService(this.client, this.configuration, REST_SERVER_LEADER_PATH);
    }

    @Override
    public CheckpointRecoveryFactory getCheckpointRecoveryFactory() {
        return new ZooKeeperCheckpointRecoveryFactory(this.client, this.configuration, this.executor);
    }

    @Override
    public SubmittedJobGraphStore getSubmittedJobGraphStore() throws Exception {
        return ZooKeeperUtils.createSubmittedJobGraphs(this.client, this.configuration, this.executor);
    }

    @Override
    public RunningJobsRegistry getRunningJobsRegistry() {
        return this.runningJobsRegistry;
    }

    @Override
    public BlobStore createBlobStore() throws IOException {
        return this.blobStoreService;
    }

    @Override
    public void close() throws Exception {
        Throwable exception = null;
        try {
            this.blobStoreService.close();
        }
        catch (Throwable t) {
            exception = t;
        }
        this.internalClose();
        if (exception != null) {
            ExceptionUtils.rethrowException((Throwable)exception, (String)"Could not properly close the ZooKeeperHaServices.");
        }
    }

    @Override
    public void closeAndCleanupAllData() throws Exception {
        LOG.info("Close and clean up all data for ZooKeeperHaServices.");
        Throwable exception = null;
        try {
            this.blobStoreService.closeAndCleanupAllData();
        }
        catch (Throwable t) {
            exception = t;
        }
        this.internalClose();
        if (exception != null) {
            ExceptionUtils.rethrowException((Throwable)exception, (String)"Could not properly close and clean up all data of ZooKeeperHaServices.");
        }
    }

    private void internalClose() {
        this.client.close();
    }

    private static String getPathForJobManager(JobID jobID) {
        return "/" + jobID + JOB_MANAGER_LEADER_PATH;
    }
}

