/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.rest.handler.legacy.AbstractExecutionGraphRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.JsonFactory;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.util.MutableIOMetrics;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.util.FlinkException;

public class JobDetailsHandler
extends AbstractExecutionGraphRequestHandler {
    private static final String JOB_DETAILS_REST_PATH = "/jobs/:jobid";
    private static final String JOB_DETAILS_VERTICES_REST_PATH = "/jobs/:jobid/vertices";
    private final MetricFetcher fetcher;

    public JobDetailsHandler(ExecutionGraphCache executionGraphHolder, Executor executor, MetricFetcher fetcher) {
        super(executionGraphHolder, executor);
        this.fetcher = fetcher;
    }

    @Override
    public String[] getPaths() {
        return new String[]{JOB_DETAILS_REST_PATH, JOB_DETAILS_VERTICES_REST_PATH};
    }

    @Override
    public CompletableFuture<String> handleRequest(AccessExecutionGraph graph, Map<String, String> params) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return JobDetailsHandler.createJobDetailsJson(graph, this.fetcher);
            }
            catch (IOException e) {
                throw new CompletionException(new FlinkException("Could not create job details json.", (Throwable)e));
            }
        }, this.executor);
    }

    /*
     * WARNING - void declaration
     */
    public static String createJobDetailsJson(AccessExecutionGraph graph, @Nullable MetricFetcher fetcher) throws IOException {
        void var12_11;
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.JACKSON_FACTORY.createGenerator((Writer)writer);
        long now = System.currentTimeMillis();
        gen.writeStartObject();
        gen.writeStringField("jid", graph.getJobID().toString());
        gen.writeStringField("name", graph.getJobName());
        gen.writeBooleanField("isStoppable", graph.isStoppable());
        gen.writeStringField("state", graph.getState().name());
        long jobStartTime = graph.getStatusTimestamp(JobStatus.CREATED);
        long jobEndTime = graph.getState().isGloballyTerminalState() ? graph.getStatusTimestamp(graph.getState()) : -1L;
        gen.writeNumberField("start-time", jobStartTime);
        gen.writeNumberField("end-time", jobEndTime);
        gen.writeNumberField("duration", (jobEndTime > 0L ? jobEndTime : now) - jobStartTime);
        gen.writeNumberField("now", now);
        gen.writeObjectFieldStart("timestamps");
        JobStatus[] jobStatusArray = JobStatus.values();
        int n = jobStatusArray.length;
        boolean bl = false;
        while (var12_11 < n) {
            JobStatus status = jobStatusArray[var12_11];
            gen.writeNumberField(status.name(), graph.getStatusTimestamp(status));
            ++var12_11;
        }
        gen.writeEndObject();
        int[] jobVerticesPerState = new int[ExecutionState.values().length];
        gen.writeArrayFieldStart("vertices");
        for (AccessExecutionJobVertex accessExecutionJobVertex : graph.getVerticesTopologically()) {
            long duration;
            int[] tasksPerState = new int[ExecutionState.values().length];
            long startTime = Long.MAX_VALUE;
            long endTime = 0L;
            boolean allFinished = true;
            for (AccessExecutionVertex accessExecutionVertex : accessExecutionJobVertex.getTaskVertices()) {
                ExecutionState state = accessExecutionVertex.getExecutionState();
                int n2 = state.ordinal();
                tasksPerState[n2] = tasksPerState[n2] + 1;
                long started = accessExecutionVertex.getStateTimestamp(ExecutionState.DEPLOYING);
                if (started > 0L) {
                    startTime = Math.min(startTime, started);
                }
                allFinished &= state.isTerminal();
                endTime = Math.max(endTime, accessExecutionVertex.getStateTimestamp(state));
            }
            if (startTime < Long.MAX_VALUE) {
                if (allFinished) {
                    duration = endTime - startTime;
                } else {
                    endTime = -1L;
                    duration = now - startTime;
                }
            } else {
                startTime = -1L;
                endTime = -1L;
                duration = -1L;
            }
            ExecutionState jobVertexState = ExecutionJobVertex.getAggregateJobVertexState(tasksPerState, accessExecutionJobVertex.getParallelism());
            int n3 = jobVertexState.ordinal();
            jobVerticesPerState[n3] = jobVerticesPerState[n3] + 1;
            gen.writeStartObject();
            gen.writeStringField("id", accessExecutionJobVertex.getJobVertexId().toString());
            gen.writeStringField("name", accessExecutionJobVertex.getName());
            gen.writeNumberField("parallelism", accessExecutionJobVertex.getParallelism());
            gen.writeStringField("status", jobVertexState.name());
            gen.writeNumberField("start-time", startTime);
            gen.writeNumberField("end-time", endTime);
            gen.writeNumberField("duration", duration);
            gen.writeObjectFieldStart("tasks");
            for (ExecutionState state : ExecutionState.values()) {
                gen.writeNumberField(state.name(), tasksPerState[state.ordinal()]);
            }
            gen.writeEndObject();
            MutableIOMetrics mutableIOMetrics = new MutableIOMetrics();
            for (AccessExecutionVertex vertex : accessExecutionJobVertex.getTaskVertices()) {
                mutableIOMetrics.addIOMetrics(vertex.getCurrentExecutionAttempt(), fetcher, graph.getJobID().toString(), accessExecutionJobVertex.getJobVertexId().toString());
            }
            mutableIOMetrics.writeIOMetricsAsJson(gen);
            gen.writeEndObject();
        }
        gen.writeEndArray();
        gen.writeObjectFieldStart("status-counts");
        for (ExecutionState state : ExecutionState.values()) {
            gen.writeNumberField(state.name(), jobVerticesPerState[state.ordinal()]);
        }
        gen.writeEndObject();
        gen.writeFieldName("plan");
        gen.writeRawValue(graph.getJsonPlan());
        gen.writeEndObject();
        gen.close();
        return writer.toString();
    }

    public static class JobDetailsJsonArchivist
    implements JsonArchivist {
        @Override
        public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
            String json = JobDetailsHandler.createJobDetailsJson(graph, null);
            String path1 = JobDetailsHandler.JOB_DETAILS_REST_PATH.replace(":jobid", graph.getJobID().toString());
            String path2 = JobDetailsHandler.JOB_DETAILS_VERTICES_REST_PATH.replace(":jobid", graph.getJobID().toString());
            ArrayList<ArchivedJson> archives = new ArrayList<ArchivedJson>();
            archives.add(new ArchivedJson(path1, json));
            archives.add(new ArchivedJson(path2, json));
            return archives;
        }
    }
}

