/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.KeyGroupPartitioner;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.runtime.state.StateSnapshot;
import org.apache.flink.runtime.state.StateSnapshotTransformer;
import org.apache.flink.runtime.state.heap.AbstractStateTableSnapshot;
import org.apache.flink.runtime.state.heap.CopyOnWriteStateTable;
import org.apache.flink.runtime.state.heap.InternalKeyContext;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;

@Internal
public class CopyOnWriteStateTableSnapshot<K, N, S>
extends AbstractStateTableSnapshot<K, N, S, CopyOnWriteStateTable<K, N, S>> {
    private final int snapshotVersion;
    @Nonnull
    private final CopyOnWriteStateTable.StateTableEntry<K, N, S>[] snapshotData;
    @Nonnegative
    private final int numberOfEntriesInSnapshotData;
    @Nonnull
    private final TypeSerializer<K> localKeySerializer;
    @Nonnull
    private final TypeSerializer<N> localNamespaceSerializer;
    @Nonnull
    private final TypeSerializer<S> localStateSerializer;
    @Nullable
    private StateSnapshot.StateKeyGroupWriter partitionedStateTableSnapshot;

    CopyOnWriteStateTableSnapshot(CopyOnWriteStateTable<K, N, S> owningStateTable) {
        super(owningStateTable);
        this.snapshotData = owningStateTable.snapshotTableArrays();
        this.snapshotVersion = owningStateTable.getStateTableVersion();
        this.numberOfEntriesInSnapshotData = owningStateTable.size();
        this.localKeySerializer = owningStateTable.keyContext.getKeySerializer().duplicate();
        this.localNamespaceSerializer = owningStateTable.metaInfo.getNamespaceSerializer().duplicate();
        this.localStateSerializer = owningStateTable.metaInfo.getStateSerializer().duplicate();
        this.partitionedStateTableSnapshot = null;
    }

    int getSnapshotVersion() {
        return this.snapshotVersion;
    }

    @Override
    @Nonnull
    public StateSnapshot.StateKeyGroupWriter getKeyGroupWriter() {
        if (this.partitionedStateTableSnapshot == null) {
            InternalKeyContext keyContext = ((CopyOnWriteStateTable)this.owningStateTable).keyContext;
            int numberOfKeyGroups = keyContext.getNumberOfKeyGroups();
            KeyGroupRange keyGroupRange = keyContext.getKeyGroupRange();
            KeyGroupPartitioner.ElementWriterFunction elementWriterFunction = (element, dov) -> {
                this.localNamespaceSerializer.serialize(element.namespace, dov);
                this.localKeySerializer.serialize(element.key, dov);
                this.localStateSerializer.serialize(element.state, dov);
            };
            StateSnapshotTransformer stateSnapshotTransformer = ((CopyOnWriteStateTable)this.owningStateTable).metaInfo.getSnapshotTransformer();
            StateTableKeyGroupPartitioner stateTableKeyGroupPartitioner = stateSnapshotTransformer != null ? new TransformingStateTableKeyGroupPartitioner<K, N, S>(this.snapshotData, this.numberOfEntriesInSnapshotData, keyGroupRange, numberOfKeyGroups, elementWriterFunction, stateSnapshotTransformer) : new StateTableKeyGroupPartitioner<K, N, S>(this.snapshotData, this.numberOfEntriesInSnapshotData, keyGroupRange, numberOfKeyGroups, elementWriterFunction);
            this.partitionedStateTableSnapshot = stateTableKeyGroupPartitioner.partitionByKeyGroup();
        }
        return this.partitionedStateTableSnapshot;
    }

    @Override
    @Nonnull
    public StateMetaInfoSnapshot getMetaInfoSnapshot() {
        return ((CopyOnWriteStateTable)this.owningStateTable).metaInfo.snapshot();
    }

    @Override
    public void release() {
        ((CopyOnWriteStateTable)this.owningStateTable).releaseSnapshot(this);
    }

    boolean isOwner(CopyOnWriteStateTable<K, N, S> stateTable) {
        return stateTable == this.owningStateTable;
    }

    protected static final class TransformingStateTableKeyGroupPartitioner<K, N, S>
    extends StateTableKeyGroupPartitioner<K, N, S> {
        private final StateSnapshotTransformer<S> stateSnapshotTransformer;

        TransformingStateTableKeyGroupPartitioner(@Nonnull CopyOnWriteStateTable.StateTableEntry<K, N, S>[] snapshotData, int stateTableSize, @Nonnull KeyGroupRange keyGroupRange, int totalKeyGroups, @Nonnull KeyGroupPartitioner.ElementWriterFunction<CopyOnWriteStateTable.StateTableEntry<K, N, S>> elementWriterFunction, @Nonnull StateSnapshotTransformer<S> stateSnapshotTransformer) {
            super(snapshotData, stateTableSize, keyGroupRange, totalKeyGroups, elementWriterFunction);
            this.stateSnapshotTransformer = stateSnapshotTransformer;
        }

        @Override
        int tryAddToSource(int currentIndex, CopyOnWriteStateTable.StateTableEntry<K, N, S> entry) {
            CopyOnWriteStateTable.StateTableEntry<K, N, S> filteredEntry = this.filterEntry(entry);
            if (filteredEntry != null) {
                return this.tryAddToSource(currentIndex, filteredEntry);
            }
            return currentIndex;
        }

        private CopyOnWriteStateTable.StateTableEntry<K, N, S> filterEntry(CopyOnWriteStateTable.StateTableEntry<K, N, S> entry) {
            S transformedValue = this.stateSnapshotTransformer.filterOrTransform(entry.state);
            if (transformedValue != null) {
                CopyOnWriteStateTable.StateTableEntry<K, N, S> filteredEntry = entry;
                if (transformedValue != entry.state) {
                    filteredEntry = new CopyOnWriteStateTable.StateTableEntry<K, N, S>(entry, entry.entryVersion);
                    filteredEntry.state = transformedValue;
                }
                return filteredEntry;
            }
            return null;
        }
    }

    @VisibleForTesting
    protected static class StateTableKeyGroupPartitioner<K, N, S>
    extends KeyGroupPartitioner<CopyOnWriteStateTable.StateTableEntry<K, N, S>> {
        StateTableKeyGroupPartitioner(@Nonnull CopyOnWriteStateTable.StateTableEntry<K, N, S>[] snapshotData, @Nonnegative int stateTableSize, @Nonnull KeyGroupRange keyGroupRange, @Nonnegative int totalKeyGroups, @Nonnull KeyGroupPartitioner.ElementWriterFunction<CopyOnWriteStateTable.StateTableEntry<K, N, S>> elementWriterFunction) {
            super(new CopyOnWriteStateTable.StateTableEntry[stateTableSize], stateTableSize, snapshotData, keyGroupRange, totalKeyGroups, CopyOnWriteStateTable.StateTableEntry::getKey, elementWriterFunction);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void reportAllElementKeyGroups() {
            int flattenIndex = 0;
            for (CopyOnWriteStateTable.StateTableEntry stateTableEntry : (CopyOnWriteStateTable.StateTableEntry[])this.partitioningDestination) {
                void var5_5;
                while (null != var5_5) {
                    flattenIndex = this.tryAddToSource(flattenIndex, (CopyOnWriteStateTable.StateTableEntry<K, N, S>)var5_5);
                    CopyOnWriteStateTable.StateTableEntry stateTableEntry2 = var5_5.next;
                }
            }
        }

        int tryAddToSource(int currentIndex, CopyOnWriteStateTable.StateTableEntry<K, N, S> entry) {
            int keyGroup = KeyGroupRangeAssignment.assignToKeyGroup(entry.key, this.totalKeyGroups);
            this.reportKeyGroupOfElementAtIndex(currentIndex, keyGroup);
            ((CopyOnWriteStateTable.StateTableEntry[])this.partitioningSource)[currentIndex] = entry;
            return currentIndex + 1;
        }
    }
}

