/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.apache.flink.runtime.state.ttl.AbstractTtlState;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.runtime.state.ttl.TtlValue;
import org.apache.flink.util.FlinkRuntimeException;

class TtlMapState<K, N, UK, UV>
extends AbstractTtlState<K, N, Map<UK, UV>, Map<UK, TtlValue<UV>>, InternalMapState<K, N, UK, TtlValue<UV>>>
implements InternalMapState<K, N, UK, UV> {
    TtlMapState(InternalMapState<K, N, UK, TtlValue<UV>> original, StateTtlConfig config, TtlTimeProvider timeProvider, TypeSerializer<Map<UK, UV>> valueSerializer) {
        super(original, config, timeProvider, valueSerializer);
    }

    public UV get(UK key) throws Exception {
        return (UV)this.getWithTtlCheckAndUpdate(() -> (TtlValue)((InternalMapState)this.original).get(key), v -> ((InternalMapState)this.original).put(key, v), () -> ((InternalMapState)this.original).remove(key));
    }

    public void put(UK key, UV value) throws Exception {
        ((InternalMapState)this.original).put(key, this.wrapWithTs(value));
    }

    public void putAll(Map<UK, UV> map) throws Exception {
        if (map == null) {
            return;
        }
        HashMap<UK, TtlValue<UV>> ttlMap = new HashMap<UK, TtlValue<UV>>(map.size());
        for (UK key : map.keySet()) {
            ttlMap.put(key, this.wrapWithTs(map.get(key)));
        }
        ((InternalMapState)this.original).putAll(ttlMap);
    }

    public void remove(UK key) throws Exception {
        ((InternalMapState)this.original).remove(key);
    }

    public boolean contains(UK key) throws Exception {
        return this.get(key) != null;
    }

    public Iterable<Map.Entry<UK, UV>> entries() throws Exception {
        return this.entries(e -> e);
    }

    private <R> Iterable<R> entries(Function<Map.Entry<UK, UV>, R> resultMapper) throws Exception {
        Iterable withTs = ((InternalMapState)this.original).entries();
        return () -> new EntriesIterator(withTs == null ? Collections.emptyList() : withTs, resultMapper);
    }

    public Iterable<UK> keys() throws Exception {
        return this.entries(Map.Entry::getKey);
    }

    public Iterable<UV> values() throws Exception {
        return this.entries(Map.Entry::getValue);
    }

    public Iterator<Map.Entry<UK, UV>> iterator() throws Exception {
        return this.entries().iterator();
    }

    @Override
    public void clear() {
        ((InternalMapState)this.original).clear();
    }

    private class EntriesIterator<R>
    implements Iterator<R> {
        private final Iterator<Map.Entry<UK, TtlValue<UV>>> originalIterator;
        private final Function<Map.Entry<UK, UV>, R> resultMapper;
        private Map.Entry<UK, UV> nextUnexpired = null;
        private boolean rightAfterNextIsCalled = false;

        private EntriesIterator(@Nonnull Iterable<Map.Entry<UK, TtlValue<UV>>> withTs, Function<Map.Entry<UK, UV>, R> resultMapper) {
            this.originalIterator = withTs.iterator();
            this.resultMapper = resultMapper;
        }

        @Override
        public boolean hasNext() {
            this.rightAfterNextIsCalled = false;
            while (this.nextUnexpired == null && this.originalIterator.hasNext()) {
                this.nextUnexpired = this.getUnexpiredAndUpdateOrCleanup(this.originalIterator.next());
            }
            return this.nextUnexpired != null;
        }

        @Override
        public R next() {
            if (this.hasNext()) {
                this.rightAfterNextIsCalled = true;
                R result = this.resultMapper.apply(this.nextUnexpired);
                this.nextUnexpired = null;
                return result;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (!this.rightAfterNextIsCalled) {
                throw new IllegalStateException("next() has not been called or hasNext() has been called afterwards, remove() is supported only right after calling next()");
            }
            this.originalIterator.remove();
        }

        private Map.Entry<UK, UV> getUnexpiredAndUpdateOrCleanup(Map.Entry<UK, TtlValue<UV>> e) {
            Object unexpiredValue;
            try {
                unexpiredValue = TtlMapState.this.getWithTtlCheckAndUpdate(e::getValue, v -> ((InternalMapState)TtlMapState.this.original).put(e.getKey(), v), this.originalIterator::remove);
            }
            catch (Exception ex) {
                throw new FlinkRuntimeException((Throwable)ex);
            }
            return unexpiredValue == null ? null : new AbstractMap.SimpleEntry(e.getKey(), unexpiredValue);
        }
    }
}

