/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.jobmaster.JobManagerGateway;
import org.apache.flink.runtime.rest.handler.legacy.AbstractJsonRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.JsonFactory;
import org.apache.flink.runtime.rest.messages.DashboardConfiguration;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;

public class DashboardConfigHandler
extends AbstractJsonRequestHandler {
    public static final String DASHBOARD_CONFIG_REST_PATH = "/config";
    private final String configString;
    private final DashboardConfiguration dashboardConfiguration;

    public DashboardConfigHandler(Executor executor, long refreshInterval) {
        super(executor);
        this.dashboardConfiguration = DashboardConfiguration.from(refreshInterval, ZonedDateTime.now());
        try {
            this.configString = DashboardConfigHandler.createConfigJson(this.dashboardConfiguration);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String[] getPaths() {
        return new String[]{DASHBOARD_CONFIG_REST_PATH};
    }

    @Override
    public CompletableFuture<String> handleJsonRequest(Map<String, String> pathParams, Map<String, String> queryParams, JobManagerGateway jobManagerGateway) {
        return CompletableFuture.completedFuture(this.configString);
    }

    public static String createConfigJson(DashboardConfiguration dashboardConfiguration) throws IOException {
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.JACKSON_FACTORY.createGenerator((Writer)writer);
        gen.writeStartObject();
        gen.writeNumberField("refresh-interval", dashboardConfiguration.getRefreshInterval());
        gen.writeNumberField("timezone-offset", dashboardConfiguration.getTimeZoneOffset());
        gen.writeStringField("timezone-name", dashboardConfiguration.getTimeZoneName());
        gen.writeStringField("flink-version", dashboardConfiguration.getFlinkVersion());
        gen.writeStringField("flink-revision", dashboardConfiguration.getFlinkRevision());
        gen.writeEndObject();
        gen.close();
        return writer.toString();
    }
}

