/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.util;

import java.util.List;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.MessageQueryParameter;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;

public class HandlerRequestUtils {
    public static <X, P extends MessageQueryParameter<X>, R extends RequestBody, M extends MessageParameters> X getQueryParameter(HandlerRequest<R, M> request, Class<P> queryParameterClass) throws RestHandlerException {
        return HandlerRequestUtils.getQueryParameter(request, queryParameterClass, null);
    }

    public static <X, P extends MessageQueryParameter<X>, R extends RequestBody, M extends MessageParameters> X getQueryParameter(HandlerRequest<R, M> request, Class<P> queryParameterClass, X defaultValue) throws RestHandlerException {
        List values = request.getQueryParameter(queryParameterClass);
        if (values.size() > 1) {
            throw new RestHandlerException(String.format("Expected only one value %s.", values), HttpResponseStatus.BAD_REQUEST);
        }
        X value = values.size() == 1 ? values.get(0) : defaultValue;
        return value;
    }
}

