/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointStatsStatus;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.Preconditions;

public class FailedCheckpointStats
extends AbstractCheckpointStats {
    private static final long serialVersionUID = 8000748529515900106L;
    private final int numAcknowledgedSubtasks;
    private final long stateSize;
    private final long alignmentBuffered;
    private final long failureTimestamp;
    @Nullable
    private final SubtaskStateStats latestAcknowledgedSubtask;
    @Nullable
    private final String failureMsg;

    FailedCheckpointStats(long checkpointId, long triggerTimestamp, CheckpointProperties props2, int totalSubtaskCount, Map<JobVertexID, TaskStateStats> taskStats, int numAcknowledgedSubtasks, long stateSize, long alignmentBuffered, long failureTimestamp, @Nullable SubtaskStateStats latestAcknowledgedSubtask, @Nullable Throwable cause) {
        super(checkpointId, triggerTimestamp, props2, totalSubtaskCount, taskStats);
        Preconditions.checkArgument((numAcknowledgedSubtasks >= 0 ? 1 : 0) != 0, (Object)"Negative number of ACKs");
        this.numAcknowledgedSubtasks = numAcknowledgedSubtasks;
        Preconditions.checkArgument((stateSize >= 0L ? 1 : 0) != 0, (Object)"Negative state size");
        this.stateSize = stateSize;
        this.alignmentBuffered = alignmentBuffered;
        this.failureTimestamp = failureTimestamp;
        this.latestAcknowledgedSubtask = latestAcknowledgedSubtask;
        this.failureMsg = cause != null ? cause.getMessage() : null;
    }

    @Override
    public CheckpointStatsStatus getStatus() {
        return CheckpointStatsStatus.FAILED;
    }

    @Override
    public int getNumberOfAcknowledgedSubtasks() {
        return this.numAcknowledgedSubtasks;
    }

    @Override
    public long getStateSize() {
        return this.stateSize;
    }

    @Override
    public long getAlignmentBuffered() {
        return this.alignmentBuffered;
    }

    @Override
    @Nullable
    public SubtaskStateStats getLatestAcknowledgedSubtaskStats() {
        return this.latestAcknowledgedSubtask;
    }

    @Override
    public long getEndToEndDuration() {
        return Math.max(0L, this.failureTimestamp - this.triggerTimestamp);
    }

    public long getFailureTimestamp() {
        return this.failureTimestamp;
    }

    @Nullable
    public String getFailureMessage() {
        return this.failureMsg;
    }
}

