/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.PartitionNotFoundException;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.shaded.guava18.com.google.common.collect.HashBasedTable;
import org.apache.flink.shaded.guava18.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.guava18.com.google.common.collect.Table;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultPartitionManager
implements ResultPartitionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ResultPartitionManager.class);
    public final Table<ExecutionAttemptID, IntermediateResultPartitionID, ResultPartition> registeredPartitions = HashBasedTable.create();
    private boolean isShutdown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResultPartition(ResultPartition partition) throws IOException {
        Table<ExecutionAttemptID, IntermediateResultPartitionID, ResultPartition> table = this.registeredPartitions;
        synchronized (table) {
            Preconditions.checkState((!this.isShutdown ? 1 : 0) != 0, (Object)"Result partition manager already shut down.");
            ResultPartitionID partitionId = partition.getPartitionId();
            ResultPartition previous = (ResultPartition)this.registeredPartitions.put((Object)partitionId.getProducerId(), (Object)partitionId.getPartitionId(), (Object)partition);
            if (previous != null) {
                throw new IllegalStateException("Result partition already registered.");
            }
            LOG.debug("Registered {}.", (Object)partition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSubpartitionView createSubpartitionView(ResultPartitionID partitionId, int subpartitionIndex, BufferAvailabilityListener availabilityListener) throws IOException {
        Table<ExecutionAttemptID, IntermediateResultPartitionID, ResultPartition> table = this.registeredPartitions;
        synchronized (table) {
            ResultPartition partition = (ResultPartition)this.registeredPartitions.get((Object)partitionId.getProducerId(), (Object)partitionId.getPartitionId());
            if (partition == null) {
                throw new PartitionNotFoundException(partitionId);
            }
            LOG.debug("Requesting subpartition {} of {}.", (Object)subpartitionIndex, (Object)partition);
            return partition.createSubpartitionView(subpartitionIndex, availabilityListener);
        }
    }

    public void releasePartitionsProducedBy(ExecutionAttemptID executionId) {
        this.releasePartitionsProducedBy(executionId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePartitionsProducedBy(ExecutionAttemptID executionId, Throwable cause) {
        Table<ExecutionAttemptID, IntermediateResultPartitionID, ResultPartition> table = this.registeredPartitions;
        synchronized (table) {
            Map partitions = this.registeredPartitions.row((Object)executionId);
            for (ResultPartition partition : partitions.values()) {
                partition.release(cause);
            }
            for (IntermediateResultPartitionID partitionId : ImmutableList.copyOf(partitions.keySet())) {
                this.registeredPartitions.remove((Object)executionId, (Object)partitionId);
            }
            LOG.debug("Released all partitions produced by {}.", (Object)executionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Table<ExecutionAttemptID, IntermediateResultPartitionID, ResultPartition> table = this.registeredPartitions;
        synchronized (table) {
            LOG.debug("Releasing {} partitions because of shutdown.", (Object)this.registeredPartitions.values().size());
            for (ResultPartition partition : this.registeredPartitions.values()) {
                partition.release();
            }
            this.registeredPartitions.clear();
            this.isShutdown = true;
            LOG.debug("Successful shutdown.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onConsumedPartition(ResultPartition partition) {
        ResultPartition previous;
        LOG.debug("Received consume notification from {}.", (Object)partition);
        Table<ExecutionAttemptID, IntermediateResultPartitionID, ResultPartition> table = this.registeredPartitions;
        synchronized (table) {
            ResultPartitionID partitionId = partition.getPartitionId();
            previous = (ResultPartition)this.registeredPartitions.remove((Object)partitionId.getProducerId(), (Object)partitionId.getPartitionId());
        }
        if (partition == previous) {
            partition.release();
            LOG.debug("Released {}.", (Object)partition);
        }
    }
}

