/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metainfo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.TypeSerializerSerializationUtil;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshotSerializationUtil;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.metainfo.LegacyStateMetaInfoReaders;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoReader;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoWriter;

public class StateMetaInfoSnapshotReadersWriters {
    public static final int CURRENT_STATE_META_INFO_SNAPSHOT_VERSION = 6;

    private StateMetaInfoSnapshotReadersWriters() {
    }

    @Nonnull
    public static StateMetaInfoWriter getWriter() {
        return CurrentWriterImpl.INSTANCE;
    }

    @Nonnull
    public static StateMetaInfoReader getReader(int readVersion, @Nonnull StateTypeHint stateTypeHint) {
        if (readVersion < 5) {
            switch (stateTypeHint) {
                case KEYED_STATE: {
                    return StateMetaInfoSnapshotReadersWriters.getLegacyKeyedStateMetaInfoReader(readVersion);
                }
                case OPERATOR_STATE: {
                    return StateMetaInfoSnapshotReadersWriters.getLegacyOperatorStateMetaInfoReader(readVersion);
                }
            }
            throw new IllegalArgumentException("Unsupported state type hint: " + (Object)((Object)stateTypeHint) + " with version " + readVersion);
        }
        return StateMetaInfoSnapshotReadersWriters.getReader(readVersion);
    }

    @Nonnull
    static StateMetaInfoReader getReader(int readVersion) {
        switch (readVersion) {
            case 6: {
                return CurrentReaderImpl.INSTANCE;
            }
            case 5: {
                return V5ReaderImpl.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Unsupported read version for state meta info: " + readVersion);
    }

    @Nonnull
    private static StateMetaInfoReader getLegacyKeyedStateMetaInfoReader(int readVersion) {
        switch (readVersion) {
            case 1: 
            case 2: {
                return LegacyStateMetaInfoReaders.KeyedBackendStateMetaInfoReaderV1V2.INSTANCE;
            }
            case 3: 
            case 4: {
                return LegacyStateMetaInfoReaders.KeyedBackendStateMetaInfoReaderV3V4.INSTANCE;
            }
        }
        throw new IllegalStateException("Unrecognized keyed backend state meta info writer version: " + readVersion);
    }

    @Nonnull
    private static StateMetaInfoReader getLegacyOperatorStateMetaInfoReader(int readVersion) {
        switch (readVersion) {
            case 1: {
                return LegacyStateMetaInfoReaders.OperatorBackendStateMetaInfoReaderV1.INSTANCE;
            }
            case 2: 
            case 3: {
                return LegacyStateMetaInfoReaders.OperatorBackendStateMetaInfoReaderV2V3.INSTANCE;
            }
        }
        throw new IllegalStateException("Unrecognized operator backend state meta info writer version: " + readVersion);
    }

    static class V5ReaderImpl
    implements StateMetaInfoReader {
        private static final V5ReaderImpl INSTANCE = new V5ReaderImpl();

        V5ReaderImpl() {
        }

        @Override
        @Nonnull
        public StateMetaInfoSnapshot readStateMetaInfoSnapshot(@Nonnull DataInputView inputView, @Nonnull ClassLoader userCodeClassLoader) throws IOException {
            String stateName = inputView.readUTF();
            StateMetaInfoSnapshot.BackendStateType stateType = StateMetaInfoSnapshot.BackendStateType.values()[inputView.readInt()];
            int numOptions = inputView.readInt();
            HashMap<String, String> optionsMap = new HashMap<String, String>(numOptions);
            for (int i = 0; i < numOptions; ++i) {
                String key = inputView.readUTF();
                String value = inputView.readUTF();
                optionsMap.put(key, value);
            }
            int numSerializer = inputView.readInt();
            ArrayList<String> serializerKeys = new ArrayList<String>(numSerializer);
            HashMap serializerConfigsMap = new HashMap(numSerializer);
            for (int i = 0; i < numSerializer; ++i) {
                serializerKeys.add(inputView.readUTF());
            }
            List serializersWithConfig = TypeSerializerSerializationUtil.readSerializersAndConfigsWithResilience((DataInputView)inputView, (ClassLoader)userCodeClassLoader);
            for (int i = 0; i < numSerializer; ++i) {
                String key = (String)serializerKeys.get(i);
                Tuple2 serializerConfigTuple = (Tuple2)serializersWithConfig.get(i);
                serializerConfigsMap.put(key, (TypeSerializerSnapshot<?>)serializerConfigTuple.f1);
            }
            return new StateMetaInfoSnapshot(stateName, stateType, optionsMap, serializerConfigsMap);
        }
    }

    static class CurrentReaderImpl
    implements StateMetaInfoReader {
        private static final CurrentReaderImpl INSTANCE = new CurrentReaderImpl();

        CurrentReaderImpl() {
        }

        @Override
        @Nonnull
        public StateMetaInfoSnapshot readStateMetaInfoSnapshot(@Nonnull DataInputView inputView, @Nonnull ClassLoader userCodeClassLoader) throws IOException {
            String stateName = inputView.readUTF();
            StateMetaInfoSnapshot.BackendStateType stateType = StateMetaInfoSnapshot.BackendStateType.values()[inputView.readInt()];
            int numOptions = inputView.readInt();
            HashMap<String, String> optionsMap = new HashMap<String, String>(numOptions);
            for (int i = 0; i < numOptions; ++i) {
                String key = inputView.readUTF();
                String value = inputView.readUTF();
                optionsMap.put(key, value);
            }
            int numSerializerConfigSnapshots = inputView.readInt();
            HashMap serializerConfigsMap = new HashMap(numSerializerConfigSnapshots);
            for (int i = 0; i < numSerializerConfigSnapshots; ++i) {
                serializerConfigsMap.put(inputView.readUTF(), TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot((DataInputView)inputView, (ClassLoader)userCodeClassLoader, null));
            }
            return new StateMetaInfoSnapshot(stateName, stateType, optionsMap, serializerConfigsMap);
        }
    }

    static class CurrentWriterImpl
    implements StateMetaInfoWriter {
        private static final CurrentWriterImpl INSTANCE = new CurrentWriterImpl();

        CurrentWriterImpl() {
        }

        @Override
        public void writeStateMetaInfoSnapshot(@Nonnull StateMetaInfoSnapshot snapshot, @Nonnull DataOutputView outputView) throws IOException {
            Map<String, String> optionsMap = snapshot.getOptionsImmutable();
            Map<String, TypeSerializerSnapshot<?>> serializerConfigSnapshotsMap = snapshot.getSerializerConfigSnapshotsImmutable();
            outputView.writeUTF(snapshot.getName());
            outputView.writeInt(snapshot.getBackendStateType().ordinal());
            outputView.writeInt(optionsMap.size());
            for (Map.Entry<String, String> entry : optionsMap.entrySet()) {
                outputView.writeUTF(entry.getKey());
                outputView.writeUTF(entry.getValue());
            }
            outputView.writeInt(serializerConfigSnapshotsMap.size());
            for (Map.Entry<String, String> entry : serializerConfigSnapshotsMap.entrySet()) {
                String key = entry.getKey();
                outputView.writeUTF(entry.getKey());
                TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot((DataOutputView)outputView, (TypeSerializerSnapshot)((TypeSerializerSnapshot)entry.getValue()), snapshot.getTypeSerializer(key));
            }
        }
    }

    public static enum StateTypeHint {
        KEYED_STATE,
        OPERATOR_STATE;

    }
}

