/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.Random;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.junit.Assert;
import org.junit.Test;

public class CheckpointOptionsTest {
    @Test
    public void testDefaultCheckpoint() throws Exception {
        CheckpointOptions options = CheckpointOptions.forCheckpointWithDefaultLocation();
        Assert.assertEquals((Object)CheckpointType.CHECKPOINT, (Object)options.getCheckpointType());
        Assert.assertTrue((boolean)options.getTargetLocation().isDefaultReference());
        CheckpointOptions copy = (CheckpointOptions)CommonTestUtils.createCopySerializable((Serializable)options);
        Assert.assertEquals((Object)CheckpointType.CHECKPOINT, (Object)copy.getCheckpointType());
        Assert.assertTrue((boolean)copy.getTargetLocation().isDefaultReference());
    }

    @Test
    public void testSavepoint() throws Exception {
        Random rnd = new Random();
        byte[] locationBytes = new byte[rnd.nextInt(41) + 1];
        rnd.nextBytes(locationBytes);
        CheckpointOptions options = new CheckpointOptions(CheckpointType.values()[rnd.nextInt(CheckpointType.values().length)], new CheckpointStorageLocationReference(locationBytes));
        CheckpointOptions copy = (CheckpointOptions)CommonTestUtils.createCopySerializable((Serializable)options);
        Assert.assertEquals((Object)options.getCheckpointType(), (Object)copy.getCheckpointType());
        Assert.assertArrayEquals((byte[])locationBytes, (byte[])copy.getTargetLocation().getReferenceBytes());
    }
}

