/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.HashMap;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStatsSummary;
import org.apache.flink.runtime.checkpoint.MinMaxAvgStats;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class CompletedCheckpointStatsSummaryTest {
    @Test
    public void testSimpleUpdates() throws Exception {
        long triggerTimestamp = 123123L;
        long ackTimestamp = 1212435522L;
        long stateSize = 2147501434L;
        long alignmentBuffered = 2147606770L;
        CompletedCheckpointStatsSummary summary = new CompletedCheckpointStatsSummary();
        Assert.assertEquals((long)0L, (long)summary.getStateSizeStats().getCount());
        Assert.assertEquals((long)0L, (long)summary.getEndToEndDurationStats().getCount());
        Assert.assertEquals((long)0L, (long)summary.getAlignmentBufferedStats().getCount());
        int numCheckpoints = 10;
        for (int i = 0; i < numCheckpoints; ++i) {
            CompletedCheckpointStats completed = this.createCompletedCheckpoint(i, triggerTimestamp, ackTimestamp + (long)i, stateSize + (long)i, alignmentBuffered + (long)i);
            summary.updateSummary(completed);
            Assert.assertEquals((long)(i + 1), (long)summary.getStateSizeStats().getCount());
            Assert.assertEquals((long)(i + 1), (long)summary.getEndToEndDurationStats().getCount());
            Assert.assertEquals((long)(i + 1), (long)summary.getAlignmentBufferedStats().getCount());
        }
        MinMaxAvgStats stateSizeStats = summary.getStateSizeStats();
        Assert.assertEquals((long)stateSize, (long)stateSizeStats.getMinimum());
        Assert.assertEquals((long)(stateSize + (long)numCheckpoints - 1L), (long)stateSizeStats.getMaximum());
        MinMaxAvgStats durationStats = summary.getEndToEndDurationStats();
        Assert.assertEquals((long)(ackTimestamp - triggerTimestamp), (long)durationStats.getMinimum());
        Assert.assertEquals((long)(ackTimestamp - triggerTimestamp + (long)numCheckpoints - 1L), (long)durationStats.getMaximum());
        MinMaxAvgStats alignmentBufferedStats = summary.getAlignmentBufferedStats();
        Assert.assertEquals((long)alignmentBuffered, (long)alignmentBufferedStats.getMinimum());
        Assert.assertEquals((long)(alignmentBuffered + (long)numCheckpoints - 1L), (long)alignmentBufferedStats.getMaximum());
    }

    private CompletedCheckpointStats createCompletedCheckpoint(long checkpointId, long triggerTimestamp, long ackTimestamp, long stateSize, long alignmentBuffered) {
        SubtaskStateStats latest = (SubtaskStateStats)Mockito.mock(SubtaskStateStats.class);
        Mockito.when((Object)latest.getAckTimestamp()).thenReturn((Object)ackTimestamp);
        HashMap<JobVertexID, TaskStateStats> taskStats = new HashMap<JobVertexID, TaskStateStats>();
        JobVertexID jobVertexId = new JobVertexID();
        taskStats.put(jobVertexId, new TaskStateStats(jobVertexId, 1));
        return new CompletedCheckpointStats(checkpointId, triggerTimestamp, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), 1, taskStats, 1, stateSize, alignmentBuffered, latest, null);
    }
}

