/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CheckpointStatsStatus;
import org.apache.flink.runtime.checkpoint.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.FailedCheckpointStats;
import org.apache.flink.runtime.checkpoint.PendingCheckpointStats;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class PendingCheckpointStatsTest {
    @Test
    public void testReportSubtaskStats() throws Exception {
        SubtaskStateStats subtask;
        int i;
        long checkpointId = 2147484869L;
        long triggerTimestamp = 2147482408L;
        CheckpointProperties props = CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION);
        TaskStateStats task1 = new TaskStateStats(new JobVertexID(), 3);
        TaskStateStats task2 = new TaskStateStats(new JobVertexID(), 4);
        int totalSubtaskCount = task1.getNumberOfSubtasks() + task2.getNumberOfSubtasks();
        HashMap<JobVertexID, TaskStateStats> taskStats = new HashMap<JobVertexID, TaskStateStats>();
        taskStats.put(task1.getJobVertexId(), task1);
        taskStats.put(task2.getJobVertexId(), task2);
        CheckpointStatsTracker.PendingCheckpointStatsCallback callback = (CheckpointStatsTracker.PendingCheckpointStatsCallback)Mockito.mock(CheckpointStatsTracker.PendingCheckpointStatsCallback.class);
        PendingCheckpointStats pending = new PendingCheckpointStats(checkpointId, triggerTimestamp, props, totalSubtaskCount, taskStats, callback);
        Assert.assertEquals((long)checkpointId, (long)pending.getCheckpointId());
        Assert.assertEquals((long)triggerTimestamp, (long)pending.getTriggerTimestamp());
        Assert.assertEquals((Object)props, (Object)pending.getProperties());
        Assert.assertEquals((Object)CheckpointStatsStatus.IN_PROGRESS, (Object)pending.getStatus());
        Assert.assertEquals((long)0L, (long)pending.getNumberOfAcknowledgedSubtasks());
        Assert.assertEquals((long)0L, (long)pending.getStateSize());
        Assert.assertEquals((long)totalSubtaskCount, (long)pending.getNumberOfSubtasks());
        Assert.assertNull((Object)pending.getLatestAcknowledgedSubtaskStats());
        Assert.assertEquals((long)-1L, (long)pending.getLatestAckTimestamp());
        Assert.assertEquals((long)-1L, (long)pending.getEndToEndDuration());
        Assert.assertEquals((Object)task1, (Object)pending.getTaskStateStats(task1.getJobVertexId()));
        Assert.assertEquals((Object)task2, (Object)pending.getTaskStateStats(task2.getJobVertexId()));
        Assert.assertNull((Object)pending.getTaskStateStats(new JobVertexID()));
        TestCase.assertFalse((boolean)pending.reportSubtaskStats(new JobVertexID(), this.createSubtaskStats(0)));
        long stateSize = 0L;
        long alignmentBuffered = 0L;
        for (i = 0; i < task1.getNumberOfSubtasks(); ++i) {
            subtask = this.createSubtaskStats(i);
            stateSize += subtask.getStateSize();
            alignmentBuffered += subtask.getAlignmentBuffered();
            pending.reportSubtaskStats(task1.getJobVertexId(), subtask);
            Assert.assertEquals((Object)subtask, (Object)pending.getLatestAcknowledgedSubtaskStats());
            Assert.assertEquals((long)subtask.getAckTimestamp(), (long)pending.getLatestAckTimestamp());
            Assert.assertEquals((long)(subtask.getAckTimestamp() - triggerTimestamp), (long)pending.getEndToEndDuration());
            Assert.assertEquals((long)stateSize, (long)pending.getStateSize());
            Assert.assertEquals((long)alignmentBuffered, (long)pending.getAlignmentBuffered());
        }
        TestCase.assertFalse((boolean)pending.reportSubtaskStats(task1.getJobVertexId(), task1.getSubtaskStats()[0]));
        for (i = 0; i < task2.getNumberOfSubtasks(); ++i) {
            subtask = this.createSubtaskStats(i);
            stateSize += subtask.getStateSize();
            alignmentBuffered += subtask.getAlignmentBuffered();
            pending.reportSubtaskStats(task2.getJobVertexId(), subtask);
            Assert.assertEquals((Object)subtask, (Object)pending.getLatestAcknowledgedSubtaskStats());
            Assert.assertEquals((long)subtask.getAckTimestamp(), (long)pending.getLatestAckTimestamp());
            Assert.assertEquals((long)(subtask.getAckTimestamp() - triggerTimestamp), (long)pending.getEndToEndDuration());
            Assert.assertEquals((long)stateSize, (long)pending.getStateSize());
            Assert.assertEquals((long)alignmentBuffered, (long)pending.getAlignmentBuffered());
        }
        Assert.assertEquals((long)task1.getNumberOfSubtasks(), (long)task1.getNumberOfAcknowledgedSubtasks());
        Assert.assertEquals((long)task2.getNumberOfSubtasks(), (long)task2.getNumberOfAcknowledgedSubtasks());
    }

    @Test
    public void testReportCompletedCheckpoint() throws Exception {
        int i;
        TaskStateStats task1 = new TaskStateStats(new JobVertexID(), 3);
        TaskStateStats task2 = new TaskStateStats(new JobVertexID(), 4);
        HashMap<JobVertexID, TaskStateStats> taskStats = new HashMap<JobVertexID, TaskStateStats>();
        taskStats.put(task1.getJobVertexId(), task1);
        taskStats.put(task2.getJobVertexId(), task2);
        CheckpointStatsTracker.PendingCheckpointStatsCallback callback = (CheckpointStatsTracker.PendingCheckpointStatsCallback)Mockito.mock(CheckpointStatsTracker.PendingCheckpointStatsCallback.class);
        PendingCheckpointStats pending = new PendingCheckpointStats(0L, 1L, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), task1.getNumberOfSubtasks() + task2.getNumberOfSubtasks(), taskStats, callback);
        for (i = 0; i < task1.getNumberOfSubtasks(); ++i) {
            pending.reportSubtaskStats(task1.getJobVertexId(), this.createSubtaskStats(i));
        }
        for (i = 0; i < task2.getNumberOfSubtasks(); ++i) {
            pending.reportSubtaskStats(task2.getJobVertexId(), this.createSubtaskStats(i));
        }
        String externalPath = "asdjkasdjkasd";
        CompletedCheckpointStats.DiscardCallback discardCallback = pending.reportCompletedCheckpoint(externalPath);
        ArgumentCaptor args = ArgumentCaptor.forClass(CompletedCheckpointStats.class);
        ((CheckpointStatsTracker.PendingCheckpointStatsCallback)Mockito.verify((Object)callback)).reportCompletedCheckpoint((CompletedCheckpointStats)args.capture());
        CompletedCheckpointStats completed = (CompletedCheckpointStats)args.getValue();
        Assert.assertNotNull((Object)completed);
        Assert.assertEquals((Object)CheckpointStatsStatus.COMPLETED, (Object)completed.getStatus());
        TestCase.assertFalse((boolean)completed.isDiscarded());
        discardCallback.notifyDiscardedCheckpoint();
        Assert.assertTrue((boolean)completed.isDiscarded());
        Assert.assertEquals((Object)externalPath, (Object)completed.getExternalPath());
        Assert.assertEquals((long)pending.getCheckpointId(), (long)completed.getCheckpointId());
        Assert.assertEquals((long)pending.getNumberOfAcknowledgedSubtasks(), (long)completed.getNumberOfAcknowledgedSubtasks());
        Assert.assertEquals((Object)pending.getLatestAcknowledgedSubtaskStats(), (Object)completed.getLatestAcknowledgedSubtaskStats());
        Assert.assertEquals((long)pending.getLatestAckTimestamp(), (long)completed.getLatestAckTimestamp());
        Assert.assertEquals((long)pending.getEndToEndDuration(), (long)completed.getEndToEndDuration());
        Assert.assertEquals((long)pending.getStateSize(), (long)completed.getStateSize());
        Assert.assertEquals((long)pending.getAlignmentBuffered(), (long)completed.getAlignmentBuffered());
        Assert.assertEquals((Object)task1, (Object)completed.getTaskStateStats(task1.getJobVertexId()));
        Assert.assertEquals((Object)task2, (Object)completed.getTaskStateStats(task2.getJobVertexId()));
    }

    @Test
    public void testReportFailedCheckpoint() throws Exception {
        int i;
        TaskStateStats task1 = new TaskStateStats(new JobVertexID(), 3);
        TaskStateStats task2 = new TaskStateStats(new JobVertexID(), 4);
        HashMap<JobVertexID, TaskStateStats> taskStats = new HashMap<JobVertexID, TaskStateStats>();
        taskStats.put(task1.getJobVertexId(), task1);
        taskStats.put(task2.getJobVertexId(), task2);
        CheckpointStatsTracker.PendingCheckpointStatsCallback callback = (CheckpointStatsTracker.PendingCheckpointStatsCallback)Mockito.mock(CheckpointStatsTracker.PendingCheckpointStatsCallback.class);
        long triggerTimestamp = 123123L;
        PendingCheckpointStats pending = new PendingCheckpointStats(0L, triggerTimestamp, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), task1.getNumberOfSubtasks() + task2.getNumberOfSubtasks(), taskStats, callback);
        for (i = 0; i < task1.getNumberOfSubtasks(); ++i) {
            pending.reportSubtaskStats(task1.getJobVertexId(), this.createSubtaskStats(i));
        }
        for (i = 0; i < task2.getNumberOfSubtasks(); ++i) {
            pending.reportSubtaskStats(task2.getJobVertexId(), this.createSubtaskStats(i));
        }
        Exception cause = new Exception("test exception");
        long failureTimestamp = 112211137L;
        pending.reportFailedCheckpoint(failureTimestamp, (Throwable)cause);
        ArgumentCaptor args = ArgumentCaptor.forClass(FailedCheckpointStats.class);
        ((CheckpointStatsTracker.PendingCheckpointStatsCallback)Mockito.verify((Object)callback)).reportFailedCheckpoint((FailedCheckpointStats)args.capture());
        FailedCheckpointStats failed = (FailedCheckpointStats)args.getValue();
        Assert.assertNotNull((Object)failed);
        Assert.assertEquals((Object)CheckpointStatsStatus.FAILED, (Object)failed.getStatus());
        Assert.assertEquals((long)failureTimestamp, (long)failed.getFailureTimestamp());
        Assert.assertEquals((Object)cause.getMessage(), (Object)failed.getFailureMessage());
        Assert.assertEquals((long)pending.getCheckpointId(), (long)failed.getCheckpointId());
        Assert.assertEquals((long)pending.getNumberOfAcknowledgedSubtasks(), (long)failed.getNumberOfAcknowledgedSubtasks());
        Assert.assertEquals((Object)pending.getLatestAcknowledgedSubtaskStats(), (Object)failed.getLatestAcknowledgedSubtaskStats());
        Assert.assertEquals((long)pending.getLatestAckTimestamp(), (long)failed.getLatestAckTimestamp());
        Assert.assertEquals((long)(failureTimestamp - triggerTimestamp), (long)failed.getEndToEndDuration());
        Assert.assertEquals((long)pending.getStateSize(), (long)failed.getStateSize());
        Assert.assertEquals((long)pending.getAlignmentBuffered(), (long)failed.getAlignmentBuffered());
        Assert.assertEquals((Object)task1, (Object)failed.getTaskStateStats(task1.getJobVertexId()));
        Assert.assertEquals((Object)task2, (Object)failed.getTaskStateStats(task2.getJobVertexId()));
    }

    @Test
    public void testIsJavaSerializable() throws Exception {
        TaskStateStats task1 = new TaskStateStats(new JobVertexID(), 3);
        TaskStateStats task2 = new TaskStateStats(new JobVertexID(), 4);
        HashMap<JobVertexID, TaskStateStats> taskStats = new HashMap<JobVertexID, TaskStateStats>();
        taskStats.put(task1.getJobVertexId(), task1);
        taskStats.put(task2.getJobVertexId(), task2);
        PendingCheckpointStats pending = new PendingCheckpointStats(123123123L, 10123L, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), 1337, taskStats, (CheckpointStatsTracker.PendingCheckpointStatsCallback)Mockito.mock(CheckpointStatsTracker.PendingCheckpointStatsCallback.class));
        PendingCheckpointStats copy = (PendingCheckpointStats)CommonTestUtils.createCopySerializable((Serializable)pending);
        Assert.assertEquals((long)pending.getCheckpointId(), (long)copy.getCheckpointId());
        Assert.assertEquals((long)pending.getTriggerTimestamp(), (long)copy.getTriggerTimestamp());
        Assert.assertEquals((Object)pending.getProperties(), (Object)copy.getProperties());
        Assert.assertEquals((long)pending.getNumberOfSubtasks(), (long)copy.getNumberOfSubtasks());
        Assert.assertEquals((long)pending.getNumberOfAcknowledgedSubtasks(), (long)copy.getNumberOfAcknowledgedSubtasks());
        Assert.assertEquals((long)pending.getEndToEndDuration(), (long)copy.getEndToEndDuration());
        Assert.assertEquals((long)pending.getStateSize(), (long)copy.getStateSize());
        Assert.assertEquals((Object)pending.getLatestAcknowledgedSubtaskStats(), (Object)copy.getLatestAcknowledgedSubtaskStats());
        Assert.assertEquals((Object)pending.getStatus(), (Object)copy.getStatus());
    }

    private SubtaskStateStats createSubtaskStats(int index) {
        return new SubtaskStateStats(index, Integer.MAX_VALUE + (long)index, Integer.MAX_VALUE + (long)index, Integer.MAX_VALUE + (long)index, Integer.MAX_VALUE + (long)index, Integer.MAX_VALUE + (long)index, Integer.MAX_VALUE + (long)index);
    }
}

