/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.PrioritizedOperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StateHandleDummyUtil;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.OperatorStreamStateHandle;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class PrioritizedOperatorSubtaskStateTest
extends TestLogger {
    private final Random random = new Random(66L);

    @Test
    public void testPrioritization() {
        for (int i = 0; i < 81; ++i) {
            OperatorSubtaskState primaryAndFallback = this.generateForConfiguration(i);
            for (int j = 0; j < 9; ++j) {
                int modeFirst = j % 3;
                OperatorSubtaskState bestAlternative = this.createAlternativeSubtaskState(primaryAndFallback, modeFirst);
                int modeSecond = j / 3 % 3;
                OperatorSubtaskState secondBestAlternative = this.createAlternativeSubtaskState(primaryAndFallback, modeSecond);
                List<OperatorSubtaskState> orderedAlternativesList = Arrays.asList(bestAlternative, secondBestAlternative);
                ArrayList<OperatorSubtaskState> validAlternativesList = new ArrayList<OperatorSubtaskState>(3);
                if (modeFirst == 0) {
                    validAlternativesList.add(bestAlternative);
                }
                if (modeSecond == 0) {
                    validAlternativesList.add(secondBestAlternative);
                }
                validAlternativesList.add(primaryAndFallback);
                PrioritizedOperatorSubtaskState.Builder builder = new PrioritizedOperatorSubtaskState.Builder(primaryAndFallback, orderedAlternativesList);
                PrioritizedOperatorSubtaskState prioritizedOperatorSubtaskState = builder.build();
                OperatorSubtaskState[] validAlternatives = validAlternativesList.toArray(new OperatorSubtaskState[validAlternativesList.size()]);
                OperatorSubtaskState[] onlyPrimary = new OperatorSubtaskState[]{primaryAndFallback};
                Assert.assertTrue((boolean)this.checkResultAsExpected(OperatorSubtaskState::getManagedOperatorState, PrioritizedOperatorSubtaskState::getPrioritizedManagedOperatorState, prioritizedOperatorSubtaskState, primaryAndFallback.getManagedOperatorState().size() == 1 ? validAlternatives : onlyPrimary));
                Assert.assertTrue((boolean)this.checkResultAsExpected(OperatorSubtaskState::getManagedKeyedState, PrioritizedOperatorSubtaskState::getPrioritizedManagedKeyedState, prioritizedOperatorSubtaskState, primaryAndFallback.getManagedKeyedState().size() == 1 ? validAlternatives : onlyPrimary));
                Assert.assertTrue((boolean)this.checkResultAsExpected(OperatorSubtaskState::getRawOperatorState, PrioritizedOperatorSubtaskState::getPrioritizedRawOperatorState, prioritizedOperatorSubtaskState, primaryAndFallback.getRawOperatorState().size() == 1 ? validAlternatives : onlyPrimary));
                Assert.assertTrue((boolean)this.checkResultAsExpected(OperatorSubtaskState::getRawKeyedState, PrioritizedOperatorSubtaskState::getPrioritizedRawKeyedState, prioritizedOperatorSubtaskState, primaryAndFallback.getRawKeyedState().size() == 1 ? validAlternatives : onlyPrimary));
            }
        }
    }

    private OperatorSubtaskState generateForConfiguration(int conf) {
        Preconditions.checkState((conf >= 0 && conf <= 80 ? 1 : 0) != 0);
        int numModes = 3;
        KeyGroupRange keyGroupRange = new KeyGroupRange(0, 4);
        KeyGroupRange keyGroupRange1 = new KeyGroupRange(0, 2);
        KeyGroupRange keyGroupRange2 = new KeyGroupRange(3, 4);
        int div = 1;
        int mode = conf / div % 3;
        StateObjectCollection s1 = mode == 0 ? StateObjectCollection.empty() : (mode == 1 ? new StateObjectCollection(Collections.singletonList(StateHandleDummyUtil.createNewOperatorStateHandle(2, this.random))) : new StateObjectCollection(Arrays.asList(StateHandleDummyUtil.createNewOperatorStateHandle(2, this.random), StateHandleDummyUtil.createNewOperatorStateHandle(2, this.random))));
        mode = conf / (div *= 3) % 3;
        StateObjectCollection s2 = mode == 0 ? StateObjectCollection.empty() : (mode == 1 ? new StateObjectCollection(Collections.singletonList(StateHandleDummyUtil.createNewOperatorStateHandle(2, this.random))) : new StateObjectCollection(Arrays.asList(StateHandleDummyUtil.createNewOperatorStateHandle(2, this.random), StateHandleDummyUtil.createNewOperatorStateHandle(2, this.random))));
        mode = conf / (div *= 3) % 3;
        StateObjectCollection s3 = mode == 0 ? StateObjectCollection.empty() : (mode == 1 ? new StateObjectCollection(Collections.singletonList(StateHandleDummyUtil.createNewKeyedStateHandle(keyGroupRange))) : new StateObjectCollection(Arrays.asList(StateHandleDummyUtil.createNewKeyedStateHandle(keyGroupRange1), StateHandleDummyUtil.createNewKeyedStateHandle(keyGroupRange2))));
        mode = conf / (div *= 3) % 3;
        StateObjectCollection s4 = mode == 0 ? StateObjectCollection.empty() : (mode == 1 ? new StateObjectCollection(Collections.singletonList(StateHandleDummyUtil.createNewKeyedStateHandle(keyGroupRange))) : new StateObjectCollection(Arrays.asList(StateHandleDummyUtil.createNewKeyedStateHandle(keyGroupRange1), StateHandleDummyUtil.createNewKeyedStateHandle(keyGroupRange2))));
        return new OperatorSubtaskState(s1, s2, s3, s4);
    }

    private OperatorSubtaskState createAlternativeSubtaskState(OperatorSubtaskState primaryOriginal, int mode) {
        switch (mode) {
            case 0: {
                return new OperatorSubtaskState((OperatorStateHandle)this.deepCopyFirstElement(primaryOriginal.getManagedOperatorState()), (OperatorStateHandle)this.deepCopyFirstElement(primaryOriginal.getRawOperatorState()), (KeyedStateHandle)this.deepCopyFirstElement(primaryOriginal.getManagedKeyedState()), (KeyedStateHandle)this.deepCopyFirstElement(primaryOriginal.getRawKeyedState()));
            }
            case 1: {
                return new OperatorSubtaskState();
            }
            case 2: {
                KeyGroupRange otherRange = new KeyGroupRange(8, 16);
                int numNamedStates = 2;
                return new OperatorSubtaskState(StateHandleDummyUtil.createNewOperatorStateHandle(numNamedStates, this.random), StateHandleDummyUtil.createNewOperatorStateHandle(numNamedStates, this.random), StateHandleDummyUtil.createNewKeyedStateHandle(otherRange), StateHandleDummyUtil.createNewKeyedStateHandle(otherRange));
            }
        }
        throw new IllegalArgumentException("Mode: " + mode);
    }

    private <T extends StateObject> boolean checkResultAsExpected(Function<OperatorSubtaskState, StateObjectCollection<T>> extractor, Function<PrioritizedOperatorSubtaskState, List<StateObjectCollection<T>>> extractor2, PrioritizedOperatorSubtaskState prioritizedResult, OperatorSubtaskState ... expectedOrdered) {
        ArrayList<StateObjectCollection<T>> collector = new ArrayList<StateObjectCollection<T>>(expectedOrdered.length);
        for (OperatorSubtaskState operatorSubtaskState : expectedOrdered) {
            collector.add(extractor.apply(operatorSubtaskState));
        }
        return this.checkRepresentSameOrder(extractor2.apply(prioritizedResult).iterator(), collector.toArray(new StateObjectCollection[collector.size()]));
    }

    private boolean checkRepresentSameOrder(Iterator<? extends StateObjectCollection<?>> ordered, StateObjectCollection<?> ... expectedOrder) {
        for (StateObjectCollection<?> objects : expectedOrder) {
            if (ordered.hasNext() && this.checkContainedObjectsReferentialEquality(objects, ordered.next())) continue;
            return false;
        }
        return !ordered.hasNext();
    }

    public boolean checkContainedObjectsReferentialEquality(StateObjectCollection<?> a, StateObjectCollection<?> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        Iterator bIter = b.iterator();
        for (StateObject stateObject : a) {
            if (bIter.hasNext() && bIter.next() == stateObject) continue;
            return false;
        }
        return true;
    }

    private <T extends StateObject> T deepCopyFirstElement(StateObjectCollection<T> original) {
        OperatorStateHandle result;
        if (original.isEmpty()) {
            return null;
        }
        StateObject stateObject = (StateObject)original.iterator().next();
        if (stateObject instanceof OperatorStreamStateHandle) {
            result = StateHandleDummyUtil.deepDummyCopy((OperatorStateHandle)stateObject);
        } else if (stateObject instanceof KeyedStateHandle) {
            result = StateHandleDummyUtil.deepDummyCopy((KeyedStateHandle)stateObject);
        } else {
            throw new IllegalStateException();
        }
        return (T)result;
    }
}

