/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.OperatorStreamStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;

public class StateHandleDummyUtil {
    public static OperatorStateHandle createNewOperatorStateHandle(int numNamedStates, Random random) {
        HashMap<String, OperatorStateHandle.StateMetaInfo> operatorStateMetaData = new HashMap<String, OperatorStateHandle.StateMetaInfo>(numNamedStates);
        byte[] streamData = new byte[numNamedStates * 4];
        random.nextBytes(streamData);
        long off = 0L;
        for (int i = 0; i < numNamedStates; ++i) {
            long[] offsets = new long[4];
            for (int o = 0; o < offsets.length; ++o) {
                ++off;
            }
            OperatorStateHandle.StateMetaInfo metaInfo = new OperatorStateHandle.StateMetaInfo(offsets, OperatorStateHandle.Mode.SPLIT_DISTRIBUTE);
            operatorStateMetaData.put(String.valueOf(UUID.randomUUID()), metaInfo);
        }
        ByteStreamStateHandle byteStreamStateHandle = new ByteStreamStateHandle(String.valueOf(UUID.randomUUID()), streamData);
        return new OperatorStreamStateHandle(operatorStateMetaData, (StreamStateHandle)byteStreamStateHandle);
    }

    public static KeyedStateHandle createNewKeyedStateHandle(KeyGroupRange keyGroupRange) {
        return new DummyKeyedStateHandle(keyGroupRange);
    }

    public static OperatorStateHandle deepDummyCopy(OperatorStateHandle original) {
        if (original == null) {
            return null;
        }
        ByteStreamStateHandle stateHandle = (ByteStreamStateHandle)original.getDelegateStateHandle();
        ByteStreamStateHandle stateHandleCopy = new ByteStreamStateHandle(String.valueOf(stateHandle.getHandleName()), (byte[])stateHandle.getData().clone());
        Map offsets = original.getStateNameToPartitionOffsets();
        HashMap<String, OperatorStateHandle.StateMetaInfo> offsetsCopy = new HashMap<String, OperatorStateHandle.StateMetaInfo>(offsets.size());
        for (Map.Entry entry : offsets.entrySet()) {
            OperatorStateHandle.StateMetaInfo metaInfo = (OperatorStateHandle.StateMetaInfo)entry.getValue();
            OperatorStateHandle.StateMetaInfo metaInfoCopy = new OperatorStateHandle.StateMetaInfo(metaInfo.getOffsets(), metaInfo.getDistributionMode());
            offsetsCopy.put(String.valueOf(entry.getKey()), metaInfoCopy);
        }
        return new OperatorStreamStateHandle(offsetsCopy, (StreamStateHandle)stateHandleCopy);
    }

    public static KeyedStateHandle deepDummyCopy(KeyedStateHandle original) {
        if (original == null) {
            return null;
        }
        KeyGroupRange keyGroupRange = original.getKeyGroupRange();
        return new DummyKeyedStateHandle(new KeyGroupRange(keyGroupRange.getStartKeyGroup(), keyGroupRange.getEndKeyGroup()));
    }

    private static class DummyKeyedStateHandle
    implements KeyedStateHandle {
        private static final long serialVersionUID = 1L;
        private final KeyGroupRange keyGroupRange;

        private DummyKeyedStateHandle(KeyGroupRange keyGroupRange) {
            this.keyGroupRange = keyGroupRange;
        }

        public KeyGroupRange getKeyGroupRange() {
            return this.keyGroupRange;
        }

        public KeyedStateHandle getIntersection(KeyGroupRange keyGroupRange) {
            return new DummyKeyedStateHandle(this.keyGroupRange.getIntersection(keyGroupRange));
        }

        public void registerSharedStates(SharedStateRegistry stateRegistry) {
        }

        public void discardState() throws Exception {
        }

        public long getStateSize() {
            return 0L;
        }
    }
}

