/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.savepoint;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.flink.core.memory.ByteArrayInputStreamWithPos;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.checkpoint.MasterState;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.savepoint.CheckpointTestUtils;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointV2;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointV2Serializer;
import org.junit.Assert;
import org.junit.Test;

public class SavepointV2SerializerTest {
    @Test
    public void testCheckpointWithNoState() throws Exception {
        Random rnd = new Random();
        for (int i = 0; i < 100; ++i) {
            long checkpointId = rnd.nextLong() & Long.MAX_VALUE;
            List<OperatorState> taskStates = Collections.emptyList();
            List<MasterState> masterStates = Collections.emptyList();
            this.testCheckpointSerialization(checkpointId, taskStates, masterStates);
        }
    }

    @Test
    public void testCheckpointWithOnlyMasterState() throws Exception {
        Random rnd = new Random();
        int maxNumMasterStates = 5;
        for (int i = 0; i < 100; ++i) {
            long checkpointId = rnd.nextLong() & Long.MAX_VALUE;
            List<OperatorState> operatorStates = Collections.emptyList();
            int numMasterStates = rnd.nextInt(5) + 1;
            Collection<MasterState> masterStates = CheckpointTestUtils.createRandomMasterStates(rnd, numMasterStates);
            this.testCheckpointSerialization(checkpointId, operatorStates, masterStates);
        }
    }

    @Test
    public void testCheckpointWithOnlyTaskState() throws Exception {
        Random rnd = new Random();
        int maxTaskStates = 20;
        int maxNumSubtasks = 20;
        for (int i = 0; i < 100; ++i) {
            long checkpointId = rnd.nextLong() & Long.MAX_VALUE;
            int numTasks = rnd.nextInt(20) + 1;
            int numSubtasks = rnd.nextInt(20) + 1;
            Collection<OperatorState> taskStates = CheckpointTestUtils.createOperatorStates(rnd, numTasks, numSubtasks);
            List<MasterState> masterStates = Collections.emptyList();
            this.testCheckpointSerialization(checkpointId, taskStates, masterStates);
        }
    }

    @Test
    public void testCheckpointWithMasterAndTaskState() throws Exception {
        Random rnd = new Random();
        int maxNumMasterStates = 5;
        int maxTaskStates = 20;
        int maxNumSubtasks = 20;
        for (int i = 0; i < 100; ++i) {
            long checkpointId = rnd.nextLong() & Long.MAX_VALUE;
            int numTasks = rnd.nextInt(20) + 1;
            int numSubtasks = rnd.nextInt(20) + 1;
            Collection<OperatorState> taskStates = CheckpointTestUtils.createOperatorStates(rnd, numTasks, numSubtasks);
            int numMasterStates = rnd.nextInt(5) + 1;
            Collection<MasterState> masterStates = CheckpointTestUtils.createRandomMasterStates(rnd, numMasterStates);
            this.testCheckpointSerialization(checkpointId, taskStates, masterStates);
        }
    }

    private void testCheckpointSerialization(long checkpointId, Collection<OperatorState> operatorStates, Collection<MasterState> masterStates) throws IOException {
        SavepointV2Serializer serializer = SavepointV2Serializer.INSTANCE;
        ByteArrayOutputStreamWithPos baos = new ByteArrayOutputStreamWithPos();
        DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper((OutputStream)baos);
        serializer.serialize(new SavepointV2(checkpointId, operatorStates, masterStates), (DataOutputStream)out);
        out.close();
        byte[] bytes = baos.toByteArray();
        DataInputViewStreamWrapper in = new DataInputViewStreamWrapper((InputStream)new ByteArrayInputStreamWithPos(bytes));
        SavepointV2 deserialized = serializer.deserialize((DataInputStream)in, this.getClass().getClassLoader());
        Assert.assertEquals((long)checkpointId, (long)deserialized.getCheckpointId());
        Assert.assertEquals(operatorStates, (Object)deserialized.getOperatorStates());
        Assert.assertEquals((long)masterStates.size(), (long)deserialized.getMasterStates().size());
        Iterator<MasterState> a = masterStates.iterator();
        Iterator b = deserialized.getMasterStates().iterator();
        while (a.hasNext()) {
            CheckpointTestUtils.assertMasterStateEquality(a.next(), (MasterState)b.next());
        }
    }
}

