/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.classloading;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.flink.runtime.execution.librarycache.FlinkUserCodeClassLoaders;
import org.apache.flink.runtime.rpc.messages.RemoteRpcInvocation;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class ClassLoaderTest
extends TestLogger {
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testMessageDecodingWithUnavailableClass() throws Exception {
        ClassLoader systemClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        String className = "UserClass";
        URLClassLoader userClassLoader = ClassLoaderUtils.compileAndLoadJava((File)temporaryFolder.newFolder(), (String)"UserClass.java", (String)"import java.io.Serializable;\npublic class UserClass implements Serializable {}");
        RemoteRpcInvocation method = new RemoteRpcInvocation("test", new Class[]{Integer.TYPE, Class.forName("UserClass", false, userClassLoader)}, new Object[]{1, Class.forName("UserClass", false, userClassLoader).newInstance()});
        SerializedValue serializedMethod = new SerializedValue((Object)method);
        this.expectedException.expect(ClassNotFoundException.class);
        this.expectedException.expect(CoreMatchers.allOf((Matcher)CoreMatchers.isA(ClassNotFoundException.class), (Matcher)Matchers.hasProperty((String)"suppressed", (Matcher)Matchers.hasItemInArray((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.isA(ClassNotFoundException.class), (Matcher)Matchers.hasProperty((String)"message", (Matcher)CoreMatchers.containsString((String)"Could not deserialize 1th parameter type of method test(int, ...).")))))));
        RemoteRpcInvocation deserializedMethod = (RemoteRpcInvocation)serializedMethod.deserializeValue(systemClassLoader);
        deserializedMethod.getMethodName();
        userClassLoader.close();
    }

    @Test
    public void testParentFirstClassLoading() throws Exception {
        ClassLoader parentClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        URL childCodePath = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation();
        URLClassLoader childClassLoader1 = FlinkUserCodeClassLoaders.parentFirst((URL[])new URL[]{childCodePath}, (ClassLoader)parentClassLoader);
        URLClassLoader childClassLoader2 = FlinkUserCodeClassLoaders.parentFirst((URL[])new URL[]{childCodePath}, (ClassLoader)parentClassLoader);
        String className = ClassLoaderTest.class.getName();
        Class<?> clazz1 = Class.forName(className, false, parentClassLoader);
        Class<?> clazz2 = Class.forName(className, false, childClassLoader1);
        Class<?> clazz3 = Class.forName(className, false, childClassLoader2);
        Assert.assertEquals(clazz1, clazz2);
        Assert.assertEquals(clazz1, clazz3);
        childClassLoader1.close();
        childClassLoader2.close();
    }

    @Test
    public void testChildFirstClassLoading() throws Exception {
        ClassLoader parentClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        URL childCodePath = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation();
        URLClassLoader childClassLoader1 = FlinkUserCodeClassLoaders.childFirst((URL[])new URL[]{childCodePath}, (ClassLoader)parentClassLoader, (String[])new String[0]);
        URLClassLoader childClassLoader2 = FlinkUserCodeClassLoaders.childFirst((URL[])new URL[]{childCodePath}, (ClassLoader)parentClassLoader, (String[])new String[0]);
        String className = ClassLoaderTest.class.getName();
        Class<?> clazz1 = Class.forName(className, false, parentClassLoader);
        Class<?> clazz2 = Class.forName(className, false, childClassLoader1);
        Class<?> clazz3 = Class.forName(className, false, childClassLoader2);
        Assert.assertNotEquals(clazz1, clazz2);
        Assert.assertNotEquals(clazz1, clazz3);
        Assert.assertNotEquals(clazz2, clazz3);
        childClassLoader1.close();
        childClassLoader2.close();
    }

    @Test
    public void testRepeatedChildFirstClassLoading() throws Exception {
        ClassLoader parentClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        URL childCodePath = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation();
        URLClassLoader childClassLoader = FlinkUserCodeClassLoaders.childFirst((URL[])new URL[]{childCodePath}, (ClassLoader)parentClassLoader, (String[])new String[0]);
        String className = ClassLoaderTest.class.getName();
        Class<?> clazz1 = Class.forName(className, false, parentClassLoader);
        Class<?> clazz2 = Class.forName(className, false, childClassLoader);
        Class<?> clazz3 = Class.forName(className, false, childClassLoader);
        Class<?> clazz4 = Class.forName(className, false, childClassLoader);
        Assert.assertNotEquals(clazz1, clazz2);
        Assert.assertEquals(clazz2, clazz3);
        Assert.assertEquals(clazz2, clazz4);
        childClassLoader.close();
    }

    @Test
    public void testRepeatedParentFirstPatternClass() throws Exception {
        String className = ClassLoaderTest.class.getName();
        String parentFirstPattern = className.substring(0, className.lastIndexOf(46));
        ClassLoader parentClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        URL childCodePath = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation();
        URLClassLoader childClassLoader = FlinkUserCodeClassLoaders.childFirst((URL[])new URL[]{childCodePath}, (ClassLoader)parentClassLoader, (String[])new String[]{parentFirstPattern});
        Class<?> clazz1 = Class.forName(className, false, parentClassLoader);
        Class<?> clazz2 = Class.forName(className, false, childClassLoader);
        Class<?> clazz3 = Class.forName(className, false, childClassLoader);
        Class<?> clazz4 = Class.forName(className, false, childClassLoader);
        Assert.assertEquals(clazz1, clazz2);
        Assert.assertEquals(clazz1, clazz3);
        Assert.assertEquals(clazz1, clazz4);
        childClassLoader.close();
    }
}

