/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.BootstrapTools;
import org.apache.flink.runtime.clusterframework.ContaineredTaskManagerParameters;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.function.CheckedSupplier;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapToolsTest
extends TestLogger {
    private static final Logger LOG = LoggerFactory.getLogger(BootstrapToolsTest.class);

    @Test
    public void testSubstituteConfigKey() {
        String deprecatedKey1 = "deprecated-key";
        String deprecatedKey2 = "another-out_of-date_key";
        String deprecatedKey3 = "yet-one-more";
        String designatedKey1 = "newkey1";
        String designatedKey2 = "newKey2";
        String designatedKey3 = "newKey3";
        String value1 = "value1";
        String value2Designated = "designated-value2";
        String value2Deprecated = "deprecated-value2";
        Configuration cfg = new Configuration();
        cfg.setString(deprecatedKey1, value1);
        cfg.setString(deprecatedKey2, value2Deprecated);
        cfg.setString(designatedKey2, value2Designated);
        BootstrapTools.substituteDeprecatedConfigKey((Configuration)cfg, (String)deprecatedKey1, (String)designatedKey1);
        BootstrapTools.substituteDeprecatedConfigKey((Configuration)cfg, (String)deprecatedKey2, (String)designatedKey2);
        BootstrapTools.substituteDeprecatedConfigKey((Configuration)cfg, (String)deprecatedKey3, (String)designatedKey3);
        Assert.assertEquals((Object)value1, (Object)cfg.getString(designatedKey1, null));
        Assert.assertEquals((Object)value2Designated, (Object)cfg.getString(designatedKey2, null));
        Assert.assertNull((Object)cfg.getString(designatedKey3, null));
        Assert.assertNull((Object)cfg.getString(deprecatedKey3, null));
    }

    @Test
    public void testSubstituteConfigKeyPrefix() {
        String deprecatedPrefix1 = "deprecated-prefix";
        String deprecatedPrefix2 = "-prefix-2";
        String deprecatedPrefix3 = "prefix-3";
        String designatedPrefix1 = "p1";
        String designatedPrefix2 = "ppp";
        String designatedPrefix3 = "zzz";
        String depr1 = deprecatedPrefix1 + "var";
        String depr2 = deprecatedPrefix2 + "env";
        String depr3 = deprecatedPrefix2 + "x";
        String desig1 = designatedPrefix1 + "var";
        String desig2 = designatedPrefix2 + "env";
        String desig3 = designatedPrefix2 + "x";
        String val1 = "1";
        String val2 = "2";
        String val3Depr = "3-";
        String val3Desig = "3+";
        Configuration cfg = new Configuration();
        cfg.setString(depr1, val1);
        cfg.setString(depr2, val2);
        cfg.setString(depr3, val3Depr);
        cfg.setString(desig3, val3Desig);
        BootstrapTools.substituteDeprecatedConfigPrefix((Configuration)cfg, (String)deprecatedPrefix1, (String)designatedPrefix1);
        BootstrapTools.substituteDeprecatedConfigPrefix((Configuration)cfg, (String)deprecatedPrefix2, (String)designatedPrefix2);
        BootstrapTools.substituteDeprecatedConfigPrefix((Configuration)cfg, (String)deprecatedPrefix3, (String)designatedPrefix3);
        Assert.assertEquals((Object)val1, (Object)cfg.getString(desig1, null));
        Assert.assertEquals((Object)val2, (Object)cfg.getString(desig2, null));
        Assert.assertEquals((Object)val3Desig, (Object)cfg.getString(desig3, null));
        for (String key : cfg.keySet()) {
            Assert.assertFalse((boolean)key.startsWith(designatedPrefix3));
            Assert.assertFalse((boolean)key.startsWith(deprecatedPrefix3));
        }
    }

    @Test
    public void testGetTaskManagerShellCommand() {
        Configuration cfg = new Configuration();
        ContaineredTaskManagerParameters containeredParams = new ContaineredTaskManagerParameters(1024L, 768L, 256L, 4, new HashMap());
        String java = "$JAVA_HOME/bin/java";
        String jvmmem = "-Xms768m -Xmx768m -XX:MaxDirectMemorySize=256m";
        String jvmOpts = "-Djvm";
        String tmJvmOpts = "-DtmJvm";
        String logfile = "-Dlog.file=./logs/taskmanager.log";
        String logback = "-Dlogback.configurationFile=file:./conf/logback.xml";
        String log4j = "-Dlog4j.configuration=file:./conf/log4j.properties";
        String mainClass = "org.apache.flink.runtime.clusterframework.BootstrapToolsTest";
        String args = "--configDir ./conf";
        String redirects = "1> ./logs/taskmanager.out 2> ./logs/taskmanager.err";
        Assert.assertEquals((Object)"$JAVA_HOME/bin/java -Xms768m -Xmx768m -XX:MaxDirectMemorySize=256m   org.apache.flink.runtime.clusterframework.BootstrapToolsTest --configDir ./conf 1> ./logs/taskmanager.out 2> ./logs/taskmanager.err", (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)false, (boolean)false, (boolean)false, ((Object)((Object)this)).getClass()));
        String krb5 = "-Djava.security.krb5.conf=krb5.conf";
        Assert.assertEquals((Object)"$JAVA_HOME/bin/java -Xms768m -Xmx768m -XX:MaxDirectMemorySize=256m  -Djava.security.krb5.conf=krb5.conf  org.apache.flink.runtime.clusterframework.BootstrapToolsTest --configDir ./conf 1> ./logs/taskmanager.out 2> ./logs/taskmanager.err", (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)false, (boolean)false, (boolean)true, ((Object)((Object)this)).getClass()));
        Assert.assertEquals((Object)"$JAVA_HOME/bin/java -Xms768m -Xmx768m -XX:MaxDirectMemorySize=256m  -Dlog.file=./logs/taskmanager.log -Dlogback.configurationFile=file:./conf/logback.xml org.apache.flink.runtime.clusterframework.BootstrapToolsTest --configDir ./conf 1> ./logs/taskmanager.out 2> ./logs/taskmanager.err", (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)true, (boolean)false, (boolean)false, ((Object)((Object)this)).getClass()));
        Assert.assertEquals((Object)"$JAVA_HOME/bin/java -Xms768m -Xmx768m -XX:MaxDirectMemorySize=256m  -Djava.security.krb5.conf=krb5.conf -Dlog.file=./logs/taskmanager.log -Dlogback.configurationFile=file:./conf/logback.xml org.apache.flink.runtime.clusterframework.BootstrapToolsTest --configDir ./conf 1> ./logs/taskmanager.out 2> ./logs/taskmanager.err", (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)true, (boolean)false, (boolean)true, ((Object)((Object)this)).getClass()));
        Assert.assertEquals((Object)"$JAVA_HOME/bin/java -Xms768m -Xmx768m -XX:MaxDirectMemorySize=256m  -Dlog.file=./logs/taskmanager.log -Dlog4j.configuration=file:./conf/log4j.properties org.apache.flink.runtime.clusterframework.BootstrapToolsTest --configDir ./conf 1> ./logs/taskmanager.out 2> ./logs/taskmanager.err", (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)false, (boolean)true, (boolean)false, ((Object)((Object)this)).getClass()));
        Assert.assertEquals((Object)"$JAVA_HOME/bin/java -Xms768m -Xmx768m -XX:MaxDirectMemorySize=256m  -Djava.security.krb5.conf=krb5.conf -Dlog.file=./logs/taskmanager.log -Dlog4j.configuration=file:./conf/log4j.properties org.apache.flink.runtime.clusterframework.BootstrapToolsTest --configDir ./conf 1> ./logs/taskmanager.out 2> ./logs/taskmanager.err", (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)false, (boolean)true, (boolean)true, ((Object)((Object)this)).getClass()));
        Assert.assertEquals((Object)"$JAVA_HOME/bin/java -Xms768m -Xmx768m -XX:MaxDirectMemorySize=256m  -Dlog.file=./logs/taskmanager.log -Dlogback.configurationFile=file:./conf/logback.xml -Dlog4j.configuration=file:./conf/log4j.properties org.apache.flink.runtime.clusterframework.BootstrapToolsTest --configDir ./conf 1> ./logs/taskmanager.out 2> ./logs/taskmanager.err", (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)true, (boolean)true, (boolean)false, ((Object)((Object)this)).getClass()));
        Assert.assertEquals((Object)"$JAVA_HOME/bin/java -Xms768m -Xmx768m -XX:MaxDirectMemorySize=256m  -Djava.security.krb5.conf=krb5.conf -Dlog.file=./logs/taskmanager.log -Dlogback.configurationFile=file:./conf/logback.xml -Dlog4j.configuration=file:./conf/log4j.properties org.apache.flink.runtime.clusterframework.BootstrapToolsTest --configDir ./conf 1> ./logs/taskmanager.out 2> ./logs/taskmanager.err", (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)true, (boolean)true, (boolean)true, ((Object)((Object)this)).getClass()));
        cfg.setString(CoreOptions.FLINK_JVM_OPTIONS, "-Djvm");
        Assert.assertEquals((Object)"$JAVA_HOME/bin/java -Xms768m -Xmx768m -XX:MaxDirectMemorySize=256m -Djvm -Dlog.file=./logs/taskmanager.log -Dlogback.configurationFile=file:./conf/logback.xml -Dlog4j.configuration=file:./conf/log4j.properties org.apache.flink.runtime.clusterframework.BootstrapToolsTest --configDir ./conf 1> ./logs/taskmanager.out 2> ./logs/taskmanager.err", (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)true, (boolean)true, (boolean)false, ((Object)((Object)this)).getClass()));
        Assert.assertEquals((Object)"$JAVA_HOME/bin/java -Xms768m -Xmx768m -XX:MaxDirectMemorySize=256m -Djvm -Djava.security.krb5.conf=krb5.conf -Dlog.file=./logs/taskmanager.log -Dlogback.configurationFile=file:./conf/logback.xml -Dlog4j.configuration=file:./conf/log4j.properties org.apache.flink.runtime.clusterframework.BootstrapToolsTest --configDir ./conf 1> ./logs/taskmanager.out 2> ./logs/taskmanager.err", (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)true, (boolean)true, (boolean)true, ((Object)((Object)this)).getClass()));
        cfg.setString(CoreOptions.FLINK_TM_JVM_OPTIONS, "-DtmJvm");
        Assert.assertEquals((Object)"$JAVA_HOME/bin/java -Xms768m -Xmx768m -XX:MaxDirectMemorySize=256m -Djvm -DtmJvm -Dlog.file=./logs/taskmanager.log -Dlogback.configurationFile=file:./conf/logback.xml -Dlog4j.configuration=file:./conf/log4j.properties org.apache.flink.runtime.clusterframework.BootstrapToolsTest --configDir ./conf 1> ./logs/taskmanager.out 2> ./logs/taskmanager.err", (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)true, (boolean)true, (boolean)false, ((Object)((Object)this)).getClass()));
        Assert.assertEquals((Object)"$JAVA_HOME/bin/java -Xms768m -Xmx768m -XX:MaxDirectMemorySize=256m -Djvm -DtmJvm -Djava.security.krb5.conf=krb5.conf -Dlog.file=./logs/taskmanager.log -Dlogback.configurationFile=file:./conf/logback.xml -Dlog4j.configuration=file:./conf/log4j.properties org.apache.flink.runtime.clusterframework.BootstrapToolsTest --configDir ./conf 1> ./logs/taskmanager.out 2> ./logs/taskmanager.err", (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)true, (boolean)true, (boolean)true, ((Object)((Object)this)).getClass()));
        cfg.setString("yarn.container-start-command-template", "%java% 1 %jvmmem% 2 %jvmopts% 3 %logging% 4 %class% 5 %args% 6 %redirects%");
        Assert.assertEquals((Object)"$JAVA_HOME/bin/java 1 -Xms768m -Xmx768m -XX:MaxDirectMemorySize=256m 2 -Djvm -DtmJvm -Djava.security.krb5.conf=krb5.conf 3 -Dlog.file=./logs/taskmanager.log -Dlogback.configurationFile=file:./conf/logback.xml -Dlog4j.configuration=file:./conf/log4j.properties 4 org.apache.flink.runtime.clusterframework.BootstrapToolsTest 5 --configDir ./conf 6 1> ./logs/taskmanager.out 2> ./logs/taskmanager.err", (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)true, (boolean)true, (boolean)true, ((Object)((Object)this)).getClass()));
        cfg.setString("yarn.container-start-command-template", "%java% %logging% %jvmopts% %jvmmem% %class% %args% %redirects%");
        Assert.assertEquals((Object)"$JAVA_HOME/bin/java -Dlog.file=./logs/taskmanager.log -Dlogback.configurationFile=file:./conf/logback.xml -Dlog4j.configuration=file:./conf/log4j.properties -Djvm -DtmJvm -Djava.security.krb5.conf=krb5.conf -Xms768m -Xmx768m -XX:MaxDirectMemorySize=256m org.apache.flink.runtime.clusterframework.BootstrapToolsTest --configDir ./conf 1> ./logs/taskmanager.out 2> ./logs/taskmanager.err", (Object)BootstrapTools.getTaskManagerShellCommand((Configuration)cfg, (ContaineredTaskManagerParameters)containeredParams, (String)"./conf", (String)"./logs", (boolean)true, (boolean)true, (boolean)true, ((Object)((Object)this)).getClass()));
    }

    @Test
    public void testUpdateTmpDirectoriesInConfiguration() {
        Configuration config = new Configuration();
        BootstrapTools.updateTmpDirectoriesInConfiguration((Configuration)config, (String)"default/directory/path");
        Assert.assertEquals((Object)config.getString(CoreOptions.TMP_DIRS), (Object)"default/directory/path");
        BootstrapTools.updateTmpDirectoriesInConfiguration((Configuration)config, (String)"not/default/directory/path");
        Assert.assertEquals((Object)config.getString(CoreOptions.TMP_DIRS), (Object)"default/directory/path");
        config.setString(CoreOptions.TMP_DIRS, "");
        BootstrapTools.updateTmpDirectoriesInConfiguration((Configuration)config, (String)"some/new/path");
        Assert.assertEquals((Object)config.getString(CoreOptions.TMP_DIRS), (Object)"");
    }

    @Test
    public void testShouldNotUpdateTmpDirectoriesInConfigurationIfNoValueConfigured() {
        Configuration config = new Configuration();
        BootstrapTools.updateTmpDirectoriesInConfiguration((Configuration)config, null);
        Assert.assertEquals((Object)config.getString(CoreOptions.TMP_DIRS), (Object)CoreOptions.TMP_DIRS.defaultValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentActorSystemCreation() throws Exception {
        int concurrentCreations = 10;
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        CyclicBarrier cyclicBarrier = new CyclicBarrier(10);
        try {
            List actorSystemFutures = IntStream.range(0, 10).mapToObj(ignored -> CompletableFuture.supplyAsync(CheckedSupplier.unchecked(() -> {
                cyclicBarrier.await();
                return BootstrapTools.startActorSystem((Configuration)new Configuration(), (String)"localhost", (String)"0", (Logger)LOG);
            }), executorService)).map(actorSystemFuture -> actorSystemFuture.thenCompose(AkkaUtils::terminateActorSystem)).collect(Collectors.toList());
            FutureUtils.completeAll(actorSystemFutures).get();
        }
        catch (Throwable throwable) {
            ExecutorUtils.gracefulShutdown((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{executorService});
            throw throwable;
        }
        ExecutorUtils.gracefulShutdown((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{executorService});
    }
}

