/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ResourceManagerOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.ContaineredTaskManagerParameters;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class ContaineredTaskManagerParametersTest
extends TestLogger {
    private static final long CONTAINER_MEMORY = 8192L;

    @Test
    public void testOffHeapMemoryWithDefaultConfiguration() {
        Configuration conf = new Configuration();
        ContaineredTaskManagerParameters params = ContaineredTaskManagerParameters.create((Configuration)conf, (long)8192L, (int)1);
        float memoryCutoffRatio = conf.getFloat("containerized.heap-cutoff-ratio", 0.25f);
        int minCutoff = conf.getInteger("containerized.heap-cutoff-min", 600);
        long cutoff = Math.max((long)(8192.0f * memoryCutoffRatio), (long)minCutoff);
        long networkBufMB = TaskManagerServices.calculateNetworkBufferMemory((long)(8192L - cutoff << 20), (Configuration)conf) >> 20;
        Assert.assertEquals((long)(networkBufMB + cutoff), (long)params.taskManagerDirectMemoryLimitMB());
    }

    @Test
    public void testTotalMemoryDoesNotExceedContainerMemoryOnHeap() {
        Configuration conf = new Configuration();
        conf.setBoolean(TaskManagerOptions.MEMORY_OFF_HEAP, false);
        ContaineredTaskManagerParameters params = ContaineredTaskManagerParameters.create((Configuration)conf, (long)8192L, (int)1);
        Assert.assertTrue((params.taskManagerDirectMemoryLimitMB() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((params.taskManagerHeapSizeMB() + params.taskManagerDirectMemoryLimitMB() <= 8192L ? 1 : 0) != 0);
    }

    @Test
    public void testTotalMemoryDoesNotExceedContainerMemoryOffHeap() {
        Configuration conf = new Configuration();
        conf.setBoolean(TaskManagerOptions.MEMORY_OFF_HEAP, true);
        ContaineredTaskManagerParameters params = ContaineredTaskManagerParameters.create((Configuration)conf, (long)8192L, (int)1);
        Assert.assertTrue((params.taskManagerDirectMemoryLimitMB() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((params.taskManagerHeapSizeMB() + params.taskManagerDirectMemoryLimitMB() <= 8192L ? 1 : 0) != 0);
    }

    @Test
    public void testCalculateCutoffMB() {
        Configuration config = new Configuration();
        long containerMemoryMB = 1000L;
        config.setFloat(ResourceManagerOptions.CONTAINERIZED_HEAP_CUTOFF_RATIO, 0.1f);
        config.setInteger(ResourceManagerOptions.CONTAINERIZED_HEAP_CUTOFF_MIN, 128);
        Assert.assertEquals((long)128L, (long)ContaineredTaskManagerParameters.calculateCutoffMB((Configuration)config, (long)containerMemoryMB));
        config.setFloat(ResourceManagerOptions.CONTAINERIZED_HEAP_CUTOFF_RATIO, 0.2f);
        Assert.assertEquals((long)200L, (long)ContaineredTaskManagerParameters.calculateCutoffMB((Configuration)config, (long)containerMemoryMB));
        config.setInteger(ResourceManagerOptions.CONTAINERIZED_HEAP_CUTOFF_MIN, 1000);
        try {
            ContaineredTaskManagerParameters.calculateCutoffMB((Configuration)config, (long)containerMemoryMB);
            Assert.fail((String)"Expected to fail with an invalid argument exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

