/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.instance.SimpleSlotContext;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.SlotContext;
import org.apache.flink.runtime.jobmaster.slotpool.PreviousAllocationSchedulingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SchedulingStrategy;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class SlotProfileTest
extends TestLogger {
    private final ResourceProfile resourceProfile = new ResourceProfile(2.0, 1024);
    private final AllocationID aid1 = new AllocationID();
    private final AllocationID aid2 = new AllocationID();
    private final AllocationID aid3 = new AllocationID();
    private final AllocationID aid4 = new AllocationID();
    private final AllocationID aidX = new AllocationID();
    private final TaskManagerLocation tml1 = new TaskManagerLocation(new ResourceID("tm-1"), InetAddress.getLoopbackAddress(), 42);
    private final TaskManagerLocation tml2 = new TaskManagerLocation(new ResourceID("tm-2"), InetAddress.getLoopbackAddress(), 43);
    private final TaskManagerLocation tml3 = new TaskManagerLocation(new ResourceID("tm-3"), InetAddress.getLoopbackAddress(), 44);
    private final TaskManagerLocation tml4 = new TaskManagerLocation(new ResourceID("tm-4"), InetAddress.getLoopbackAddress(), 45);
    private final TaskManagerLocation tmlX = new TaskManagerLocation(new ResourceID("tm-X"), InetAddress.getLoopbackAddress(), 46);
    private final TaskManagerGateway taskManagerGateway = new SimpleAckingTaskManagerGateway();
    private SimpleSlotContext ssc1 = new SimpleSlotContext(this.aid1, this.tml1, 1, this.taskManagerGateway);
    private SimpleSlotContext ssc2 = new SimpleSlotContext(this.aid2, this.tml2, 2, this.taskManagerGateway);
    private SimpleSlotContext ssc3 = new SimpleSlotContext(this.aid3, this.tml3, 3, this.taskManagerGateway);
    private SimpleSlotContext ssc4 = new SimpleSlotContext(this.aid4, this.tml4, 4, this.taskManagerGateway);
    private final Set<SlotContext> candidates = Collections.unmodifiableSet(this.createCandidates());
    private final SchedulingStrategy schedulingStrategy = PreviousAllocationSchedulingStrategy.getInstance();

    private Set<SlotContext> createCandidates() {
        HashSet<SlotContext> candidates = new HashSet<SlotContext>(4);
        candidates.add((SlotContext)this.ssc1);
        candidates.add((SlotContext)this.ssc2);
        candidates.add((SlotContext)this.ssc3);
        candidates.add((SlotContext)this.ssc4);
        return candidates;
    }

    @Test
    public void matchNoRequirements() {
        SlotProfile slotProfile = new SlotProfile(this.resourceProfile, Collections.emptyList(), Collections.emptyList());
        SlotContext match = this.runMatching(slotProfile);
        Assert.assertTrue((boolean)this.candidates.contains(match));
    }

    @Test
    public void matchPreferredLocationNotAvailable() {
        SlotProfile slotProfile = new SlotProfile(this.resourceProfile, Collections.singletonList(this.tmlX), Collections.emptyList());
        SlotContext match = this.runMatching(slotProfile);
        Assert.assertTrue((boolean)this.candidates.contains(match));
    }

    @Test
    public void matchPreferredLocation() {
        SlotProfile slotProfile = new SlotProfile(this.resourceProfile, Collections.singletonList(this.tml2), Collections.emptyList());
        SlotContext match = this.runMatching(slotProfile);
        Assert.assertEquals((Object)this.ssc2, (Object)match);
        slotProfile = new SlotProfile(this.resourceProfile, Arrays.asList(this.tmlX, this.tml4), Collections.emptyList());
        match = this.runMatching(slotProfile);
        Assert.assertEquals((Object)this.ssc4, (Object)match);
        slotProfile = new SlotProfile(this.resourceProfile, Arrays.asList(this.tml3, this.tml1, this.tml3, this.tmlX), Collections.emptyList());
        match = this.runMatching(slotProfile);
        Assert.assertEquals((Object)this.ssc3, (Object)match);
    }

    @Test
    public void matchPreviousAllocationOverridesPreferredLocation() {
        SlotProfile slotProfile = new SlotProfile(this.resourceProfile, Collections.singletonList(this.tml2), Collections.singletonList(this.aid3));
        SlotContext match = this.runMatching(slotProfile);
        Assert.assertEquals((Object)this.ssc3, (Object)match);
        slotProfile = new SlotProfile(this.resourceProfile, Arrays.asList(this.tmlX, this.tml1), Arrays.asList(this.aidX, this.aid2));
        match = this.runMatching(slotProfile);
        Assert.assertEquals((Object)this.ssc2, (Object)match);
    }

    @Test
    public void matchPreviousLocationNotAvailableButByLocality() {
        SlotProfile slotProfile = new SlotProfile(this.resourceProfile, Collections.singletonList(this.tml4), Collections.singletonList(this.aidX));
        SlotContext match = this.runMatching(slotProfile);
        Assert.assertEquals((Object)this.ssc4, (Object)match);
    }

    @Test
    public void matchPreviousLocationNotAvailableAndAllOthersBlacklisted() {
        HashSet<AllocationID> blacklisted = new HashSet<AllocationID>(4);
        blacklisted.add(this.aid1);
        blacklisted.add(this.aid2);
        blacklisted.add(this.aid3);
        blacklisted.add(this.aid4);
        SlotProfile slotProfile = new SlotProfile(this.resourceProfile, Collections.singletonList(this.tml4), Collections.singletonList(this.aidX), blacklisted);
        SlotContext match = this.runMatching(slotProfile);
        Assert.assertNull((Object)match);
    }

    @Test
    public void matchPreviousLocationNotAvailableAndSomeOthersBlacklisted() {
        HashSet<AllocationID> blacklisted = new HashSet<AllocationID>(3);
        blacklisted.add(this.aid1);
        blacklisted.add(this.aid3);
        blacklisted.add(this.aid4);
        SlotProfile slotProfile = new SlotProfile(this.resourceProfile, Collections.singletonList(this.tml4), Collections.singletonList(this.aidX), blacklisted);
        SlotContext match = this.runMatching(slotProfile);
        Assert.assertEquals((Object)this.ssc2, (Object)match);
    }

    @Test
    public void matchPreviousLocationAvailableButAlsoBlacklisted() {
        HashSet<AllocationID> blacklisted = new HashSet<AllocationID>(4);
        blacklisted.add(this.aid1);
        blacklisted.add(this.aid2);
        blacklisted.add(this.aid3);
        blacklisted.add(this.aid4);
        SlotProfile slotProfile = new SlotProfile(this.resourceProfile, Collections.singletonList(this.tml3), Collections.singletonList(this.aid3), blacklisted);
        SlotContext match = this.runMatching(slotProfile);
        Assert.assertEquals((Object)this.ssc3, (Object)match);
    }

    private SlotContext runMatching(SlotProfile slotProfile) {
        return (SlotContext)this.schedulingStrategy.findMatchWithLocality(slotProfile, this.candidates::stream, candidate -> candidate, candidate -> true, (candidate, locality) -> candidate);
    }
}

