/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.execution.SuppressRestartsException;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.metrics.RestartTimeGauge;
import org.apache.flink.runtime.executiongraph.restart.RestartCallback;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.runtime.testtasks.NoOpInvokable;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ExecutionGraphMetricsTest
extends TestLogger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecutionGraphRestartTimeMetric() throws JobException, IOException, InterruptedException {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        try {
            long currentRestartingTime;
            int i;
            long currentRestartingTime2;
            int parallelism = 1;
            JobVertex jobVertex = new JobVertex("TestVertex");
            jobVertex.setParallelism(parallelism);
            jobVertex.setInvokableClass(NoOpInvokable.class);
            JobGraph jobGraph = new JobGraph("Test Job", new JobVertex[]{jobVertex});
            Configuration jobConfig = new Configuration();
            Time timeout = Time.seconds((long)10L);
            Scheduler scheduler = (Scheduler)Mockito.mock(Scheduler.class);
            CompletableFuture<TestingLogicalSlot> slotFuture1 = CompletableFuture.completedFuture(new TestingLogicalSlot());
            CompletableFuture<TestingLogicalSlot> slotFuture2 = CompletableFuture.completedFuture(new TestingLogicalSlot());
            Mockito.when((Object)scheduler.allocateSlot((SlotRequestId)Mockito.any(SlotRequestId.class), (ScheduledUnit)Mockito.any(ScheduledUnit.class), Mockito.anyBoolean(), (SlotProfile)Mockito.any(SlotProfile.class), (Time)Mockito.any(Time.class))).thenReturn(slotFuture1, (Object[])new CompletableFuture[]{slotFuture2});
            TestingRestartStrategy testingRestartStrategy = new TestingRestartStrategy();
            ExecutionGraph executionGraph = new ExecutionGraph(executor, (Executor)executor, jobGraph.getJobID(), jobGraph.getName(), jobConfig, new SerializedValue(null), timeout, (RestartStrategy)testingRestartStrategy, (SlotProvider)scheduler);
            RestartTimeGauge restartingTime = new RestartTimeGauge(executionGraph);
            Assert.assertEquals((long)0L, (long)restartingTime.getValue());
            executionGraph.attachJobGraph(jobGraph.getVerticesSortedTopologicallyFromSources());
            executionGraph.scheduleForExecution();
            Assert.assertEquals((long)0L, (long)restartingTime.getValue());
            ArrayList<ExecutionAttemptID> executionIDs = new ArrayList<ExecutionAttemptID>();
            for (ExecutionVertex executionVertex : executionGraph.getAllExecutionVertices()) {
                executionIDs.add(executionVertex.getCurrentExecutionAttempt().getAttemptId());
            }
            for (ExecutionAttemptID executionID : executionIDs) {
                executionGraph.updateState(new TaskExecutionState(jobGraph.getJobID(), executionID, ExecutionState.RUNNING));
            }
            Assert.assertEquals((Object)JobStatus.RUNNING, (Object)executionGraph.getState());
            Assert.assertEquals((long)0L, (long)restartingTime.getValue());
            Thread.sleep(1L);
            for (ExecutionAttemptID executionID : executionIDs) {
                executionGraph.updateState(new TaskExecutionState(jobGraph.getJobID(), executionID, ExecutionState.FAILED, (Throwable)new Exception()));
            }
            Assert.assertEquals((Object)JobStatus.RESTARTING, (Object)executionGraph.getState());
            long firstRestartingTimestamp = executionGraph.getStatusTimestamp(JobStatus.RESTARTING);
            long previousRestartingTime = restartingTime.getValue();
            for (int i2 = 0; i2 < 2; ++i2) {
                Thread.sleep(1L);
                currentRestartingTime2 = restartingTime.getValue();
                Assert.assertTrue((currentRestartingTime2 >= previousRestartingTime ? 1 : 0) != 0);
                previousRestartingTime = currentRestartingTime2;
            }
            Assert.assertTrue((previousRestartingTime > 0L ? 1 : 0) != 0);
            testingRestartStrategy.restartExecutionGraph();
            executionIDs.clear();
            for (ExecutionVertex executionVertex : executionGraph.getAllExecutionVertices()) {
                executionIDs.add(executionVertex.getCurrentExecutionAttempt().getAttemptId());
            }
            for (ExecutionAttemptID executionID : executionIDs) {
                executionGraph.updateState(new TaskExecutionState(jobGraph.getJobID(), executionID, ExecutionState.RUNNING));
            }
            Assert.assertEquals((Object)JobStatus.RUNNING, (Object)executionGraph.getState());
            Assert.assertTrue((firstRestartingTimestamp != 0L ? 1 : 0) != 0);
            previousRestartingTime = restartingTime.getValue();
            for (int i3 = 0; i3 < 2; ++i3) {
                currentRestartingTime2 = restartingTime.getValue();
                Assert.assertTrue((currentRestartingTime2 == previousRestartingTime ? 1 : 0) != 0);
                previousRestartingTime = currentRestartingTime2;
            }
            Thread.sleep(1L);
            for (ExecutionAttemptID executionID : executionIDs) {
                executionGraph.updateState(new TaskExecutionState(jobGraph.getJobID(), executionID, ExecutionState.FAILED, (Throwable)new Exception()));
            }
            Assert.assertEquals((Object)JobStatus.RESTARTING, (Object)executionGraph.getState());
            long secondRestartingTimestamp = executionGraph.getStatusTimestamp(JobStatus.RESTARTING);
            Assert.assertTrue((firstRestartingTimestamp != secondRestartingTimestamp ? 1 : 0) != 0);
            previousRestartingTime = restartingTime.getValue();
            for (i = 0; i < 2; ++i) {
                Thread.sleep(1L);
                currentRestartingTime = restartingTime.getValue();
                Assert.assertTrue((currentRestartingTime >= previousRestartingTime ? 1 : 0) != 0);
                previousRestartingTime = currentRestartingTime;
            }
            Assert.assertTrue((previousRestartingTime > 0L ? 1 : 0) != 0);
            executionGraph.failGlobal((Throwable)new SuppressRestartsException((Throwable)new Exception()));
            Assert.assertEquals((Object)JobStatus.FAILED, (Object)executionGraph.getState());
            previousRestartingTime = restartingTime.getValue();
            for (i = 0; i < 10; ++i) {
                currentRestartingTime = restartingTime.getValue();
                Assert.assertTrue((currentRestartingTime == previousRestartingTime ? 1 : 0) != 0);
                previousRestartingTime = currentRestartingTime;
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    static class TestingRestartStrategy
    implements RestartStrategy {
        private RestartCallback restarter;

        TestingRestartStrategy() {
        }

        public boolean canRestart() {
            return true;
        }

        public void restart(RestartCallback restarter, ScheduledExecutor executor) {
            this.restarter = restarter;
        }

        public void restartExecutionGraph() {
            this.restarter.triggerFullRecovery();
        }
    }
}

