/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.IOException;
import java.util.Collections;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.BaseTestingActorGateway;
import org.apache.flink.runtime.instance.DummyActorGateway;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.LocationPreferenceConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.jobmanager.slots.ActorTaskManagerGateway;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.TaskMessages;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.testutils.DirectScheduledExecutorService;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import scala.concurrent.ExecutionContext;

public class ExecutionVertexCancelTest
extends TestLogger {
    @Test
    public void testCancelFromCreated() {
        try {
            JobVertexID jid = new JobVertexID();
            ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionVertex(jid);
            ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
            Assert.assertEquals((Object)ExecutionState.CREATED, (Object)vertex.getExecutionState());
            vertex.cancel();
            Assert.assertEquals((Object)ExecutionState.CANCELED, (Object)vertex.getExecutionState());
            Assert.assertNull((Object)vertex.getFailureCause());
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELING) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELED) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCancelFromScheduled() {
        try {
            JobVertexID jid = new JobVertexID();
            ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionVertex(jid);
            ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
            ExecutionGraphTestUtils.setVertexState(vertex, ExecutionState.SCHEDULED);
            Assert.assertEquals((Object)ExecutionState.SCHEDULED, (Object)vertex.getExecutionState());
            vertex.cancel();
            Assert.assertEquals((Object)ExecutionState.CANCELED, (Object)vertex.getExecutionState());
            Assert.assertNull((Object)vertex.getFailureCause());
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELING) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELED) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCancelConcurrentlyToDeploying_CallsNotOvertaking() {
        try {
            JobVertexID jid = new JobVertexID();
            TestingUtils.QueuedActionExecutionContext executionContext = TestingUtils.queuedActionExecutionContext();
            TestingUtils.ActionQueue actions = executionContext.actionQueue();
            ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionVertex(jid, executionContext);
            ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
            ExecutionGraphTestUtils.setVertexState(vertex, ExecutionState.SCHEDULED);
            Assert.assertEquals((Object)ExecutionState.SCHEDULED, (Object)vertex.getExecutionState());
            CancelSequenceActorGateway actorGateway = new CancelSequenceActorGateway(executionContext, 2);
            Instance instance = ExecutionGraphTestUtils.getInstance((TaskManagerGateway)new ActorTaskManagerGateway((ActorGateway)actorGateway));
            SimpleSlot slot = instance.allocateSimpleSlot();
            vertex.deployToSlot(slot);
            Assert.assertEquals((Object)ExecutionState.DEPLOYING, (Object)vertex.getExecutionState());
            vertex.cancel();
            Assert.assertEquals((Object)ExecutionState.CANCELING, (Object)vertex.getExecutionState());
            actions.triggerNextAction();
            Assert.assertEquals((Object)ExecutionState.CANCELING, (Object)vertex.getExecutionState());
            Assert.assertEquals((Object)ExecutionState.CANCELING, (Object)vertex.getExecutionState());
            actions.triggerNextAction();
            vertex.getCurrentExecutionAttempt().cancelingComplete();
            Assert.assertEquals((Object)ExecutionState.CANCELED, (Object)vertex.getExecutionState());
            actions.triggerNextAction();
            Assert.assertEquals((Object)ExecutionState.CANCELED, (Object)vertex.getExecutionState());
            Assert.assertTrue((boolean)slot.isReleased());
            Assert.assertNull((Object)vertex.getFailureCause());
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELING) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELED) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCancelConcurrentlyToDeploying_CallsOvertaking() {
        try {
            JobVertexID jid = new JobVertexID();
            TestingUtils.QueuedActionExecutionContext executionContext = TestingUtils.queuedActionExecutionContext();
            TestingUtils.ActionQueue actions = executionContext.actionQueue();
            ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionVertex(jid, executionContext);
            ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
            ExecutionGraphTestUtils.setVertexState(vertex, ExecutionState.SCHEDULED);
            Assert.assertEquals((Object)ExecutionState.SCHEDULED, (Object)vertex.getExecutionState());
            CancelSequenceActorGateway actorGateway = new CancelSequenceActorGateway(executionContext, 2);
            Instance instance = ExecutionGraphTestUtils.getInstance((TaskManagerGateway)new ActorTaskManagerGateway((ActorGateway)actorGateway));
            SimpleSlot slot = instance.allocateSimpleSlot();
            vertex.deployToSlot(slot);
            Assert.assertEquals((Object)ExecutionState.DEPLOYING, (Object)vertex.getExecutionState());
            vertex.cancel();
            Assert.assertEquals((Object)ExecutionState.CANCELING, (Object)vertex.getExecutionState());
            Runnable deployAction = actions.popNextAction();
            Runnable cancelAction = actions.popNextAction();
            cancelAction.run();
            actions.triggerNextAction();
            Assert.assertEquals((Object)ExecutionState.CANCELING, (Object)vertex.getExecutionState());
            deployAction.run();
            Assert.assertEquals((Object)ExecutionState.CANCELING, (Object)vertex.getExecutionState());
            vertex.getCurrentExecutionAttempt().cancelingComplete();
            Assert.assertEquals((Object)ExecutionState.CANCELED, (Object)vertex.getExecutionState());
            Assert.assertTrue((boolean)slot.isReleased());
            Assert.assertNull((Object)vertex.getFailureCause());
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELING) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELED) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCancelFromRunning() {
        try {
            JobVertexID jid = new JobVertexID();
            ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionVertex(jid, new DirectScheduledExecutorService());
            ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
            CancelSequenceActorGateway actorGateway = new CancelSequenceActorGateway((ExecutionContext)TestingUtils.directExecutionContext(), 1);
            Instance instance = ExecutionGraphTestUtils.getInstance((TaskManagerGateway)new ActorTaskManagerGateway((ActorGateway)actorGateway));
            SimpleSlot slot = instance.allocateSimpleSlot();
            ExecutionGraphTestUtils.setVertexResource(vertex, slot);
            ExecutionGraphTestUtils.setVertexState(vertex, ExecutionState.RUNNING);
            Assert.assertEquals((Object)ExecutionState.RUNNING, (Object)vertex.getExecutionState());
            vertex.cancel();
            vertex.getCurrentExecutionAttempt().cancelingComplete();
            Assert.assertEquals((Object)ExecutionState.CANCELED, (Object)vertex.getExecutionState());
            Assert.assertTrue((boolean)slot.isReleased());
            Assert.assertNull((Object)vertex.getFailureCause());
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELING) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELED) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testRepeatedCancelFromRunning() {
        try {
            JobVertexID jid = new JobVertexID();
            ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionVertex(jid, new DirectScheduledExecutorService());
            ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
            CancelSequenceActorGateway actorGateway = new CancelSequenceActorGateway((ExecutionContext)TestingUtils.directExecutionContext(), 1);
            Instance instance = ExecutionGraphTestUtils.getInstance((TaskManagerGateway)new ActorTaskManagerGateway((ActorGateway)actorGateway));
            SimpleSlot slot = instance.allocateSimpleSlot();
            ExecutionGraphTestUtils.setVertexResource(vertex, slot);
            ExecutionGraphTestUtils.setVertexState(vertex, ExecutionState.RUNNING);
            Assert.assertEquals((Object)ExecutionState.RUNNING, (Object)vertex.getExecutionState());
            vertex.cancel();
            Assert.assertEquals((Object)ExecutionState.CANCELING, (Object)vertex.getExecutionState());
            vertex.cancel();
            Assert.assertEquals((Object)ExecutionState.CANCELING, (Object)vertex.getExecutionState());
            vertex.getCurrentExecutionAttempt().cancelingComplete();
            Assert.assertEquals((Object)ExecutionState.CANCELED, (Object)vertex.getExecutionState());
            Assert.assertTrue((boolean)slot.isReleased());
            Assert.assertNull((Object)vertex.getFailureCause());
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELING) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELED) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCancelFromRunningDidNotFindTask() {
        try {
            JobVertexID jid = new JobVertexID();
            ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionVertex(jid, new DirectScheduledExecutorService());
            ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
            CancelSequenceActorGateway actorGateway = new CancelSequenceActorGateway((ExecutionContext)TestingUtils.directExecutionContext(), 1);
            Instance instance = ExecutionGraphTestUtils.getInstance((TaskManagerGateway)new ActorTaskManagerGateway((ActorGateway)actorGateway));
            SimpleSlot slot = instance.allocateSimpleSlot();
            ExecutionGraphTestUtils.setVertexResource(vertex, slot);
            ExecutionGraphTestUtils.setVertexState(vertex, ExecutionState.RUNNING);
            Assert.assertEquals((Object)ExecutionState.RUNNING, (Object)vertex.getExecutionState());
            vertex.cancel();
            Assert.assertEquals((Object)ExecutionState.CANCELING, (Object)vertex.getExecutionState());
            Assert.assertNull((Object)vertex.getFailureCause());
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELING) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCancelCallFails() {
        try {
            JobVertexID jid = new JobVertexID();
            ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionVertex(jid, new DirectScheduledExecutorService());
            ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
            CancelSequenceActorGateway gateway = new CancelSequenceActorGateway((ExecutionContext)TestingUtils.directExecutionContext(), 0);
            Instance instance = ExecutionGraphTestUtils.getInstance((TaskManagerGateway)new ActorTaskManagerGateway((ActorGateway)gateway));
            SimpleSlot slot = instance.allocateSimpleSlot();
            ExecutionGraphTestUtils.setVertexResource(vertex, slot);
            ExecutionGraphTestUtils.setVertexState(vertex, ExecutionState.RUNNING);
            Assert.assertEquals((Object)ExecutionState.RUNNING, (Object)vertex.getExecutionState());
            vertex.cancel();
            Assert.assertEquals((Object)ExecutionState.CANCELED, (Object)vertex.getExecutionState());
            Assert.assertTrue((boolean)slot.isReleased());
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELING) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSendCancelAndReceiveFail() throws Exception {
        ExecutionGraph graph = ExecutionGraphTestUtils.createSimpleTestGraph();
        graph.scheduleForExecution();
        ExecutionGraphTestUtils.switchAllVerticesToRunning(graph);
        Assert.assertEquals((Object)JobStatus.RUNNING, (Object)graph.getState());
        ExecutionVertex[] vertices = ((ExecutionJobVertex)graph.getVerticesTopologically().iterator().next()).getTaskVertices();
        Assert.assertEquals((long)vertices.length, (long)graph.getRegisteredExecutions().size());
        Execution exec = vertices[3].getCurrentExecutionAttempt();
        exec.cancel();
        Assert.assertEquals((Object)ExecutionState.CANCELING, (Object)exec.getState());
        exec.markFailed((Throwable)new Exception("test"));
        Assert.assertTrue((exec.getState() == ExecutionState.FAILED || exec.getState() == ExecutionState.CANCELED ? 1 : 0) != 0);
        Assert.assertFalse((boolean)exec.getAssignedResource().isAlive());
        Assert.assertEquals((long)(vertices.length - 1), (long)exec.getVertex().getExecutionGraph().getRegisteredExecutions().size());
    }

    @Test
    public void testScheduleOrDeployAfterCancel() {
        try {
            JobVertexID jid = new JobVertexID();
            ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionVertex(jid);
            ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
            ExecutionGraphTestUtils.setVertexState(vertex, ExecutionState.CANCELED);
            Assert.assertEquals((Object)ExecutionState.CANCELED, (Object)vertex.getExecutionState());
            Scheduler scheduler = (Scheduler)Mockito.mock(Scheduler.class);
            vertex.scheduleForExecution((SlotProvider)scheduler, false, LocationPreferenceConstraint.ALL, Collections.emptySet());
            Assert.assertEquals((Object)ExecutionState.CANCELED, (Object)vertex.getExecutionState());
            try {
                Instance instance = ExecutionGraphTestUtils.getInstance((TaskManagerGateway)new ActorTaskManagerGateway((ActorGateway)DummyActorGateway.INSTANCE));
                SimpleSlot slot = instance.allocateSimpleSlot();
                vertex.deployToSlot(slot);
                Assert.fail((String)"Method should throw an exception");
            }
            catch (IllegalStateException e) {
                Assert.assertEquals((Object)ExecutionState.CANCELED, (Object)vertex.getExecutionState());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testActionsWhileCancelling() {
        try {
            SimpleSlot slot;
            Instance instance;
            ExecutionVertex vertex;
            JobVertexID jid = new JobVertexID();
            ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionVertex(jid);
            try {
                vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
                ExecutionGraphTestUtils.setVertexState(vertex, ExecutionState.CANCELING);
                Scheduler scheduler = (Scheduler)Mockito.mock(Scheduler.class);
                vertex.scheduleForExecution((SlotProvider)scheduler, false, LocationPreferenceConstraint.ALL, Collections.emptySet());
            }
            catch (Exception e) {
                Assert.fail((String)"should not throw an exception");
            }
            try {
                vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
                ExecutionGraphTestUtils.setVertexState(vertex, ExecutionState.CANCELING);
                instance = ExecutionGraphTestUtils.getInstance((TaskManagerGateway)new ActorTaskManagerGateway((ActorGateway)DummyActorGateway.INSTANCE));
                slot = instance.allocateSimpleSlot();
                vertex.deployToSlot(slot);
                Assert.fail((String)"Method should throw an exception");
            }
            catch (IllegalStateException vertex2) {
                // empty catch block
            }
            vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
            instance = ExecutionGraphTestUtils.getInstance((TaskManagerGateway)new ActorTaskManagerGateway((ActorGateway)DummyActorGateway.INSTANCE));
            slot = instance.allocateSimpleSlot();
            ExecutionGraphTestUtils.setVertexResource(vertex, slot);
            ExecutionGraphTestUtils.setVertexState(vertex, ExecutionState.CANCELING);
            Exception failureCause = new Exception("test exception");
            vertex.fail((Throwable)failureCause);
            Assert.assertEquals((Object)ExecutionState.CANCELED, (Object)vertex.getExecutionState());
            Assert.assertTrue((boolean)slot.isReleased());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public static class CancelSequenceActorGateway
    extends BaseTestingActorGateway {
        private final int successfulOperations;
        private int index = -1;

        public CancelSequenceActorGateway(ExecutionContext executionContext, int successfulOperations) {
            super(executionContext);
            this.successfulOperations = successfulOperations;
        }

        @Override
        public Object handleMessage(Object message) throws Exception {
            Acknowledge result;
            if (message instanceof TaskMessages.SubmitTask) {
                result = Acknowledge.get();
            } else if (message instanceof TaskMessages.CancelTask) {
                ++this.index;
                if (this.index >= this.successfulOperations) {
                    throw new IOException("RPC call failed.");
                }
                result = Acknowledge.get();
            } else {
                result = null;
            }
            return result;
        }
    }
}

