/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.apache.flink.util.SerializedValue;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class LegacyJobVertexIdTest {
    @Test
    public void testIntroduceLegacyJobVertexIds() throws Exception {
        JobVertexID defaultId = new JobVertexID();
        JobVertexID legacyId1 = new JobVertexID();
        JobVertexID legacyId2 = new JobVertexID();
        JobVertex jobVertex = new JobVertex("test", defaultId, Arrays.asList(legacyId1, legacyId2), new ArrayList(), new ArrayList());
        jobVertex.setInvokableClass(AbstractInvokable.class);
        ExecutionGraph executionGraph = new ExecutionGraph((ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class), (Executor)Mockito.mock(Executor.class), new JobID(), "test", (Configuration)Mockito.mock(Configuration.class), (SerializedValue)Mockito.mock(SerializedValue.class), Time.seconds((long)1L), (RestartStrategy)Mockito.mock(RestartStrategy.class), (SlotProvider)Mockito.mock(SlotProvider.class));
        ExecutionJobVertex executionJobVertex = new ExecutionJobVertex(executionGraph, jobVertex, 1, Time.seconds((long)1L));
        Map idToVertex = new HashMap<JobVertexID, ExecutionJobVertex>();
        idToVertex.put(executionJobVertex.getJobVertexId(), executionJobVertex);
        Assert.assertEquals((Object)executionJobVertex, idToVertex.get(defaultId));
        Assert.assertNull(idToVertex.get(legacyId1));
        Assert.assertNull(idToVertex.get(legacyId2));
        idToVertex = ExecutionJobVertex.includeLegacyJobVertexIDs(idToVertex);
        Assert.assertEquals((long)3L, (long)idToVertex.size());
        Assert.assertEquals((Object)executionJobVertex, idToVertex.get(defaultId));
        Assert.assertEquals((Object)executionJobVertex, idToVertex.get(legacyId1));
        Assert.assertEquals((Object)executionJobVertex, idToVertex.get(legacyId2));
    }
}

