/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.utils;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.PartitionInfo;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.StackTrace;
import org.apache.flink.runtime.messages.StackTraceSampleResponse;

public class SimpleAckingTaskManagerGateway
implements TaskManagerGateway {
    private final String address = UUID.randomUUID().toString();
    private Optional<Consumer<ExecutionAttemptID>> optSubmitConsumer;
    private Optional<Consumer<ExecutionAttemptID>> optCancelConsumer;
    private volatile BiFunction<AllocationID, Throwable, CompletableFuture<Acknowledge>> freeSlotFunction;
    @Nonnull
    private volatile BiConsumer<InstanceID, Exception> disconnectFromJobManagerConsumer = (ignoredA, ignoredB) -> {};

    public SimpleAckingTaskManagerGateway() {
        this.optSubmitConsumer = Optional.empty();
        this.optCancelConsumer = Optional.empty();
    }

    public void setSubmitConsumer(Consumer<ExecutionAttemptID> predicate) {
        this.optSubmitConsumer = Optional.of(predicate);
    }

    public void setCancelConsumer(Consumer<ExecutionAttemptID> predicate) {
        this.optCancelConsumer = Optional.of(predicate);
    }

    public void setFreeSlotFunction(BiFunction<AllocationID, Throwable, CompletableFuture<Acknowledge>> freeSlotFunction) {
        this.freeSlotFunction = freeSlotFunction;
    }

    public void setDisconnectFromJobManagerConsumer(@Nonnull BiConsumer<InstanceID, Exception> disconnectFromJobManagerConsumer) {
        this.disconnectFromJobManagerConsumer = disconnectFromJobManagerConsumer;
    }

    public String getAddress() {
        return this.address;
    }

    public void disconnectFromJobManager(InstanceID instanceId, Exception cause) {
        this.disconnectFromJobManagerConsumer.accept(instanceId, cause);
    }

    public void stopCluster(ApplicationStatus applicationStatus, String message) {
    }

    public CompletableFuture<StackTrace> requestStackTrace(Time timeout) {
        return FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    }

    public CompletableFuture<StackTraceSampleResponse> requestStackTraceSample(ExecutionAttemptID executionAttemptID, int sampleId, int numSamples, Time delayBetweenSamples, int maxStackTraceDepth, Time timeout) {
        return FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    }

    public CompletableFuture<Acknowledge> submitTask(TaskDeploymentDescriptor tdd, Time timeout) {
        this.optSubmitConsumer.ifPresent(condition -> condition.accept(tdd.getExecutionAttemptId()));
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public CompletableFuture<Acknowledge> stopTask(ExecutionAttemptID executionAttemptID, Time timeout) {
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public CompletableFuture<Acknowledge> cancelTask(ExecutionAttemptID executionAttemptID, Time timeout) {
        this.optCancelConsumer.ifPresent(condition -> condition.accept(executionAttemptID));
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public CompletableFuture<Acknowledge> updatePartitions(ExecutionAttemptID executionAttemptID, Iterable<PartitionInfo> partitionInfos, Time timeout) {
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public void failPartition(ExecutionAttemptID executionAttemptID) {
    }

    public void notifyCheckpointComplete(ExecutionAttemptID executionAttemptID, JobID jobId, long checkpointId, long timestamp) {
    }

    public void triggerCheckpoint(ExecutionAttemptID executionAttemptID, JobID jobId, long checkpointId, long timestamp, CheckpointOptions checkpointOptions) {
    }

    public CompletableFuture<TransientBlobKey> requestTaskManagerLog(Time timeout) {
        return FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    }

    public CompletableFuture<TransientBlobKey> requestTaskManagerStdout(Time timeout) {
        return FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    }

    public CompletableFuture<Acknowledge> freeSlot(AllocationID allocationId, Throwable cause, Time timeout) {
        BiFunction<AllocationID, Throwable, CompletableFuture<Acknowledge>> currentFreeSlotFunction = this.freeSlotFunction;
        if (currentFreeSlotFunction != null) {
            return currentFreeSlotFunction.apply(allocationId, cause);
        }
        return CompletableFuture.completedFuture(Acknowledge.get());
    }
}

