/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import java.io.File;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.highavailability.FsNegativeRunningJobsRegistry;
import org.apache.flink.runtime.highavailability.RunningJobsRegistry;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FsNegativeRunningJobsRegistryTest
extends TestLogger {
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void testCreateAndSetFinished() throws Exception {
        File folder = this.tempFolder.newFolder();
        String uri = folder.toURI().toString();
        JobID jid = new JobID();
        FsNegativeRunningJobsRegistry registry = new FsNegativeRunningJobsRegistry(new Path(uri));
        FsNegativeRunningJobsRegistry otherRegistry = new FsNegativeRunningJobsRegistry(new Path(uri));
        Assert.assertEquals((Object)RunningJobsRegistry.JobSchedulingStatus.PENDING, (Object)registry.getJobSchedulingStatus(jid));
        Assert.assertEquals((Object)RunningJobsRegistry.JobSchedulingStatus.PENDING, (Object)otherRegistry.getJobSchedulingStatus(jid));
        registry.setJobRunning(jid);
        Assert.assertEquals((Object)RunningJobsRegistry.JobSchedulingStatus.RUNNING, (Object)registry.getJobSchedulingStatus(jid));
        Assert.assertEquals((Object)RunningJobsRegistry.JobSchedulingStatus.RUNNING, (Object)otherRegistry.getJobSchedulingStatus(jid));
        registry.setJobFinished(jid);
        Assert.assertEquals((Object)RunningJobsRegistry.JobSchedulingStatus.DONE, (Object)registry.getJobSchedulingStatus(jid));
        Assert.assertEquals((Object)RunningJobsRegistry.JobSchedulingStatus.DONE, (Object)otherRegistry.getJobSchedulingStatus(jid));
    }

    @Test
    public void testSetFinishedAndRunning() throws Exception {
        File folder = this.tempFolder.newFolder();
        String uri = folder.toURI().toString();
        JobID jid = new JobID();
        FsNegativeRunningJobsRegistry registry = new FsNegativeRunningJobsRegistry(new Path(uri));
        registry.setJobFinished(jid);
        Assert.assertEquals((Object)RunningJobsRegistry.JobSchedulingStatus.DONE, (Object)registry.getJobSchedulingStatus(jid));
        registry.setJobRunning(jid);
        Assert.assertEquals((Object)RunningJobsRegistry.JobSchedulingStatus.DONE, (Object)registry.getJobSchedulingStatus(jid));
        FsNegativeRunningJobsRegistry otherRegistry = new FsNegativeRunningJobsRegistry(new Path(uri));
        Assert.assertEquals((Object)RunningJobsRegistry.JobSchedulingStatus.DONE, (Object)otherRegistry.getJobSchedulingStatus(jid));
        otherRegistry.clearJob(jid);
        Assert.assertEquals((Object)RunningJobsRegistry.JobSchedulingStatus.PENDING, (Object)registry.getJobSchedulingStatus(jid));
        Assert.assertEquals((Object)RunningJobsRegistry.JobSchedulingStatus.PENDING, (Object)otherRegistry.getJobSchedulingStatus(jid));
    }
}

