/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import java.util.concurrent.Executor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesFactory;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.jobmanager.HighAvailabilityMode;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class HighAvailabilityServicesUtilsTest
extends TestLogger {
    @Test
    public void testCreateCustomHAServices() throws Exception {
        HighAvailabilityServices haServices;
        Configuration config = new Configuration();
        TestHAFactory.haServices = haServices = (HighAvailabilityServices)Mockito.mock(HighAvailabilityServices.class);
        Executor executor = (Executor)Mockito.mock(Executor.class);
        config.setString(HighAvailabilityOptions.HA_MODE, TestHAFactory.class.getName());
        HighAvailabilityServices actualHaServices = HighAvailabilityServicesUtils.createAvailableOrEmbeddedServices((Configuration)config, (Executor)executor);
        Assert.assertSame((Object)haServices, (Object)actualHaServices);
        actualHaServices = HighAvailabilityServicesUtils.createHighAvailabilityServices((Configuration)config, (Executor)executor, (HighAvailabilityServicesUtils.AddressResolution)HighAvailabilityServicesUtils.AddressResolution.NO_ADDRESS_RESOLUTION);
        Assert.assertSame((Object)haServices, (Object)actualHaServices);
    }

    @Test(expected=Exception.class)
    public void testCustomHAServicesFactoryNotDefined() throws Exception {
        Configuration config = new Configuration();
        Executor executor = (Executor)Mockito.mock(Executor.class);
        config.setString(HighAvailabilityOptions.HA_MODE, HighAvailabilityMode.FACTORY_CLASS.name().toLowerCase());
        HighAvailabilityServicesUtils.createAvailableOrEmbeddedServices((Configuration)config, (Executor)executor);
    }

    public static class TestHAFactory
    implements HighAvailabilityServicesFactory {
        static HighAvailabilityServices haServices;

        public HighAvailabilityServices createHAServices(Configuration configuration, Executor executor) {
            return haServices;
        }
    }
}

