/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import akka.actor.ActorSystem;
import akka.actor.RobustActorSystem;
import akka.testkit.JavaTestKit;
import com.typesafe.config.Config;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.AkkaActorGateway;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.instance.InstanceManager;
import org.apache.flink.runtime.jobmanager.slots.ActorTaskManagerGateway;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.util.TestLogger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class InstanceManagerTest
extends TestLogger {
    static ActorSystem system;
    static UUID leaderSessionID;

    @BeforeClass
    public static void setup() {
        system = RobustActorSystem.create((String)"TestingActorSystem", (Config)TestingUtils.testConfig());
    }

    @AfterClass
    public static void teardown() {
        JavaTestKit.shutdownActorSystem((ActorSystem)system);
        system = null;
    }

    @Test
    public void testInstanceRegistering() {
        try {
            InstanceManager cm = new InstanceManager();
            int dataPort = 20000;
            HardwareDescription hardwareDescription = HardwareDescription.extractFromSystem((long)4096L);
            InetAddress address = InetAddress.getByName("127.0.0.1");
            ResourceID resID1 = ResourceID.generate();
            ResourceID resID2 = ResourceID.generate();
            ResourceID resID3 = ResourceID.generate();
            TaskManagerLocation ici1 = new TaskManagerLocation(resID1, address, 20000);
            TaskManagerLocation ici2 = new TaskManagerLocation(resID2, address, 20015);
            TaskManagerLocation ici3 = new TaskManagerLocation(resID3, address, 20030);
            JavaTestKit probe1 = new JavaTestKit(system);
            JavaTestKit probe2 = new JavaTestKit(system);
            JavaTestKit probe3 = new JavaTestKit(system);
            cm.registerTaskManager((TaskManagerGateway)new ActorTaskManagerGateway((ActorGateway)new AkkaActorGateway(probe1.getRef(), leaderSessionID)), ici1, hardwareDescription, 1);
            cm.registerTaskManager((TaskManagerGateway)new ActorTaskManagerGateway((ActorGateway)new AkkaActorGateway(probe2.getRef(), leaderSessionID)), ici2, hardwareDescription, 2);
            cm.registerTaskManager((TaskManagerGateway)new ActorTaskManagerGateway((ActorGateway)new AkkaActorGateway(probe3.getRef(), leaderSessionID)), ici3, hardwareDescription, 5);
            Assert.assertEquals((long)3L, (long)cm.getNumberOfRegisteredTaskManagers());
            Assert.assertEquals((long)8L, (long)cm.getTotalNumberOfSlots());
            Collection instances = cm.getAllRegisteredInstances();
            HashSet<TaskManagerLocation> taskManagerLocations = new HashSet<TaskManagerLocation>();
            for (Instance instance : instances) {
                taskManagerLocations.add(instance.getTaskManagerLocation());
            }
            Assert.assertTrue((boolean)taskManagerLocations.contains(ici1));
            Assert.assertTrue((boolean)taskManagerLocations.contains(ici2));
            Assert.assertTrue((boolean)taskManagerLocations.contains(ici3));
            cm.shutdown();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test erroneous: " + e.getMessage()));
        }
    }

    @Test
    public void testRegisteringAlreadyRegistered() {
        try {
            InstanceManager cm = new InstanceManager();
            int dataPort = 20000;
            ResourceID resID1 = ResourceID.generate();
            ResourceID resID2 = ResourceID.generate();
            HardwareDescription resources = HardwareDescription.extractFromSystem((long)4096L);
            InetAddress address = InetAddress.getByName("127.0.0.1");
            TaskManagerLocation ici = new TaskManagerLocation(resID1, address, 20000);
            JavaTestKit probe = new JavaTestKit(system);
            cm.registerTaskManager((TaskManagerGateway)new ActorTaskManagerGateway((ActorGateway)new AkkaActorGateway(probe.getRef(), leaderSessionID)), ici, resources, 1);
            Assert.assertEquals((long)1L, (long)cm.getNumberOfRegisteredTaskManagers());
            Assert.assertEquals((long)1L, (long)cm.getTotalNumberOfSlots());
            try {
                cm.registerTaskManager((TaskManagerGateway)new ActorTaskManagerGateway((ActorGateway)new AkkaActorGateway(probe.getRef(), leaderSessionID)), ici, resources, 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.assertEquals((long)1L, (long)cm.getNumberOfRegisteredTaskManagers());
            Assert.assertEquals((long)1L, (long)cm.getTotalNumberOfSlots());
            cm.shutdown();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test erroneous: " + e.getMessage()));
        }
    }

    @Test
    public void testReportHeartbeat() {
        try {
            InstanceManager cm = new InstanceManager();
            int dataPort = 20000;
            ResourceID resID1 = ResourceID.generate();
            ResourceID resID2 = ResourceID.generate();
            ResourceID resID3 = ResourceID.generate();
            HardwareDescription hardwareDescription = HardwareDescription.extractFromSystem((long)4096L);
            InetAddress address = InetAddress.getByName("127.0.0.1");
            TaskManagerLocation ici1 = new TaskManagerLocation(resID1, address, 20000);
            TaskManagerLocation ici2 = new TaskManagerLocation(resID2, address, 20001);
            TaskManagerLocation ici3 = new TaskManagerLocation(resID3, address, 20002);
            JavaTestKit probe1 = new JavaTestKit(system);
            JavaTestKit probe2 = new JavaTestKit(system);
            JavaTestKit probe3 = new JavaTestKit(system);
            InstanceID instanceID1 = cm.registerTaskManager((TaskManagerGateway)new ActorTaskManagerGateway((ActorGateway)new AkkaActorGateway(probe1.getRef(), leaderSessionID)), ici1, hardwareDescription, 1);
            InstanceID instanceID2 = cm.registerTaskManager((TaskManagerGateway)new ActorTaskManagerGateway((ActorGateway)new AkkaActorGateway(probe2.getRef(), leaderSessionID)), ici2, hardwareDescription, 1);
            InstanceID instanceID3 = cm.registerTaskManager((TaskManagerGateway)new ActorTaskManagerGateway((ActorGateway)new AkkaActorGateway(probe3.getRef(), leaderSessionID)), ici3, hardwareDescription, 1);
            Assert.assertTrue((boolean)cm.reportHeartBeat(instanceID1));
            Assert.assertTrue((boolean)cm.reportHeartBeat(instanceID2));
            Assert.assertTrue((boolean)cm.reportHeartBeat(instanceID3));
            Assert.assertFalse((boolean)cm.reportHeartBeat(new InstanceID()));
            long WAIT = 200L;
            CommonTestUtils.sleepUninterruptibly(200L);
            Iterator it = cm.getAllRegisteredInstances().iterator();
            Instance instance1 = (Instance)it.next();
            long h1 = instance1.getLastHeartBeat();
            long h2 = ((Instance)it.next()).getLastHeartBeat();
            long h3 = ((Instance)it.next()).getLastHeartBeat();
            Assert.assertTrue((boolean)cm.reportHeartBeat(instance1.getId()));
            long newH1 = instance1.getLastHeartBeat();
            long now = System.currentTimeMillis();
            Assert.assertTrue((now - h1 >= 200L ? 1 : 0) != 0);
            Assert.assertTrue((now - h2 >= 200L ? 1 : 0) != 0);
            Assert.assertTrue((now - h3 >= 200L ? 1 : 0) != 0);
            Assert.assertTrue((now - newH1 <= 200L ? 1 : 0) != 0);
            cm.shutdown();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test erroneous: " + e.getMessage()));
        }
    }

    @Test
    public void testShutdown() {
        try {
            InstanceManager cm = new InstanceManager();
            cm.shutdown();
            try {
                ResourceID resID = ResourceID.generate();
                HardwareDescription resources = HardwareDescription.extractFromSystem((long)4096L);
                InetAddress address = InetAddress.getByName("127.0.0.1");
                TaskManagerLocation ici = new TaskManagerLocation(resID, address, 20000);
                JavaTestKit probe = new JavaTestKit(system);
                cm.registerTaskManager((TaskManagerGateway)new ActorTaskManagerGateway((ActorGateway)new AkkaActorGateway(probe.getRef(), leaderSessionID)), ici, resources, 1);
                Assert.fail((String)"Should raise exception in shutdown state");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assert.assertFalse((boolean)cm.reportHeartBeat(new InstanceID()));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test erroneous: " + e.getMessage()));
        }
    }

    static {
        leaderSessionID = UUID.randomUUID();
    }
}

