/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.net.InetAddress;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.DummyActorGateway;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.jobmanager.slots.ActorTaskManagerGateway;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.TestingPayload;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class SimpleSlotTest
extends TestLogger {
    @Test
    public void testStateTransitions() {
        try {
            SimpleSlot slot = SimpleSlotTest.getSlot();
            Assert.assertTrue((boolean)slot.isAlive());
            slot.releaseSlot();
            Assert.assertFalse((boolean)slot.isAlive());
            Assert.assertTrue((boolean)slot.isCanceled());
            Assert.assertTrue((boolean)slot.isReleased());
            slot = SimpleSlotTest.getSlot();
            Assert.assertTrue((boolean)slot.isAlive());
            slot.markCancelled();
            Assert.assertFalse((boolean)slot.isAlive());
            Assert.assertTrue((boolean)slot.isCanceled());
            Assert.assertFalse((boolean)slot.isReleased());
            slot.markReleased();
            Assert.assertFalse((boolean)slot.isAlive());
            Assert.assertTrue((boolean)slot.isCanceled());
            Assert.assertTrue((boolean)slot.isReleased());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetExecutionVertex() {
        try {
            TestingPayload payload1 = new TestingPayload();
            TestingPayload payload2 = new TestingPayload();
            SimpleSlot slot = SimpleSlotTest.getSlot();
            Assert.assertTrue((boolean)slot.tryAssignPayload((LogicalSlot.Payload)payload1));
            Assert.assertEquals((Object)payload1, (Object)slot.getPayload());
            Assert.assertFalse((boolean)slot.tryAssignPayload((LogicalSlot.Payload)payload2));
            Assert.assertEquals((Object)payload1, (Object)slot.getPayload());
            slot = SimpleSlotTest.getSlot();
            Assert.assertTrue((boolean)slot.markCancelled());
            Assert.assertFalse((boolean)slot.tryAssignPayload((LogicalSlot.Payload)payload1));
            Assert.assertNull((Object)slot.getPayload());
            slot = SimpleSlotTest.getSlot();
            Assert.assertTrue((boolean)slot.markCancelled());
            Assert.assertTrue((boolean)slot.markReleased());
            Assert.assertFalse((boolean)slot.tryAssignPayload((LogicalSlot.Payload)payload1));
            Assert.assertNull((Object)slot.getPayload());
            slot = SimpleSlotTest.getSlot();
            slot.releaseSlot();
            Assert.assertFalse((boolean)slot.tryAssignPayload((LogicalSlot.Payload)payload1));
            Assert.assertNull((Object)slot.getPayload());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public static SimpleSlot getSlot() throws Exception {
        ResourceID resourceID = ResourceID.generate();
        HardwareDescription hardwareDescription = new HardwareDescription(4, 0x80000000L, 0x40000000L, 0x20000000L);
        InetAddress address = InetAddress.getByName("127.0.0.1");
        TaskManagerLocation connection = new TaskManagerLocation(resourceID, address, 10001);
        Instance instance = new Instance((TaskManagerGateway)new ActorTaskManagerGateway((ActorGateway)DummyActorGateway.INSTANCE), connection, new InstanceID(), hardwareDescription, 1);
        return instance.allocateSimpleSlot();
    }
}

