/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk;

import java.io.EOFException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegmentSource;
import org.apache.flink.runtime.io.disk.SpillingBuffer;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.ListMemorySegmentSource;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.runtime.operators.testutils.TestData;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SpillingBufferTest {
    private static final long SEED = 649180756312423613L;
    private static final int KEY_MAX = Integer.MAX_VALUE;
    private static final int VALUE_LENGTH = 114;
    private static final int NUM_PAIRS_INMEM = 6000;
    private static final int NUM_PAIRS_EXTERNAL = 30000;
    private static final int MEMORY_SIZE = 0x100000;
    private static final int NUM_MEMORY_SEGMENTS = 23;
    private final AbstractInvokable parentTask = new DummyInvokable();
    private IOManager ioManager;
    private MemoryManager memoryManager;

    @Before
    public void beforeTest() {
        this.memoryManager = new MemoryManager(0x100000L, 1);
        this.ioManager = new IOManagerAsync();
    }

    @After
    public void afterTest() {
        this.ioManager.shutdown();
        if (!this.ioManager.isProperlyShutDown()) {
            Assert.fail((String)"I/O Manager was not properly shut down.");
        }
        if (this.memoryManager != null) {
            Assert.assertTrue((String)"Memory leak: not all segments have been returned to the memory manager.", (boolean)this.memoryManager.verifyEmpty());
            this.memoryManager.shutdown();
            this.memoryManager = null;
        }
    }

    @Test
    public void testWriteReadInMemory() throws Exception {
        String v2;
        int k2;
        String v1;
        int k1;
        int i;
        TestData.TupleGenerator generator = new TestData.TupleGenerator(649180756312423613L, Integer.MAX_VALUE, 114, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
        TypeSerializer<Tuple2<Integer, String>> serializer = TestData.getIntStringTupleSerializer();
        ArrayList memory = new ArrayList(23);
        this.memoryManager.allocatePages((Object)this.parentTask, memory, 23);
        SpillingBuffer outView = new SpillingBuffer(this.ioManager, (MemorySegmentSource)new ListMemorySegmentSource(memory), this.memoryManager.getPageSize());
        Tuple2 rec = new Tuple2();
        for (int i2 = 0; i2 < 6000; ++i2) {
            generator.next((Tuple2<Integer, String>)rec);
            serializer.serialize((Object)rec, (DataOutputView)outView);
        }
        DataInputView inView = outView.flip();
        generator.reset();
        Tuple2 readRec = new Tuple2();
        for (i = 0; i < 6000; ++i) {
            generator.next((Tuple2<Integer, String>)rec);
            serializer.deserialize((Object)readRec, inView);
            k1 = (Integer)rec.f0;
            v1 = (String)rec.f1;
            k2 = (Integer)readRec.f0;
            v2 = (String)readRec.f1;
            Assert.assertTrue((String)"The re-generated and the notifyNonEmpty record do not match.", (k1 == k2 && v1.equals(v2) ? 1 : 0) != 0);
        }
        inView = outView.flip();
        generator.reset();
        for (i = 0; i < 6000; ++i) {
            generator.next((Tuple2<Integer, String>)rec);
            serializer.deserialize((Object)readRec, inView);
            k1 = (Integer)rec.f0;
            v1 = (String)rec.f1;
            k2 = (Integer)readRec.f0;
            v2 = (String)readRec.f1;
            Assert.assertTrue((String)"The re-generated and the notifyNonEmpty record do not match.", (k1 == k2 && v1.equals(v2) ? 1 : 0) != 0);
        }
        this.memoryManager.release((Collection)outView.close());
        this.memoryManager.release(memory);
    }

    @Test
    public void testWriteReadTooMuchInMemory() throws Exception {
        String v2;
        int k2;
        String v1;
        int k1;
        int i3;
        TestData.TupleGenerator generator = new TestData.TupleGenerator(649180756312423613L, Integer.MAX_VALUE, 114, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
        TypeSerializer<Tuple2<Integer, String>> serializer = TestData.getIntStringTupleSerializer();
        ArrayList memory = new ArrayList(23);
        this.memoryManager.allocatePages((Object)this.parentTask, memory, 23);
        SpillingBuffer outView = new SpillingBuffer(this.ioManager, (MemorySegmentSource)new ListMemorySegmentSource(memory), this.memoryManager.getPageSize());
        Tuple2 rec = new Tuple2();
        for (int i2 = 0; i2 < 6000; ++i2) {
            generator.next((Tuple2<Integer, String>)rec);
            serializer.serialize((Object)rec, (DataOutputView)outView);
        }
        DataInputView inView = outView.flip();
        generator.reset();
        Tuple2 readRec = new Tuple2();
        try {
            for (i3 = 0; i3 < 6001; ++i3) {
                generator.next((Tuple2<Integer, String>)rec);
                serializer.deserialize((Object)readRec, inView);
                k1 = (Integer)rec.f0;
                v1 = (String)rec.f1;
                k2 = (Integer)readRec.f0;
                v2 = (String)readRec.f1;
                Assert.assertTrue((String)"The re-generated and the notifyNonEmpty record do not match.", (k1 == k2 && v1.equals(v2) ? 1 : 0) != 0);
            }
            Assert.fail((String)"Read too much, expected EOFException.");
        }
        catch (EOFException i3) {
            // empty catch block
        }
        inView = outView.flip();
        generator.reset();
        for (i3 = 0; i3 < 6000; ++i3) {
            generator.next((Tuple2<Integer, String>)rec);
            serializer.deserialize((Object)readRec, inView);
            k1 = (Integer)rec.f0;
            v1 = (String)rec.f1;
            k2 = (Integer)readRec.f0;
            v2 = (String)readRec.f1;
            Assert.assertTrue((String)"The re-generated and the notifyNonEmpty record do not match.", (k1 == k2 && v1.equals(v2) ? 1 : 0) != 0);
        }
        this.memoryManager.release((Collection)outView.close());
        this.memoryManager.release(memory);
    }

    @Test
    public void testWriteReadExternal() throws Exception {
        String v2;
        int k2;
        String v1;
        int k1;
        int i;
        TestData.TupleGenerator generator = new TestData.TupleGenerator(649180756312423613L, Integer.MAX_VALUE, 114, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
        TypeSerializer<Tuple2<Integer, String>> serializer = TestData.getIntStringTupleSerializer();
        ArrayList memory = new ArrayList(23);
        this.memoryManager.allocatePages((Object)this.parentTask, memory, 23);
        SpillingBuffer outView = new SpillingBuffer(this.ioManager, (MemorySegmentSource)new ListMemorySegmentSource(memory), this.memoryManager.getPageSize());
        Tuple2 rec = new Tuple2();
        for (int i2 = 0; i2 < 30000; ++i2) {
            generator.next((Tuple2<Integer, String>)rec);
            serializer.serialize((Object)rec, (DataOutputView)outView);
        }
        DataInputView inView = outView.flip();
        generator.reset();
        Tuple2 readRec = new Tuple2();
        for (i = 0; i < 30000; ++i) {
            generator.next((Tuple2<Integer, String>)rec);
            serializer.deserialize((Object)readRec, inView);
            k1 = (Integer)rec.f0;
            v1 = (String)rec.f1;
            k2 = (Integer)readRec.f0;
            v2 = (String)readRec.f1;
            Assert.assertTrue((String)"The re-generated and the notifyNonEmpty record do not match.", (k1 == k2 && v1.equals(v2) ? 1 : 0) != 0);
        }
        inView = outView.flip();
        generator.reset();
        for (i = 0; i < 30000; ++i) {
            generator.next((Tuple2<Integer, String>)rec);
            serializer.deserialize((Object)readRec, inView);
            k1 = (Integer)rec.f0;
            v1 = (String)rec.f1;
            k2 = (Integer)readRec.f0;
            v2 = (String)readRec.f1;
            Assert.assertTrue((String)"The re-generated and the notifyNonEmpty record do not match.", (k1 == k2 && v1.equals(v2) ? 1 : 0) != 0);
        }
        this.memoryManager.release((Collection)outView.close());
        this.memoryManager.release(memory);
    }

    @Test
    public void testWriteReadTooMuchExternal() throws Exception {
        String v2;
        int k2;
        String v1;
        int k1;
        int i3;
        TestData.TupleGenerator generator = new TestData.TupleGenerator(649180756312423613L, Integer.MAX_VALUE, 114, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
        TypeSerializer<Tuple2<Integer, String>> serializer = TestData.getIntStringTupleSerializer();
        ArrayList memory = new ArrayList(23);
        this.memoryManager.allocatePages((Object)this.parentTask, memory, 23);
        SpillingBuffer outView = new SpillingBuffer(this.ioManager, (MemorySegmentSource)new ListMemorySegmentSource(memory), this.memoryManager.getPageSize());
        Tuple2 rec = new Tuple2();
        for (int i2 = 0; i2 < 30000; ++i2) {
            generator.next((Tuple2<Integer, String>)rec);
            serializer.serialize((Object)rec, (DataOutputView)outView);
        }
        DataInputView inView = outView.flip();
        generator.reset();
        Tuple2 readRec = new Tuple2();
        try {
            for (i3 = 0; i3 < 30001; ++i3) {
                generator.next((Tuple2<Integer, String>)rec);
                serializer.deserialize((Object)readRec, inView);
                k1 = (Integer)rec.f0;
                v1 = (String)rec.f1;
                k2 = (Integer)readRec.f0;
                v2 = (String)readRec.f1;
                Assert.assertTrue((String)"The re-generated and the notifyNonEmpty record do not match.", (k1 == k2 && v1.equals(v2) ? 1 : 0) != 0);
            }
            Assert.fail((String)"Read too much, expected EOFException.");
        }
        catch (EOFException i3) {
            // empty catch block
        }
        inView = outView.flip();
        generator.reset();
        for (i3 = 0; i3 < 30000; ++i3) {
            generator.next((Tuple2<Integer, String>)rec);
            serializer.deserialize((Object)readRec, inView);
            k1 = (Integer)rec.f0;
            v1 = (String)rec.f1;
            k2 = (Integer)readRec.f0;
            v2 = (String)readRec.f1;
            Assert.assertTrue((String)"The re-generated and the notifyNonEmpty record do not match.", (k1 == k2 && v1.equals(v2) ? 1 : 0) != 0);
        }
        this.memoryManager.release((Collection)outView.close());
        this.memoryManager.release(memory);
    }
}

